/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.config;

import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import com.grim3212.assorted.tools.api.item.ToolsItemTier;
import java.util.function.Supplier;
import net.minecraft.class_1832;

public class ItemTierConfig {
    private final String name;
    private final class_1832 defaultTier;
    public final Supplier<Integer> harvestLevel;
    public final Supplier<Integer> maxUses;
    public final Supplier<Integer> enchantability;
    public final Supplier<Double> efficiency;
    public final Supplier<Double> damage;
    public final Supplier<Double> axeDamage;
    public final Supplier<Double> axeSpeed;
    public final Supplier<Integer> maxBuckets;
    public final Supplier<Integer> milkingLevel;
    public final Supplier<Double> maxPickupTemp;
    public final Supplier<Boolean> breaksAfterUse;
    public final Supplier<Double> multiToolModifier;

    public ItemTierConfig(IConfigurationBuilder builder, String name, String path, class_1832 defaultTier, float defaultAxeDamage, float defaultAxeSpeed, int defaultMaxBuckets, int defaultMilkingLevel, float defaultMaxPickupTemp, boolean defaultBreaksAfterUse, float defaultMultiToolModifier) {
        this.name = name;
        this.defaultTier = defaultTier;
        this.maxUses = builder.defineInteger(path + "." + name + ".maxUses", this.defaultTier.method_8025(), 1, 100000, "The maximum uses for this item tier");
        this.enchantability = builder.defineInteger(path + "." + name + ".enchantability", this.defaultTier.method_8026(), 0, 100000, "The enchantability for this item tier");
        this.harvestLevel = builder.defineInteger(path + "." + name + ".harvestLevel", this.defaultTier.method_8024(), 0, 100, "The harvest level for this item tier");
        this.efficiency = builder.defineDouble(path + "." + name + ".efficiency", (double)this.defaultTier.method_8027(), 0.0, 100000.0, "The efficiency for this item tier");
        this.damage = builder.defineDouble(path + "." + name + ".damage", (double)this.defaultTier.method_8028(), 0.0, 100000.0, "The amount of damage this item tier does");
        this.axeDamage = builder.defineDouble(path + "." + name + ".axeDamage", (double)defaultAxeDamage, 0.0, 100000.0, "The damage modifier for axes as they are different per material. Will not affect vanilla tools.");
        this.axeSpeed = builder.defineDouble(path + "." + name + ".axeSpeed", (double)defaultAxeSpeed, -1000.0, 100000.0, "The speed modifier for axes as they are different per material. Will not affect vanilla tools.");
        this.maxBuckets = builder.defineInteger(path + "." + name + ".maxBuckets", defaultMaxBuckets, 1, 1000, "The maximum number of buckets that this materials bucket can hold.");
        this.milkingLevel = builder.defineInteger(path + "." + name + ".milkingLevel", defaultMilkingLevel, 0, 5, "The milking level that will be set for this materials bucket. By default only 0-3");
        this.maxPickupTemp = builder.defineDouble(path + "." + name + ".maxPickupTemp", (double)defaultMaxPickupTemp, 0.0, 1000000.0, "The maximum temp of a fluid this materials bucket can pickup.");
        this.breaksAfterUse = builder.defineBoolean(path + "." + name + ".breaksAfterUse", defaultBreaksAfterUse, "Is this material so weak that the bucket will break after placing a fluid.");
        this.multiToolModifier = builder.defineDouble(path + "." + name + ".multiToolModifier", (double)defaultMultiToolModifier, 0.0, 1000.0, "The modifier that will be used to calculate the multitool maximum uses. Normal tool material maxUses * this modifier.");
    }

    public ItemTierConfig(IConfigurationBuilder builder, String name, String path, ToolsItemTier defaultTier) {
        this(builder, name, path, defaultTier, defaultTier.getAxeDamage(), defaultTier.getAxeSpeedIn(), defaultTier.getBucketOptions().maxBuckets, defaultTier.getBucketOptions().milkingLevel, defaultTier.getBucketOptions().maxPickupTemp, defaultTier.getBucketOptions().destroyedAfterUse, defaultTier.getMultiToolMod());
    }

    public String getName() {
        return this.name;
    }

    public class_1832 getDefaultTier() {
        return this.defaultTier;
    }

    public int getHarvestLevel() {
        return this.harvestLevel.get();
    }

    public int getMaxUses() {
        return this.maxUses.get();
    }

    public float getEfficiency() {
        return this.efficiency.get().floatValue();
    }

    public float getDamage() {
        return this.damage.get().floatValue();
    }

    public int getEnchantability() {
        return this.enchantability.get();
    }

    public float getAxeDamage() {
        return this.axeDamage.get().floatValue();
    }

    public float getAxeSpeed() {
        return this.axeSpeed.get().floatValue();
    }

    public int getMaxBuckets() {
        return this.maxBuckets.get();
    }

    public int getMilkingLevel() {
        return this.milkingLevel.get();
    }

    public float getMaxPickupTemp() {
        return this.maxPickupTemp.get().floatValue();
    }

    public boolean getBreaksAfterUse() {
        return this.breaksAfterUse.get();
    }

    public float getMultiToolModifier() {
        return this.multiToolModifier.get().floatValue();
    }

    public String toString() {
        return "[Name:" + this.getName() + ", HarvestLevel:" + this.getHarvestLevel() + ", MaxUses:" + this.getMaxUses() + ", Efficiency:" + this.getEfficiency() + ", Damage:" + this.getDamage() + ", Enchantability:" + this.getEnchantability() + ", AxeDamage:" + this.getAxeDamage() + ", AxeSpeed:" + this.getAxeSpeed() + ", MaxBuckets:" + this.getMaxBuckets() + ", MilkingLevel:" + this.getMilkingLevel() + ", MaxPickupTemp:" + this.getMaxPickupTemp() + ", BreaksAfterUse:" + this.getBreaksAfterUse() + "]";
    }
}

