/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.config;

import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import com.grim3212.assorted.tools.api.item.ToolsArmorMaterials;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738;

public class ArmorMaterialConfig {
    private final String name;
    public final Supplier<Integer> durability;
    public final Supplier<Integer> enchantability;
    public final Supplier<Double> toughness;
    public final Supplier<Double> knockbackResistance;
    public final Supplier<Integer> bootsReductionAmount;
    public final Supplier<Integer> leggingsReductionAmount;
    public final Supplier<Integer> chestPlateReductionAmount;
    public final Supplier<Integer> helmetReductionAmount;
    private final Supplier<ToolsArmorMaterials> materialRef;
    private EnumMap<class_1738.class_8051, Integer> cachedReductionAmounts;

    public ArmorMaterialConfig(IConfigurationBuilder builder, String name, String path, int durability, int enchantability, float toughness, float knockbackResistance, int[] reductionAmounts, Supplier<ToolsArmorMaterials> materialRef) {
        this.name = name;
        this.materialRef = materialRef;
        this.durability = builder.defineInteger(path + "." + name + ".durability", durability, 1, 100000, "The durability multiplier for this armor material");
        this.enchantability = builder.defineInteger(path + "." + name + ".enchantability", enchantability, 0, 100000, "The enchantability for this armor material");
        this.toughness = builder.defineDouble(path + "." + name + ".toughness", (double)toughness, 0.0, 100000.0, "The toughness for this armor material");
        this.knockbackResistance = builder.defineDouble(path + "." + name + ".knockbackResistance", (double)knockbackResistance, 0.0, 100000.0, "The knockback resistance for this armor material");
        this.bootsReductionAmount = builder.defineInteger(path + "." + name + ".bootsReductionAmount", reductionAmounts[0], 0, 100000, "The reduction amount for the boots of this armor material");
        this.leggingsReductionAmount = builder.defineInteger(path + "." + name + ".leggingsReductionAmount", reductionAmounts[1], 0, 100000, "The reduction amount for the leggings of this armor material");
        this.chestPlateReductionAmount = builder.defineInteger(path + "." + name + ".chestPlateReductionAmount", reductionAmounts[2], 0, 100000, "The reduction amount for the chestplate of this armor material");
        this.helmetReductionAmount = builder.defineInteger(path + "." + name + ".helmetReductionAmount", reductionAmounts[3], 0, 100000, "The reduction amount for the helmet of this armor material");
    }

    public String getName() {
        return this.name;
    }

    public int getDurability() {
        return this.durability.get();
    }

    public int getBootsReductionAmount() {
        return this.bootsReductionAmount.get();
    }

    public int getLeggingsReductionAmount() {
        return this.leggingsReductionAmount.get();
    }

    public int getChestPlateReductionAmount() {
        return this.chestPlateReductionAmount.get();
    }

    public int getHelmetReductionAmount() {
        return this.helmetReductionAmount.get();
    }

    public EnumMap<class_1738.class_8051, Integer> getReductionAmounts() {
        if (this.cachedReductionAmounts == null) {
            this.cachedReductionAmounts = (EnumMap)class_156.method_654(new EnumMap(class_1738.class_8051.class), map -> {
                map.put(class_1738.class_8051.field_41937, this.getBootsReductionAmount());
                map.put(class_1738.class_8051.field_41936, this.getLeggingsReductionAmount());
                map.put(class_1738.class_8051.field_41935, this.getChestPlateReductionAmount());
                map.put(class_1738.class_8051.field_41934, this.getHelmetReductionAmount());
            });
        }
        return this.cachedReductionAmounts;
    }

    public int getEnchantability() {
        return this.enchantability.get();
    }

    public float getToughness() {
        return this.toughness.get().floatValue();
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance.get().floatValue();
    }

    public ToolsArmorMaterials getMaterial() {
        return this.materialRef.get();
    }

    public String toString() {
        return "[Name:" + this.getName() + ", Durability:" + this.getDurability() + ", ReductionAmounts:" + Arrays.toString((Object[])this.getReductionAmounts().values().toArray(new Integer[0])) + ", Enchantability:" + this.getEnchantability() + ", Toughness:" + this.getToughness() + ", KnockbackResistance:" + this.getKnockbackResistance() + "]";
    }
}

