/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.lib.util.ItemUtil;
import com.grim3212.assorted.lib.util.NBTHelper;
import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.api.ToolsTags;
import com.grim3212.assorted.tools.api.util.WandCoord3D;
import com.grim3212.assorted.tools.common.item.WandItem;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2397;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3542;

public class WandMiningItem
extends WandItem {
    public WandMiningItem(boolean reinforced, class_1792.class_1793 props) {
        super(reinforced, props);
    }

    private static boolean isMiningOre(class_2680 state) {
        return state.method_26164(ToolsTags.Blocks.MINING_SURFACE_BLOCKS);
    }

    @Override
    protected boolean canBreak(class_1937 worldIn, class_2338 pos, class_1799 stack) {
        class_2680 state = worldIn.method_8320(pos);
        switch (MiningMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"))) {
            case MINE_ALL: {
                return !(state.method_26204() == class_2246.field_9987 && ToolsCommonMod.COMMON_CONFIG.bedrockBreaking.get() == false || state.method_26204() == class_2246.field_10540 && ToolsCommonMod.COMMON_CONFIG.easyMiningObsidian.get() == false);
            }
            case MINE_DIRT: {
                return state.method_26164(class_3481.field_29822) || state.method_26204() == class_2246.field_10479 || state.method_26204() == class_2246.field_10566 || state.method_26204() == class_2246.field_10102 || state.method_26204() == class_2246.field_10255 || state.method_26204() instanceof class_2397 || state.method_26204() == class_2246.field_10362 || state.method_26204() == class_2246.field_10477 || state.method_26204() == class_2246.field_10114 || state.method_26204() == class_2246.field_10597 || state.method_26204() instanceof class_2356;
            }
            case MINE_WOOD: {
                return state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15503);
            }
            case MINE_ORES: {
                return !(!WandMiningItem.isMiningOre(state) || state.method_26204() == class_2246.field_9987 && ToolsCommonMod.COMMON_CONFIG.bedrockBreaking.get() == false || state.method_26204() == class_2246.field_10540 && ToolsCommonMod.COMMON_CONFIG.easyMiningObsidian.get() == false);
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2D, class_1799 stack) {
        switch (MiningMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"))) {
            case MINE_ALL: 
            case MINE_DIRT: {
                return range - 250 > maxDiff;
            }
            case MINE_WOOD: {
                return range2D - 400 > maxDiff;
            }
            case MINE_ORES: {
                return range2D - 60 > maxDiff;
            }
        }
        return true;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{0.01, 0.8, 1.0};
    }

    @Override
    protected boolean doEffect(class_1937 world, class_1657 entityplayer, class_1268 hand, WandCoord3D start, WandCoord3D end, class_2680 state) {
        boolean damage = this.doMining(world, start, end, entityplayer, hand);
        if (damage) {
            world.method_8396((class_1657)null, end.pos, class_3417.field_15152, class_3419.field_15245, 2.5f, 0.5f + world.field_9229.method_43057() * 0.3f);
        }
        return damage;
    }

    private boolean doMining(class_1937 world, WandCoord3D start, WandCoord3D end, class_1657 entityplayer, class_1268 hand) {
        class_2680 stateAt;
        int max;
        class_2680 state;
        class_1799 stack = entityplayer.method_5998(hand);
        MiningMode mode = MiningMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        class_2338 startPos = start.pos;
        class_2338 endPos = end.pos;
        if (mode == MiningMode.MINE_ALL && startPos.equals((Object)endPos) && !ToolsCommonMod.COMMON_CONFIG.easyMiningObsidian.get().booleanValue() && (state = world.method_8320(startPos)).method_26204() == class_2246.field_10540) {
            state.method_26204().method_9576(world, startPos, state, entityplayer);
            state.method_26204().method_9556(world, entityplayer, startPos, state, world.method_8321(startPos), entityplayer.method_6030());
            this.particles(world, startPos, 1);
            return true;
        }
        int blocks2Dig = 0;
        boolean isFree = ToolsCommonMod.COMMON_CONFIG.bedrockBreaking.get() != false || entityplayer.method_7337();
        int n = max = this.reinforced || isFree ? 1024 : 512;
        if (mode == MiningMode.MINE_ORES) {
            class_2680 stateAt2;
            if (!this.reinforced) {
                this.error(entityplayer, end, "cantminesurface");
                return false;
            }
            List iterable = class_2338.method_20437((class_2338)new class_2338(start.pos.method_10263(), 1, start.pos.method_10260()), (class_2338)new class_2338(end.pos.method_10263(), end.pos.method_10264() + 1, end.pos.method_10260())).map(class_2338::method_10062).collect(Collectors.toList());
            for (class_2338 pos : iterable) {
                stateAt2 = world.method_8320(pos);
                if (!WandMiningItem.isMiningOre(stateAt2)) continue;
                if (stateAt2.method_26204() == class_2246.field_10080 || stateAt2.method_26204() == class_2246.field_10090) {
                    blocks2Dig += 4;
                    continue;
                }
                ++blocks2Dig;
            }
            if (blocks2Dig - max > 10) {
                this.sendMessage(entityplayer, (class_2561)class_2561.method_43469((String)"error.wand.toomany", (Object[])new Object[]{blocks2Dig, max}));
                return true;
            }
            int surface = 127;
            long cnt = 0L;
            for (int X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                for (int Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                    boolean underground = false;
                    for (int Y = 127; Y > 1; --Y) {
                        class_2338 pos = new class_2338(X, Y, Z);
                        stateAt2 = world.method_8320(pos);
                        if (!underground && world.method_22347(pos)) {
                            surface = Y;
                        }
                        boolean surfaceBlock = this.isSurface(stateAt2);
                        if (!underground && surfaceBlock) {
                            underground = true;
                        }
                        if (!WandMiningItem.isMiningOre(stateAt2)) continue;
                        class_2586 tile = world.method_8321(pos);
                        if (!world.method_8501(pos, class_2246.field_10340.method_9564())) continue;
                        pos = new class_2338(X, surface, Z);
                        stateAt2.method_26204().method_9576(world, pos, stateAt2, entityplayer);
                        stateAt2.method_26204().method_9556(world, entityplayer, pos, stateAt2, tile, entityplayer.method_6030());
                        ++cnt;
                    }
                }
            }
            if (cnt == 0L) {
                if (!world.field_9236) {
                    this.sendMessage(entityplayer, (class_2561)class_2561.method_43471((String)"result.wand.mine"));
                }
                return false;
            }
            return true;
        }
        List iterable = class_2338.method_20437((class_2338)startPos, (class_2338)endPos).map(class_2338::method_10062).collect(Collectors.toList());
        for (class_2338 pos : iterable) {
            stateAt = world.method_8320(pos);
            if (!this.canBreak(world, pos, stack)) continue;
            if (stateAt.method_26204() == class_2246.field_10080 || stateAt.method_26204() == class_2246.field_10090) {
                blocks2Dig += 4;
                continue;
            }
            ++blocks2Dig;
        }
        if (blocks2Dig > max) {
            this.sendMessage(entityplayer, (class_2561)class_2561.method_43469((String)"error.wand.toomany", (Object[])new Object[]{blocks2Dig, this.reinforced || isFree ? 1024 : 512}));
            return false;
        }
        if (blocks2Dig == 0) {
            if (!world.field_9236) {
                this.error(entityplayer, end, "nowork");
            }
            return false;
        }
        iterable = class_2338.method_20437((class_2338)startPos, (class_2338)endPos).map(class_2338::method_10062).collect(Collectors.toList());
        for (class_2338 newPos : iterable) {
            stateAt = world.method_8320(newPos);
            if (!this.canBreak(world, newPos, stack) || !ItemUtil.destroyBlock((class_2338)newPos, (class_1937)world, (class_1657)entityplayer)) continue;
            class_2586 tile = world.method_8321(newPos);
            stateAt.method_26204().method_9556(world, entityplayer, newPos, stateAt, tile, entityplayer.method_6030());
            if (this.rand.nextInt(blocks2Dig / 50 + 1) != 0) continue;
            this.particles(world, newPos, 1);
        }
        return true;
    }

    @Override
    public class_1799 cycleMode(class_1657 player, class_1799 stack) {
        MiningMode mode = MiningMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        MiningMode next = MiningMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)next.method_15434());
        this.sendMessage(player, (class_2561)class_2561.method_43469((String)"assortedtools.wand.switched", (Object[])new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        MiningMode mode = MiningMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        if (mode != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"assortedtools.wand.current", (Object[])new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"assortedtools.broken"));
        }
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)MiningMode.MINE_ALL.method_15434());
    }

    public static enum MiningMode implements class_3542
    {
        MINE_ALL("mineall", 0),
        MINE_DIRT("minedirt", 1),
        MINE_WOOD("minewood", 2),
        MINE_ORES("mineores", 3, true);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<MiningMode> values;
        private static final List<MiningMode> notReinforced;

        private MiningMode(String name, int order) {
            this(name, order, false);
        }

        private MiningMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static MiningMode getNext(MiningMode current, class_1799 stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static MiningMode fromString(String type) {
            for (MiningMode mode : values) {
                if (!mode.method_15434().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String method_15434() {
            return this.name;
        }

        public class_2561 getTranslatedString() {
            return class_2561.method_43471((String)("assortedtools.wand.mode." + this.name));
        }

        static {
            values = Lists.newArrayList((Object[])MiningMode.values()).stream().sorted(Comparator.comparingInt(MiningMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(MiningMode::getOrder)).collect(Collectors.toList());
        }
    }
}

