/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.NBTHelper;
import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.api.item.ISwitchModes;
import com.grim3212.assorted.tools.api.util.WandCoord3D;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;

public abstract class WandItem
extends class_1792
implements ISwitchModes {
    protected final boolean reinforced;
    protected Random rand;
    protected class_2680 stateOrig = class_2246.field_10124.method_9564();
    protected class_2680 stateClicked = class_2246.field_10124.method_9564();

    public WandItem(boolean reinforced, class_1792.class_1793 properties) {
        super(properties);
        this.reinforced = reinforced;
        this.rand = new Random();
    }

    public abstract void method_7843(class_1799 var1, class_1937 var2, class_1657 var3);

    protected abstract boolean canBreak(class_1937 var1, class_2338 var2, class_1799 var3);

    public class_1799 getNeededItem(class_1937 world, class_2680 state, class_1657 player) {
        return Services.LEVEL_PROPERTIES.getCloneItemStack(state, null, (class_1922)world, class_2338.field_10980, player);
    }

    public int getNeededCount(class_2680 state) {
        if (state.method_26204() instanceof class_2482) {
            return 2;
        }
        return 1;
    }

    public boolean isSurface(class_2680 state) {
        return state.method_26204() == class_2246.field_10566 || state.method_26204() == class_2246.field_10479 || state.method_26204() == class_2246.field_10340 || state.method_26204() == class_2246.field_10255 || state.method_26204() == class_2246.field_9979 || state.method_26204() == class_2246.field_10102 || state.method_26204() == class_2246.field_9987 || state.method_26204() == class_2246.field_10418 || state.method_26204() == class_2246.field_10212 || state.method_26204() == class_2246.field_10571 || state.method_26204() == class_2246.field_10442 || state.method_26204() == class_2246.field_10090;
    }

    protected abstract boolean isTooFar(int var1, int var2, int var3, class_1799 var4);

    public boolean isTooFar(WandCoord3D a, WandCoord3D b, class_1799 stack) {
        if (ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
            return (double)a.getDistance(b) > 1500.0;
        }
        return this.isTooFar((int)a.getDistance(b), 10, (int)a.getDistanceFlat(b), stack);
    }

    protected abstract boolean doEffect(class_1937 var1, class_1657 var2, class_1268 var3, WandCoord3D var4, WandCoord3D var5, class_2680 var6);

    protected void sendMessage(class_1657 player, class_2561 message) {
        if (!player.method_37908().field_9236) {
            player.method_43496(message);
        }
    }

    protected void error(class_1657 entityplayer, WandCoord3D p, String reason) {
        entityplayer.method_37908().method_8396(entityplayer, p.pos, class_3417.field_19198, class_3419.field_15245, (entityplayer.method_37908().field_9229.method_43057() + 0.7f) / 2.0f, 0.5f + entityplayer.method_37908().field_9229.method_43057() * 0.3f);
        this.sendMessage(entityplayer, (class_2561)class_2561.method_43471((String)("error.wand." + reason)));
        this.particles(entityplayer.method_37908(), p.pos, 3);
    }

    protected abstract double[] getParticleColor();

    private void particles(class_1937 world, WandCoord3D c, int effect) {
        this.particles(world, c.pos, effect);
    }

    protected void particles(class_1937 world, class_2338 pos, int effect) {
        double d = 0.0625;
        if (effect == 1) {
            world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        if (effect == 2) {
            world.method_8406((class_2394)class_2398.field_11202, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        double R = 0.0;
        double G = 0.0;
        double B = 0.0;
        if (effect == 0) {
            double[] color = this.getParticleColor();
            R = color[0];
            G = color[1];
            B = color[2];
        } else {
            R = 0.8;
        }
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)pos.method_10263() + this.rand.nextFloat();
            double d2 = (float)pos.method_10264() + this.rand.nextFloat();
            double d3 = (float)pos.method_10260() + this.rand.nextFloat();
            if (l == 0 && !world.method_8320(pos.method_10084()).method_26216((class_1922)world, pos)) {
                d2 = (double)(pos.method_10264() + 1) + d;
            }
            if (l == 1 && !world.method_8320(pos.method_10074()).method_26216((class_1922)world, pos)) {
                d2 = (double)(pos.method_10264() + 0) - d;
            }
            if (l == 2 && !world.method_8320(pos.method_10072()).method_26216((class_1922)world, pos)) {
                d3 = (double)(pos.method_10260() + 1) + d;
            }
            if (l == 3 && !world.method_8320(pos.method_10095()).method_26216((class_1922)world, pos)) {
                d3 = (double)(pos.method_10260() + 0) - d;
            }
            if (l == 4 && !world.method_8320(pos.method_10078()).method_26216((class_1922)world, pos)) {
                d1 = (double)(pos.method_10263() + 1) + d;
            }
            if (l == 5 && !world.method_8320(pos.method_10067()).method_26216((class_1922)world, pos)) {
                d1 = (double)(pos.method_10263() + 0) - d;
            }
            if (!(d1 < (double)pos.method_10263() || d1 > (double)(pos.method_10263() + 1) || d2 < 0.0 || d2 > (double)(pos.method_10264() + 1) || d3 < (double)pos.method_10260()) && !(d3 > (double)(pos.method_10260() + 1))) continue;
            world.method_8406((class_2394)class_2390.field_11188, d1, d2, d3, R, G, B);
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 worldIn = context.method_8045();
        class_1657 playerIn = context.method_8036();
        class_1268 hand = context.method_20287();
        boolean isFree = ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get() != false || playerIn.method_7337();
        this.stateOrig = worldIn.method_8320(pos);
        class_2680 state = this.stateOrig;
        if (state.method_26204() == class_2246.field_10479) {
            state = class_2246.field_10566.method_9564();
        }
        WandCoord3D clicked_current = new WandCoord3D(pos, state);
        if (this.isIncompatible(state)) {
            this.error(playerIn, clicked_current, "cantbuild");
            return class_1269.field_5812;
        }
        class_1799 stack = playerIn.method_5998(hand);
        WandCoord3D start = WandCoord3D.getFromNBT(worldIn, stack.method_7969(), "Start");
        if (start == null) {
            class_2498 soundType = Services.LEVEL_PROPERTIES.getSoundType((class_4538)worldIn, pos, null);
            worldIn.method_8396((class_1657)null, pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            this.stateClicked = state;
            clicked_current.writeToNBT(stack.method_7969(), "Start");
            this.particles(worldIn, clicked_current, 0);
            NBTHelper.putBoolean((class_1799)stack, (String)"firstUse", (boolean)false);
            return class_1269.field_5812;
        }
        if (NBTHelper.getBoolean((class_1799)stack, (String)"firstUse")) {
            NBTHelper.removeTag((class_1799)stack, (String)"Start");
            this.error(playerIn, clicked_current, "nostart");
            return class_1269.field_5812;
        }
        WandCoord3D.findEnds(start, clicked_current);
        if (this.isTooFar(start, clicked_current, stack)) {
            NBTHelper.removeTag((class_1799)stack, (String)"Start");
            this.error(playerIn, clicked_current, "toofar");
            return class_1269.field_5812;
        }
        boolean damage = this.doEffect(worldIn, playerIn, hand, start, clicked_current, state);
        if (damage) {
            NBTHelper.putBoolean((class_1799)stack, (String)"firstUse", (boolean)true);
            if (!isFree) {
                NBTHelper.removeTag((class_1799)stack, (String)"Start");
                stack.method_7956(1, (class_1309)playerIn, s -> s.method_20236(hand));
                return class_1269.field_5812;
            }
        }
        NBTHelper.removeTag((class_1799)stack, (String)"Start");
        return class_1269.field_5812;
    }

    protected boolean isIncompatible(class_2680 state) {
        return false;
    }
}

