/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.lib.util.NBTHelper;
import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.api.util.WandCoord3D;
import com.grim3212.assorted.tools.common.item.WandItem;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2404;
import net.minecraft.class_2440;
import net.minecraft.class_2478;
import net.minecraft.class_2527;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3619;

public class WandBuildingItem
extends WandItem {
    public WandBuildingItem(boolean reinforced, class_1792.class_1793 props) {
        super(reinforced, props);
    }

    @Override
    protected boolean canBreak(class_1937 worldIn, class_2338 pos, class_1799 stack) {
        class_2680 state = worldIn.method_8320(pos);
        if (state.method_45474() || state.method_26223() == class_3619.field_15971 || state.method_51176()) {
            return true;
        }
        switch (BuildingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"))) {
            case BUILD_BOX: 
            case BUILD_ROOM: 
            case BUILD_FRAME: 
            case BUILD_CAVES: {
                return state.method_26204() instanceof class_2404;
            }
            case BUILD_WATER: 
            case BUILD_LAVA: {
                return state.method_26204() == class_2246.field_10336 || state.method_26204() instanceof class_2404;
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2D, class_1799 stack) {
        switch (BuildingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"))) {
            case BUILD_BOX: 
            case BUILD_ROOM: 
            case BUILD_FRAME: 
            case BUILD_WATER: 
            case BUILD_LAVA: 
            case BUILD_TORCHES: {
                return range - 400 > maxDiff;
            }
            case BUILD_CAVES: {
                return range2D - 1600 > maxDiff;
            }
        }
        return true;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{1.0, 0.8, 0.0};
    }

    @Override
    protected boolean isIncompatible(class_2680 state) {
        return state.method_26204() == class_2246.field_10124 || state.method_26204() == class_2246.field_10008 || state.method_26204() == class_2246.field_10379 || state.method_26204() instanceof class_2244 || state.method_26204() instanceof class_2323 || state.method_26204() instanceof class_2478;
    }

    private boolean canPlace(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        if (this.canBreak(world, pos, player.method_5998(hand))) {
            if (player.method_31549().field_7476) {
                return true;
            }
            if (state.method_26204() == class_2246.field_10029 || state.method_26204() == class_2246.field_10424 || state.method_26204() == class_2246.field_10091 || state.method_26204() instanceof class_2440 || state.method_26204() == class_2246.field_10477) {
                return false;
            }
            return !(state.method_26204() instanceof class_2527) && !(state.method_26204() instanceof class_2356);
        }
        return false;
    }

    protected boolean consumeItems(class_1799 neededStack, class_1657 entityplayer, int neededItems, WandCoord3D end) {
        class_1799 currentItem;
        int t;
        if (ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue() || entityplayer.method_7337()) {
            return true;
        }
        int invItems = 0;
        for (t = 0; t < entityplayer.method_31548().method_5439() && ((currentItem = entityplayer.method_31548().method_5438(t)).method_7960() || !class_1799.method_7984((class_1799)currentItem, (class_1799)neededStack) || (invItems += currentItem.method_7947()) != neededItems); ++t) {
        }
        if (neededItems > invItems) {
            this.sendMessage(entityplayer, (class_2561)class_2561.method_43469((String)"error.wand.toofewitems", (Object[])new Object[]{neededItems, invItems}));
            return false;
        }
        for (t = entityplayer.method_31548().method_5439() - 1; t >= 0; --t) {
            currentItem = entityplayer.method_31548().method_5438(t);
            if (currentItem.method_7960() || !class_1799.method_7984((class_1799)currentItem, (class_1799)neededStack)) continue;
            int stackSize = currentItem.method_7947();
            if (stackSize < neededItems) {
                entityplayer.method_31548().method_5447(t, class_1799.field_8037);
                neededItems -= stackSize;
                continue;
            }
            if (stackSize < neededItems) continue;
            entityplayer.method_31548().method_5434(t, neededItems);
            neededItems = 0;
            break;
        }
        return true;
    }

    private boolean emptyBuckets(class_1657 entityplayer, int neededItems, boolean lava) {
        class_1799 currentItem;
        int t;
        class_1792 vanillaBucket;
        class_1792 class_17922 = vanillaBucket = lava ? class_1802.field_8187 : class_1802.field_8705;
        if (ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue() || entityplayer.method_7337()) {
            return true;
        }
        int itemsInInventory = 0;
        for (t = 0; t < entityplayer.method_31548().method_5439(); ++t) {
            currentItem = entityplayer.method_31548().method_5438(t);
            if (currentItem.method_7960() || currentItem.method_7909() != vanillaBucket) continue;
            ++itemsInInventory;
        }
        if (itemsInInventory < neededItems) {
            return false;
        }
        for (t = entityplayer.method_31548().method_5439() - 1; t >= 0; --t) {
            currentItem = entityplayer.method_31548().method_5438(t);
            if (currentItem.method_7960() || currentItem.method_7909() != vanillaBucket) continue;
            entityplayer.method_31548().method_5447(t, class_1799.field_8037);
            entityplayer.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8550));
            if (--neededItems != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEffect(class_1937 world, class_1657 entityplayer, class_1268 hand, WandCoord3D start, WandCoord3D end, class_2680 state) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString((class_1799)entityplayer.method_5998(hand), (String)"Mode"));
        if (state != this.stateClicked && (mode == BuildingMode.BUILD_BOX || mode == BuildingMode.BUILD_ROOM || mode == BuildingMode.BUILD_FRAME || mode == BuildingMode.BUILD_TORCHES)) {
            this.error(entityplayer, end, "notsamecorner");
            return false;
        }
        boolean flag = this.doBuilding(world, start, end, mode, entityplayer, hand, state);
        if (flag && mode != BuildingMode.BUILD_WATER && mode != BuildingMode.BUILD_LAVA) {
            world.method_8396((class_1657)null, end.pos, class_3417.field_14600, class_3419.field_15245, (world.field_9229.method_43057() + 0.7f) / 2.0f, 1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.4f);
        }
        if (flag && mode == BuildingMode.BUILD_WATER) {
            world.method_8396((class_1657)null, end.pos, class_3417.field_14810, class_3419.field_15245, (world.field_9229.method_43057() + 0.7f) / 2.0f, 1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.4f);
        }
        if (flag && mode == BuildingMode.BUILD_WATER) {
            world.method_8396((class_1657)null, end.pos, class_3417.field_14576, class_3419.field_15245, (world.field_9229.method_43057() + 0.7f) / 2.0f, 1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.4f);
        }
        return flag;
    }

    private boolean doBuilding(class_1937 world, WandCoord3D start, WandCoord3D end, BuildingMode mode, class_1657 entityplayer, class_1268 hand, class_2680 state) {
        int X = 0;
        int Y = 0;
        int Z = 0;
        class_2680 stateAt = class_2246.field_10124.method_9564();
        class_1799 neededStack = this.getNeededItem(world, state, entityplayer);
        int multiplier = this.getNeededCount(state);
        int neededItems = 0;
        int affected = 0;
        switch (mode) {
            case BUILD_BOX: {
                neededItems = 0;
                for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                    for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                        for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                            if (!this.canPlace(world, new class_2338(X, Y, Z), state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_9236) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                class_2338 newPos = new class_2338(X, Y, Z);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.method_8652(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.method_26204() == class_2246.field_10479 && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.method_10264();
                            }
                            if (run == 1) {
                                Y = end.pos.method_10264();
                            }
                            for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                                for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                                    class_2338 newPos = new class_2338(X, Y, Z);
                                    if (world.method_8320(newPos).method_26204() != class_2246.field_10566 || world.method_8320(newPos.method_10084()).method_26204() != null && world.method_8320(newPos.method_10084()).method_26216((class_1922)world, newPos.method_10084())) continue;
                                    world.method_8501(newPos, class_2246.field_10479.method_9564());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_ROOM: {
                neededItems = 0;
                for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                    for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                        for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                            if (X != start.pos.method_10263() && Y != start.pos.method_10264() && Z != start.pos.method_10260() && X != end.pos.method_10263() && Y != end.pos.method_10264() && Z != end.pos.method_10260() || !this.canPlace(world, new class_2338(X, Y, Z), state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_9236) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                class_2338 newPos = new class_2338(X, Y, Z);
                                if (X != start.pos.method_10263() && Y != start.pos.method_10264() && Z != start.pos.method_10260() && X != end.pos.method_10263() && Y != end.pos.method_10264() && Z != end.pos.method_10260() || !this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.method_8652(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.method_26204() == class_2246.field_10479 && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.method_10264();
                            }
                            if (run == 1) {
                                Y = end.pos.method_10264();
                            }
                            for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                                for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                                    class_2338 newPos = new class_2338(X, Y, Z);
                                    if (world.method_8320(newPos).method_26204() != class_2246.field_10566 || world.method_8320(newPos.method_10084()).method_26204() != null && world.method_8320(newPos.method_10084()).method_26216((class_1922)world, newPos.method_10084())) continue;
                                    world.method_8501(newPos, class_2246.field_10479.method_9564());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_FRAME: {
                neededItems = 0;
                for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                    for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                        for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                            if (!(X == start.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == start.pos.method_10263() || X == start.pos.method_10263() && Y == end.pos.method_10264() || X == end.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == end.pos.method_10260() || Y == end.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == end.pos.method_10263() || Z == end.pos.method_10260() && X == start.pos.method_10263() || X == end.pos.method_10263() && Y == end.pos.method_10264() || Y == end.pos.method_10264() && Z == end.pos.method_10260()) && (Z != end.pos.method_10260() || X != end.pos.method_10263() || !this.canPlace(world, new class_2338(X, Y, Z), state, entityplayer, hand))) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_9236) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                if (!(X == start.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == start.pos.method_10263() || X == start.pos.method_10263() && Y == end.pos.method_10264() || X == end.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == end.pos.method_10260() || Y == end.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == end.pos.method_10263() || Z == end.pos.method_10260() && X == start.pos.method_10263() || X == end.pos.method_10263() && Y == end.pos.method_10264() || Y == end.pos.method_10264() && Z == end.pos.method_10260()) && (Z != end.pos.method_10260() || X != end.pos.method_10263())) continue;
                                class_2338 newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.method_8652(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.method_26204() == class_2246.field_10479 && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.method_10264();
                            }
                            if (run == 1) {
                                Y = end.pos.method_10264();
                            }
                            for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                                for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                                    class_2338 newPos = new class_2338(X, Y, Z);
                                    if (!(X == start.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == start.pos.method_10263() || X == start.pos.method_10263() && Y == end.pos.method_10264() || X == end.pos.method_10263() && Y == start.pos.method_10264() || Y == start.pos.method_10264() && Z == end.pos.method_10260() || Y == end.pos.method_10264() && Z == start.pos.method_10260() || Z == start.pos.method_10260() && X == end.pos.method_10263() || Z == end.pos.method_10260() && X == start.pos.method_10263() || X == end.pos.method_10263() && Y == end.pos.method_10264() || Y == end.pos.method_10264() && Z == end.pos.method_10260()) && (Z != end.pos.method_10260() || X != end.pos.method_10263() || world.method_8320(newPos).method_26204() != class_2246.field_10566 || world.method_8320(newPos.method_10084()).method_26204() != null && world.method_8320(newPos.method_10084()).method_26216((class_1922)world, newPos.method_10084()))) continue;
                                    world.method_8501(newPos, class_2246.field_10479.method_9564());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_TORCHES: {
                class_2338 newPos;
                neededItems = 0;
                for (X = start.pos.method_10263(); X <= end.pos.method_10263(); X += 5) {
                    for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); Z += 5) {
                        for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                            newPos = new class_2338(X, Y, Z);
                            stateAt = world.method_8320(newPos);
                            if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_9236) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); X += 5) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); Z += 5) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.method_8652(newPos, state, 3);
                                this.particles(world, newPos, 0);
                                ++affected;
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_WATER: {
                class_2338 newPos;
                if (!this.reinforced && !ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
                    this.error(entityplayer, end, "cantfillwater");
                    return false;
                }
                if (!ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
                    neededItems = 0;
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_9236) {
                            this.error(entityplayer, end, "nowork");
                        }
                        return false;
                    }
                }
                if (this.emptyBuckets(entityplayer, 2, false)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                                world.method_8501(newPos, class_2246.field_10382.method_9564());
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (stateAt.method_26204() != class_2246.field_10382) continue;
                                world.method_8452(newPos, class_2246.field_10382);
                                if (world.method_8320(newPos.method_10084()).method_26204() != class_2246.field_10124) continue;
                                this.particles(world, newPos, 2);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, end, "toofewwater");
                return false;
            }
            case BUILD_LAVA: {
                class_2338 newPos;
                if (!this.reinforced && !ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
                    this.error(entityplayer, end, "cantfilllava");
                    return false;
                }
                neededItems = 0;
                if (!ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_9236) {
                            this.error(entityplayer, end, "nowork");
                        }
                        return false;
                    }
                }
                if (this.emptyBuckets(entityplayer, neededItems, true)) {
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                                world.method_8501(newPos, class_2246.field_10164.method_9564());
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                        for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                                newPos = new class_2338(X, Y, Z);
                                stateAt = world.method_8320(newPos);
                                if (stateAt.method_26204() != class_2246.field_10164) continue;
                                world.method_8452(newPos, class_2246.field_10164);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, end, "toofewlava");
                return false;
            }
            case BUILD_CAVES: {
                if (!this.reinforced && !ToolsCommonMod.COMMON_CONFIG.freeBuildMode.get().booleanValue()) {
                    this.error(entityplayer, end, "cantfillcave");
                    return false;
                }
                boolean underground = false;
                long cnt = 0L;
                for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
                    for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                        underground = false;
                        for (Y = 127; Y > 1; --Y) {
                            class_2338 newPos = new class_2338(X, Y, Z);
                            stateAt = world.method_8320(newPos);
                            boolean surfaceBlock = this.isSurface(stateAt);
                            if (!underground && surfaceBlock) {
                                underground = true;
                                continue;
                            }
                            if (!underground || !this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                            world.method_8501(newPos, class_2246.field_10340.method_9564());
                            ++cnt;
                        }
                    }
                }
                if (cnt > 0L) {
                    if (!world.field_9236) {
                        this.sendMessage(entityplayer, (class_2561)class_2561.method_43469((String)"result.wand.fill", (Object[])new Object[]{cnt}));
                    }
                    return true;
                }
                if (!world.field_9236) {
                    this.error(entityplayer, end, "nocave");
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public class_1799 cycleMode(class_1657 player, class_1799 stack) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        BuildingMode next = BuildingMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)next.method_15434());
        this.sendMessage(player, (class_2561)class_2561.method_43469((String)"assortedtools.wand.switched", (Object[])new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        if (mode != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"assortedtools.wand.current", (Object[])new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"assortedtools.wand.broken"));
        }
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)BuildingMode.BUILD_BOX.method_15434());
    }

    public static enum BuildingMode implements class_3542
    {
        BUILD_BOX("buildbox", 0),
        BUILD_ROOM("buildroom", 1),
        BUILD_FRAME("buildframe", 2),
        BUILD_TORCHES("buildtorches", 3),
        BUILD_WATER("buildwater", 4, true),
        BUILD_LAVA("buildlava", 5, true),
        BUILD_CAVES("buildcaves", 6, true);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<BuildingMode> values;
        private static final List<BuildingMode> notReinforced;

        private BuildingMode(String name, int order) {
            this(name, order, false);
        }

        private BuildingMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static BuildingMode getNext(BuildingMode current, class_1799 stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static BuildingMode fromString(String type) {
            for (BuildingMode mode : values) {
                if (!mode.method_15434().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String method_15434() {
            return this.name;
        }

        public class_2561 getTranslatedString() {
            return class_2561.method_43471((String)("assortedtools.wand.mode." + this.name));
        }

        static {
            values = Lists.newArrayList((Object[])BuildingMode.values()).stream().sorted(Comparator.comparingInt(BuildingMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(BuildingMode::getOrder)).collect(Collectors.toList());
        }
    }
}

