/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.lib.util.NBTHelper;
import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.api.ToolsTags;
import com.grim3212.assorted.tools.api.util.WandCoord3D;
import com.grim3212.assorted.tools.common.item.WandItem;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3619;

public class WandBreakingItem
extends WandItem {
    public WandBreakingItem(boolean reinforced, class_1792.class_1793 props) {
        super(reinforced, props);
    }

    protected static boolean isOre(class_2680 state) {
        return state.method_26164(ToolsTags.Blocks.DESTRUCTIVE_SPARED_BLOCKS);
    }

    @Override
    protected boolean canBreak(class_1937 worldIn, class_2338 pos, class_1799 stack) {
        class_2680 state = worldIn.method_8320(pos);
        switch (BreakingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"))) {
            case BREAK_WEAK: {
                return state.method_45474() || state.method_26223() == class_3619.field_15971 || state.method_51176();
            }
            case BREAK_ALL: {
                return state.method_26204() != class_2246.field_9987 || ToolsCommonMod.COMMON_CONFIG.bedrockBreaking.get() != false;
            }
            case BREAK_XORES: {
                return (state.method_26204() != class_2246.field_9987 || ToolsCommonMod.COMMON_CONFIG.bedrockBreaking.get() != false) && !WandBreakingItem.isOre(state);
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2d, class_1799 stack) {
        return range - 250 > maxDiff;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{0.5, 0.5, 0.5};
    }

    @Override
    protected boolean doEffect(class_1937 world, class_1657 entityplayer, class_1268 hand, WandCoord3D start, WandCoord3D end, class_2680 state) {
        boolean damage = this.doBreaking(world, start, end, entityplayer, hand);
        if (damage) {
            world.method_8396((class_1657)null, end.pos, class_3417.field_15152, class_3419.field_15245, 2.5f, 0.5f + world.field_9229.method_43057() * 0.3f);
        }
        return damage;
    }

    private boolean doBreaking(class_1937 world, WandCoord3D start, WandCoord3D end, class_1657 entityplayer, class_1268 hand) {
        class_2680 stateAt;
        class_2338 newPos;
        int Z;
        int Y;
        int X;
        int cnt = 0;
        for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                    newPos = new class_2338(X, Y, Z);
                    stateAt = world.method_8320(newPos);
                    if (stateAt.method_26204() == class_2246.field_10124 || !this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                    ++cnt;
                }
            }
        }
        if (cnt == 0) {
            if (!world.field_9236) {
                this.error(entityplayer, end, "nowork");
            }
            return false;
        }
        for (X = start.pos.method_10263(); X <= end.pos.method_10263(); ++X) {
            for (Y = start.pos.method_10264(); Y <= end.pos.method_10264(); ++Y) {
                for (Z = start.pos.method_10260(); Z <= end.pos.method_10260(); ++Z) {
                    newPos = new class_2338(X, Y, Z);
                    stateAt = world.method_8320(newPos);
                    if (stateAt.method_26204() == class_2246.field_10124 || !this.canBreak(world, newPos, entityplayer.method_5998(hand))) continue;
                    stateAt.method_26204().method_9576(world, newPos, stateAt, entityplayer);
                    world.method_8501(newPos, class_2246.field_10124.method_9564());
                    if (this.rand.nextInt(cnt / 50 + 1) != 0) continue;
                    this.particles(world, newPos, 1);
                }
            }
        }
        return true;
    }

    @Override
    public class_1799 cycleMode(class_1657 player, class_1799 stack) {
        BreakingMode mode = BreakingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        BreakingMode next = BreakingMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)next.method_15434());
        this.sendMessage(player, (class_2561)class_2561.method_43469((String)"assortedtools.wand.switched", (Object[])new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        BreakingMode mode = BreakingMode.fromString(NBTHelper.getString((class_1799)stack, (String)"Mode"));
        if (mode != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"assortedtools.wand.current", (Object[])new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"assortedtools.broken"));
        }
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        NBTHelper.putString((class_1799)stack, (String)"Mode", (String)BreakingMode.BREAK_WEAK.method_15434());
    }

    public static enum BreakingMode implements class_3542
    {
        BREAK_WEAK("breakweak", 0),
        BREAK_ALL("breakall", 1),
        BREAK_XORES("breakxores", 2);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<BreakingMode> values;
        private static final List<BreakingMode> notReinforced;

        private BreakingMode(String name, int order) {
            this(name, order, false);
        }

        private BreakingMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static BreakingMode getNext(BreakingMode current, class_1799 stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static BreakingMode fromString(String type) {
            for (BreakingMode mode : values) {
                if (!mode.method_15434().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String method_15434() {
            return this.name;
        }

        public class_2561 getTranslatedString() {
            return class_2561.method_43471((String)("assortedtools.wand.mode." + this.name));
        }

        static {
            values = Lists.newArrayList((Object[])BreakingMode.values()).stream().sorted(Comparator.comparingInt(BreakingMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(BreakingMode::getOrder)).collect(Collectors.toList());
        }
    }
}

