/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.common.item.BetterBucketItem;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FabricBetterBucketFluidHandler
implements SingleSlotStorage<FluidVariant> {
    private final ContainerItemContext context;

    public FabricBetterBucketFluidHandler(ContainerItemContext context) {
        this.context = context;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        int currentAmount;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1792 class_17922 = this.context.getItemVariant().getItem();
        if (!(class_17922 instanceof BetterBucketItem)) {
            return 0L;
        }
        BetterBucketItem bucket = (BetterBucketItem)class_17922;
        class_1799 stack = this.context.getItemVariant().toStack();
        if (BetterBucketItem.isEmptyOrContains(stack, BetterBucketItem.getStringFromFluid(resource.getFluid())) && (currentAmount = BetterBucketItem.getAmount(stack)) < bucket.getMaximumMillibuckets()) {
            int newMax = (int)maxAmount;
            int newAmount = currentAmount + newMax;
            int leftOver = newAmount - bucket.getMaximumMillibuckets();
            int returnAmount = newMax;
            if (leftOver >= 0) {
                returnAmount = newMax - leftOver;
            } else if (!ToolsCommonMod.COMMON_CONFIG.allowPartialBucketAmounts.get().booleanValue()) {
                int bucketLeftOver = newMax % BetterBucketItem.getBucketAmount();
                newAmount -= bucketLeftOver;
                returnAmount = newMax - bucketLeftOver;
            }
            BetterBucketItem.setAmount(stack, Math.min(newAmount, bucket.getMaximumMillibuckets()));
            ItemVariant newVariant = ItemVariant.of((class_1799)stack);
            if (this.context.exchange(newVariant, 1L, transaction) == 1L) {
                return returnAmount;
            }
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1792 class_17922 = this.context.getItemVariant().getItem();
        if (!(class_17922 instanceof BetterBucketItem)) {
            return 0L;
        }
        BetterBucketItem bucket = (BetterBucketItem)class_17922;
        class_1799 stack = this.context.getItemVariant().toStack();
        String stored = BetterBucketItem.getFluid(stack);
        if (stored.equals(BetterBucketItem.getStringFromFluid(resource.getFluid())) && !BetterBucketItem.getFluidFromString(stored).method_15780(class_3612.field_15906)) {
            ItemVariant newVariant;
            int newAmount;
            int newMax;
            int currentAmount = BetterBucketItem.getAmount(stack);
            int returnAmount = newMax = (int)maxAmount;
            if (newMax > bucket.getMaximumMillibuckets()) {
                newMax = bucket.getMaximumMillibuckets();
            }
            if ((newAmount = currentAmount - newMax) < 0) {
                returnAmount = newMax + newAmount;
                newAmount = 0;
            } else if (!ToolsCommonMod.COMMON_CONFIG.allowPartialBucketAmounts.get().booleanValue()) {
                int bucketLeftOver = newMax % BetterBucketItem.getBucketAmount();
                int amountRemoved = Math.max(newMax - bucketLeftOver, 0);
                newAmount = currentAmount - amountRemoved;
                returnAmount = amountRemoved;
            }
            if (newAmount == 0 && !bucket.getBreakStack().method_7960()) {
                newVariant = ItemVariant.of((class_1799)bucket.getBreakStack().method_7972());
            } else {
                BetterBucketItem.setAmount(stack, newAmount);
                newVariant = ItemVariant.of((class_1799)stack);
            }
            if (this.context.exchange(newVariant, 1L, transaction) == 1L) {
                return returnAmount;
            }
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        String stored = BetterBucketItem.getFluid(this.context.getItemVariant().toStack());
        return stored.equals(BetterBucketItem.emptyMarker());
    }

    public FluidVariant getResource() {
        class_3611 stored = BetterBucketItem.getFluidFromString(BetterBucketItem.getFluid(this.context.getItemVariant().toStack()));
        return FluidVariant.of((class_3611)stored);
    }

    public long getAmount() {
        return BetterBucketItem.getAmount(this.context.getItemVariant().toStack());
    }

    public long getCapacity() {
        class_1792 class_17922 = this.context.getItemVariant().getItem();
        if (class_17922 instanceof BetterBucketItem) {
            BetterBucketItem bucketItem = (BetterBucketItem)class_17922;
            return bucketItem.getMaximumMillibuckets();
        }
        return BetterBucketItem.getBucketAmount();
    }
}

