/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.NBTHelper;
import com.grim3212.assorted.tools.ToolsCommonMod;
import com.grim3212.assorted.tools.api.item.ITiered;
import com.grim3212.assorted.tools.common.fluid.FluidHelper;
import com.grim3212.assorted.tools.common.handlers.DispenseBucketHandler;
import com.grim3212.assorted.tools.config.ItemTierConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7924;

public class BetterBucketItem
extends class_1792
implements ITiered {
    public final ItemTierConfig tierHolder;

    public BetterBucketItem(class_1792.class_1793 props, ItemTierConfig tierHolder) {
        super(props.method_7889(1));
        this.tierHolder = tierHolder;
        class_2315.method_10009((class_1935)this, (class_2357)DispenseBucketHandler.getInstance());
    }

    public class_1799 getEmptyStack() {
        class_1799 stack = new class_1799((class_1935)this);
        BetterBucketItem.storeFluid(stack, class_3612.field_15906, 0);
        return stack;
    }

    @Override
    public ItemTierConfig getTierHolder() {
        return this.tierHolder;
    }

    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        BetterBucketItem.storeFluid(stack, class_3612.field_15906, 0);
    }

    public int getMaximumMillibuckets() {
        return this.tierHolder.getMaxBuckets() * BetterBucketItem.getBucketAmount();
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (BetterBucketItem.getAmount(stack) <= 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.buckets.empty"));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.buckets.contains", (Object[])new Object[]{BetterBucketItem.getAmount(stack) / BetterBucketItem.getBucketAmount(), this.getMaximumMillibuckets() / BetterBucketItem.getBucketAmount()}));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        Optional fluid = Services.FLUIDS.get(stack);
        if (!fluid.isEmpty() && ((FluidInformation)fluid.get()).fluid() != class_3612.field_15906) {
            class_2561 fluidName = Services.FLUIDS.getDisplayName(((FluidInformation)fluid.get()).fluid());
            return class_2561.method_43469((String)("item.assortedtools." + Services.PLATFORM.getRegistry(class_7924.field_41197).getRegistryName((Object)stack.method_7909()).method_12832() + "_filled"), (Object[])new Object[]{fluidName});
        }
        return super.method_7864(stack);
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 hand) {
        Optional<FluidInformation> filledResult;
        class_1799 itemStackIn = playerIn.method_5998(hand);
        boolean canContainMore = BetterBucketItem.getAmount(itemStackIn) < this.getMaximumMillibuckets();
        class_3965 blockhitresult = BetterBucketItem.method_7872((class_1937)worldIn, (class_1657)playerIn, (class_3959.class_242)(canContainMore ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
        if (blockhitresult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)itemStackIn);
        }
        if (blockhitresult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemStackIn);
        }
        class_2338 clickPos = blockhitresult.method_17777();
        class_2350 direction = blockhitresult.method_17780();
        class_2338 clickPosOffset = clickPos.method_10093(direction);
        if (canContainMore && !(filledResult = FluidHelper.tryPickupFluid(playerIn, worldIn, blockhitresult)).isEmpty()) {
            if (playerIn.method_7337()) {
                return class_1271.method_22427((Object)itemStackIn);
            }
            int filledAmount = BetterBucketItem.getAmount(itemStackIn) + (int)filledResult.get().amount();
            if (filledAmount > this.getMaximumMillibuckets()) {
                filledAmount = this.getMaximumMillibuckets();
            }
            int leftover = filledAmount % BetterBucketItem.getBucketAmount();
            int newFillAmount = ToolsCommonMod.COMMON_CONFIG.allowPartialBucketAmounts.get() != false ? filledAmount : filledAmount - leftover;
            BetterBucketItem.storeFluid(itemStackIn, filledResult.get(), newFillAmount);
            return class_1271.method_22427((Object)itemStackIn);
        }
        if (worldIn.method_8505(playerIn, clickPos)) {
            Optional fluidInformation;
            int amount;
            blockhitresult = BetterBucketItem.method_7872((class_1937)worldIn, (class_1657)playerIn, (class_3959.class_242)class_3959.class_242.field_1348);
            if (blockhitresult.method_17783() == class_239.class_240.field_1333) {
                return class_1271.method_22430((Object)itemStackIn);
            }
            if (blockhitresult.method_17783() != class_239.class_240.field_1332) {
                return class_1271.method_22430((Object)itemStackIn);
            }
            clickPos = blockhitresult.method_17777();
            clickPosOffset = clickPos.method_10093(direction = blockhitresult.method_17780());
            if (playerIn.method_7343(clickPosOffset, direction, itemStackIn) && (amount = BetterBucketItem.getAmount(itemStackIn)) >= BetterBucketItem.getBucketAmount() && !(fluidInformation = Services.FLUIDS.get(itemStackIn)).isEmpty() && ((FluidInformation)fluidInformation.get()).fluid() != class_3612.field_15906 && this.tryPlaceFluid(playerIn, (FluidInformation)fluidInformation.get(), worldIn, clickPosOffset, blockhitresult) && !playerIn.method_7337()) {
                playerIn.method_7259(class_3468.field_15372.method_14956((Object)this));
                BetterBucketItem.setAmount(itemStackIn, amount - BetterBucketItem.getBucketAmount());
                return class_1271.method_22427((Object)this.tryBreakBucket(itemStackIn));
            }
        }
        return class_1271.method_22430((Object)itemStackIn);
    }

    public static int getBucketAmount() {
        return (int)Services.FLUIDS.getBucketAmount();
    }

    public static boolean isEmptyOrContains(class_1799 stack, String toCheck) {
        return BetterBucketItem.getFluid(stack).equals(BetterBucketItem.emptyMarker()) || BetterBucketItem.getFluid(stack).equals(toCheck);
    }

    public boolean tryPlaceFluid(class_1657 player, FluidInformation fluid, class_1937 worldIn, class_2338 pos, class_3965 hitResult) {
        if (fluid.fluid() != class_3612.field_15906) {
            if (fluid.fluid() == class_3612.field_15910 || fluid.fluid() == class_3612.field_15908) {
                class_2680 iblockstate = worldIn.method_8320(pos);
                boolean flag = !iblockstate.method_51367();
                boolean flag1 = iblockstate.method_26188(fluid.fluid());
                if (!(worldIn.method_22347(pos) || flag || flag1)) {
                    return false;
                }
                if (worldIn.method_8597().comp_644() && fluid.fluid() == class_3612.field_15910) {
                    int l = pos.method_10263();
                    int i = pos.method_10264();
                    int j = pos.method_10260();
                    worldIn.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (worldIn.field_9229.method_43057() - worldIn.field_9229.method_43057()) * 0.8f);
                    for (int k = 0; k < 8; ++k) {
                        worldIn.method_8406((class_2394)class_2398.field_11237, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
                    }
                } else {
                    if (!worldIn.field_9236 && (flag || flag1) && !iblockstate.method_51176()) {
                        worldIn.method_22352(pos, true);
                    }
                    worldIn.method_8396(player, pos, fluid.fluid() == class_3612.field_15910 ? class_3417.field_14834 : class_3417.field_15010, class_3419.field_15245, 1.0f, 1.0f);
                    worldIn.method_8501(pos, fluid.fluid() == class_3612.field_15910 ? class_2246.field_10382.method_9564() : class_2246.field_10164.method_9564());
                }
                return true;
            }
            return FluidHelper.tryPlaceFluid(player, worldIn, pos, hitResult, fluid);
        }
        return false;
    }

    public class_1799 getCraftingRemainingItem(class_1799 itemStack) {
        int amount = BetterBucketItem.getAmount(itemStack);
        BetterBucketItem.setAmount(itemStack, amount - BetterBucketItem.getBucketAmount());
        return this.tryBreakBucket(itemStack);
    }

    public boolean hasCraftingRemainingItem(class_1799 stack) {
        return BetterBucketItem.getAmount(stack) >= BetterBucketItem.getBucketAmount();
    }

    public class_1799 getRecipeRemainder(class_1799 stack) {
        if (this.hasCraftingRemainingItem(stack)) {
            return this.getCraftingRemainingItem(stack);
        }
        return class_1799.field_8037;
    }

    public boolean method_31567(class_1799 stack) {
        return BetterBucketItem.getAmount(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        int reversedAmount = this.getMaximumMillibuckets() - BetterBucketItem.getAmount(stack);
        return Math.round(13.0f - (float)reversedAmount * 13.0f / (float)this.getMaximumMillibuckets());
    }

    public int method_31571(class_1799 stack) {
        float f = Math.max(0.0f, (float)BetterBucketItem.getAmount(stack) / (float)this.getMaximumMillibuckets());
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public class_1799 getBreakStack() {
        class_1799[] repairMaterial;
        if (this.tierHolder.getBreaksAfterUse() && (repairMaterial = this.tierHolder.getDefaultTier().method_8023().method_8105()).length > 0) {
            return new class_1799((class_1935)repairMaterial[0].method_7972().method_7909(), 2);
        }
        return class_1799.field_8037;
    }

    public class_1799 tryBreakBucket(class_1799 stack) {
        if (BetterBucketItem.getAmount(stack) <= 0) {
            if (this.tierHolder.getBreaksAfterUse()) {
                return this.getBreakStack();
            }
            if (!this.getEmptyStack().method_7960()) {
                return this.getEmptyStack().method_7972();
            }
            return class_1799.field_8037;
        }
        return stack.method_7972();
    }

    public static String emptyMarker() {
        return BetterBucketItem.getStringFromFluid(class_3612.field_15906);
    }

    public static String getStringFromFluid(class_3611 f) {
        return Services.PLATFORM.getRegistry(class_7924.field_41270).getRegistryName((Object)f).toString();
    }

    public static class_3611 getFluidFromString(String s) {
        return Services.PLATFORM.getRegistry(class_7924.field_41270).getValue(new class_2960(s)).orElse(class_3612.field_15906);
    }

    public static void store(class_1799 stack, String toStore, int amount) {
        class_2487 tag = NBTHelper.getTag((class_1799)stack, (String)Services.FLUIDS.fluidStackTag());
        NBTHelper.putString((class_2487)tag, (String)"FluidName", (String)toStore);
        BetterBucketItem.setAmount(stack, amount);
    }

    public static void storeFluid(class_1799 stack, class_3611 fluid, int amount) {
        BetterBucketItem.store(stack, BetterBucketItem.getStringFromFluid(fluid), amount);
    }

    public static void storeFluid(class_1799 stack, FluidInformation information, int amount) {
        BetterBucketItem.storeFluid(stack, information.fluid(), amount);
    }

    public static void storeFluid(class_1799 stack, FluidInformation information) {
        BetterBucketItem.storeFluid(stack, information.fluid(), (int)information.amount());
    }

    public static void setAmount(class_1799 stack, int amount) {
        class_2487 tag = NBTHelper.getTag((class_1799)stack, (String)Services.FLUIDS.fluidStackTag());
        NBTHelper.putInt((class_2487)tag, (String)"Amount", (int)amount);
        if (amount <= 0) {
            NBTHelper.putString((class_2487)tag, (String)"FluidName", (String)BetterBucketItem.emptyMarker());
            NBTHelper.putInt((class_2487)tag, (String)"Amount", (int)0);
        }
    }

    public static String getFluid(class_1799 stack) {
        class_2487 tag = NBTHelper.getTag((class_1799)stack, (String)Services.FLUIDS.fluidStackTag());
        return NBTHelper.getString((class_2487)tag, (String)"FluidName");
    }

    public static int getAmount(class_1799 stack) {
        class_2487 tag = NBTHelper.getTag((class_1799)stack, (String)Services.FLUIDS.fluidStackTag());
        return NBTHelper.getInt((class_2487)tag, (String)"Amount");
    }
}

