/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.entity;

import com.grim3212.assorted.tools.ToolsCommonMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class BoomerangEntity
extends class_1297 {
    private class_2338 activatedPos;
    protected boolean isBouncing;
    private double bounceFactor = 0.85;
    private float prevBoomerangRotation;
    private boolean turningAround = false;
    protected int timeBeforeTurnAround = 30;
    List<class_1542> itemsPickedUp = new ArrayList<class_1542>();
    private class_1799 selfStack;
    private class_1268 hand = class_1268.field_5808;
    private static final class_2940<Float> ROTATION = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Optional<UUID>> RETURN_UNIQUE_ID = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13313);

    public BoomerangEntity(class_1299<BoomerangEntity> type, class_1937 world) {
        super(type, world);
    }

    public BoomerangEntity(class_1299<BoomerangEntity> type, class_1937 worldIn, class_1657 entity, class_1799 itemstack, class_1268 hand) {
        this(type, worldIn);
        this.selfStack = itemstack;
        this.method_5710(entity.method_36454(), entity.method_36455());
        double x = -class_3532.method_15374((float)(entity.method_36454() * 3.141593f / 180.0f));
        double z = class_3532.method_15362((float)(entity.method_36454() * 3.141593f / 180.0f));
        double motionX = 0.5 * x * (double)class_3532.method_15362((float)(entity.method_36455() / 180.0f * 3.141593f));
        double motionY = -0.5 * (double)class_3532.method_15374((float)(entity.method_36455() / 180.0f * 3.141593f));
        double motionZ = 0.5 * z * (double)class_3532.method_15362((float)(entity.method_36455() / 180.0f * 3.141593f));
        this.method_18799(new class_243(motionX, motionY, motionZ));
        this.method_5814(entity.method_23317(), this.getReturnEntityY(entity), entity.method_23321());
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.isBouncing = false;
        this.turningAround = false;
        this.hand = hand;
        this.setReturnToId(entity.method_5667());
    }

    public double getReturnEntityY(class_1657 entity) {
        return entity.method_23318() + (double)entity.method_5751() - (double)0.1f;
    }

    public void method_5773() {
        class_1657 player = this.getReturnTo();
        class_243 vec3d1 = this.method_19538();
        class_243 vec3d = this.method_19538().method_1019(this.method_18798());
        class_3965 raytraceresult = this.method_37908().method_17742(new class_3959(vec3d1, vec3d, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)this));
        if (raytraceresult != null && raytraceresult.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = class_2338.method_49638((class_2374)raytraceresult.method_17784());
            class_2680 state = this.method_37908().method_8320(pos);
            if (state.method_45474() && ToolsCommonMod.COMMON_CONFIG.breaksPlants.get().booleanValue() || state.method_26204() == class_2246.field_10336 && ToolsCommonMod.COMMON_CONFIG.breaksTorches.get().booleanValue()) {
                this.method_37908().method_22352(pos, true);
            }
            if ((state.method_26204() instanceof class_2401 || state.method_26204() instanceof class_2269) && ToolsCommonMod.COMMON_CONFIG.hitsButtons.get().booleanValue()) {
                if (this.timeBeforeTurnAround > 0 && ToolsCommonMod.COMMON_CONFIG.turnAroundButton.get().booleanValue()) {
                    this.timeBeforeTurnAround = 0;
                }
                if (this.activatedPos == null || !this.activatedPos.equals((Object)pos)) {
                    this.activatedPos = pos;
                    state.method_26204().method_9534(state, this.method_37908(), pos, player, class_1268.field_5808, raytraceresult);
                }
            }
        }
        if (!this.turningAround) {
            class_243 motionBefore = this.method_18798();
            this.method_5784(class_1313.field_6308, motionBefore);
            class_243 motionAfter = this.method_18798();
            double newX = motionAfter.field_1352;
            double newY = motionAfter.field_1351;
            double newZ = motionAfter.field_1350;
            boolean flag = false;
            if (motionAfter.field_1352 != motionBefore.field_1352) {
                newX = -motionBefore.field_1352;
                flag = true;
            }
            if (motionAfter.field_1351 != motionBefore.field_1351) {
                newY = -motionBefore.field_1351;
                flag = true;
            }
            if (motionAfter.field_1350 != motionBefore.field_1350) {
                newZ = -motionBefore.field_1350;
                flag = true;
            }
            if (flag) {
                this.isBouncing = true;
                this.method_18799(new class_243(newX, newY, newZ).method_18805(this.bounceFactor, this.bounceFactor, this.bounceFactor));
            }
            this.beforeTurnAround(player);
            if (this.timeBeforeTurnAround-- <= 0) {
                this.turningAround = true;
            }
        } else if (player != null) {
            double z;
            double y;
            double x = player.method_23317() - this.method_23317();
            double d = Math.sqrt(x * x + (y = this.getReturnEntityY(player) - this.method_23318()) * y + (z = player.method_23321() - this.method_23321()) * z);
            if (d < 1.5) {
                this.setEntityDead();
            }
            this.method_18800(0.5 * x / d, 0.5 * y / d, 0.5 * z / d);
            this.method_5814(this.method_23317() + this.method_18798().field_1352, this.method_23318() + this.method_18798().field_1351, this.method_23321() + this.method_18798().field_1350);
        }
        this.determineRotation();
        this.prevBoomerangRotation = this.getBoomerangRotation();
        this.setBoomerangRotation(this.getBoomerangRotation() + 36.0f);
        while (this.getBoomerangRotation() > 360.0f) {
            this.setBoomerangRotation(this.getBoomerangRotation() - 360.0f);
        }
        List list = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012(0.5, 0.5, 0.5));
        for (int i = 0; i < list.size(); ++i) {
            class_1297 entity = (class_1297)list.get(i);
            if (entity instanceof class_1542) {
                this.itemsPickedUp.add((class_1542)entity);
                if (this.timeBeforeTurnAround <= 0 || !ToolsCommonMod.COMMON_CONFIG.turnAroundItem.get().booleanValue()) continue;
                this.timeBeforeTurnAround = 0;
                continue;
            }
            if (!(entity instanceof class_1309) || entity == player) continue;
            this.onEntityHit(entity, player);
            if (this.timeBeforeTurnAround <= 0 || !ToolsCommonMod.COMMON_CONFIG.turnAroundMob.get().booleanValue()) continue;
            this.timeBeforeTurnAround = 0;
        }
        for (class_1542 item : this.itemsPickedUp) {
            item.method_18800(0.0, 0.0, 0.0);
            if (!item.method_5805()) continue;
            class_243 pos = this.method_19538();
            item.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        }
        super.method_5773();
    }

    public void beforeTurnAround(class_1657 player) {
    }

    public void onEntityHit(class_1297 hitEntity, class_1657 player) {
        hitEntity.method_5643(this.causeNewDamage(this, (class_1297)player), (float)this.getDamage(hitEntity, player));
    }

    protected abstract int getDamage(class_1297 var1, class_1657 var2);

    public abstract class_1282 causeNewDamage(BoomerangEntity var1, class_1297 var2);

    public void setEntityDead() {
        if (this.getReturnTo() != null && this.selfStack != null) {
            if (this.hand == class_1268.field_5810) {
                if (this.getReturnTo().method_6079().method_7960()) {
                    this.getReturnTo().method_6122(class_1268.field_5810, this.selfStack);
                } else {
                    this.getReturnTo().method_31548().method_7394(this.selfStack);
                }
            } else {
                this.getReturnTo().method_31548().method_7394(this.selfStack);
            }
        }
        super.method_30076();
    }

    protected void method_5693() {
        this.method_5841().method_12784(ROTATION, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(RETURN_UNIQUE_ID, Optional.empty());
    }

    public float getBoomerangRotation() {
        return ((Float)this.method_5841().method_12789(ROTATION)).floatValue();
    }

    public void setBoomerangRotation(float rotationIn) {
        this.method_5841().method_12778(ROTATION, (Object)Float.valueOf(rotationIn));
    }

    @Nullable
    public UUID getReturnToId() {
        return ((Optional)this.field_6011.method_12789(RETURN_UNIQUE_ID)).orElse(null);
    }

    public void setReturnToId(@Nullable UUID uuid) {
        this.field_6011.method_12778(RETURN_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1657 getReturnTo() {
        try {
            UUID uuid = this.getReturnToId();
            return uuid == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isReturnTo(class_1309 entityIn) {
        return entityIn == this.getReturnTo();
    }

    public void determineRotation() {
        class_243 motion = this.method_18798();
        this.method_36456(-57.29578f * (float)Math.atan2(motion.field_1352, motion.field_1350));
        double d1 = Math.sqrt(motion.field_1350 * motion.field_1350 + motion.field_1352 * motion.field_1352);
        this.method_36457(-57.29578f * (float)Math.atan2(motion.field_1351, d1));
    }

    public void method_5651(class_2487 compound) {
        super.method_5651(compound);
    }

    protected void method_5749(class_2487 compound) {
        this.isBouncing = compound.method_10577("IsBouncing");
        this.bounceFactor = compound.method_10574("BounceFactor");
        this.prevBoomerangRotation = compound.method_10583("PrevBoomerangRotation");
        this.setBoomerangRotation(compound.method_10583("BoomerangRotation"));
        this.turningAround = compound.method_10577("TurningAround");
        this.timeBeforeTurnAround = compound.method_10550("TimeBeforeTurnAround");
        if (compound.method_10545("xPos") && compound.method_10545("yPos") && compound.method_10545("zPos")) {
            this.activatedPos = new class_2338(compound.method_10550("xPos"), compound.method_10550("yPos"), compound.method_10550("zPos"));
        }
        if (compound.method_10573("ReturnToUUID", 8)) {
            try {
                this.setReturnToId(UUID.fromString(compound.method_10558("ReturnToUUID")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.selfStack = class_1799.method_7915((class_2487)compound.method_10562("SelfStack"));
        class_2499 itemsGathered = compound.method_10554("ItemsPickedUp", 10);
        for (int i = 0; i < itemsGathered.size(); ++i) {
            class_2487 tag = itemsGathered.method_10602(i);
            class_1542 item = new class_1542(this.method_37908(), 0.0, 0.0, 0.0, class_1799.field_8037);
            item.method_5749(tag);
            this.itemsPickedUp.add(item);
        }
        this.hand = class_1268.valueOf((String)compound.method_10558("hand"));
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10556("IsBouncing", this.isBouncing);
        compound.method_10549("BounceFactor", this.bounceFactor);
        compound.method_10548("PrevBoomerangRotation", this.prevBoomerangRotation);
        compound.method_10548("BoomerangRotation", this.getBoomerangRotation());
        compound.method_10556("TurningAround", this.turningAround);
        compound.method_10569("TimeBeforeTurnAround", this.timeBeforeTurnAround);
        if (this.activatedPos != null) {
            compound.method_10569("xPos", this.activatedPos.method_10263());
            compound.method_10569("yPos", this.activatedPos.method_10264());
            compound.method_10569("zPos", this.activatedPos.method_10260());
        }
        if (this.getReturnToId() == null) {
            compound.method_10582("ReturnToUUID", "");
        } else {
            compound.method_10582("ReturnToUUID", this.getReturnToId().toString());
        }
        class_2487 selfStackTag = new class_2487();
        this.selfStack.method_7953(selfStackTag);
        compound.method_10566("SelfStack", (class_2520)selfStackTag);
        class_2499 itemsGathered = new class_2499();
        for (int i = 0; i < this.itemsPickedUp.size(); ++i) {
            if (this.itemsPickedUp.get(i) == null) continue;
            class_2487 tag = new class_2487();
            this.itemsPickedUp.get(i).method_5652(compound);
            itemsGathered.add((Object)tag);
        }
        compound.method_10566("ItemsPickedUp", (class_2520)itemsGathered);
        compound.method_10582("hand", this.hand.toString());
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

