/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.client.model.fluidcontainer;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.client.model.CombiningModel;
import com.grim3212.assorted.lib.client.model.ItemOverridesExtension;
import com.grim3212.assorted.lib.client.model.QuadTransformers;
import com.grim3212.assorted.lib.client.model.RenderTypeGroup;
import com.grim3212.assorted.lib.client.model.UnbakedGeometryHelper;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecification;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecificationLoader;
import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import com.grim3212.assorted.lib.client.model.loaders.context.SimpleModelBakingContext;
import com.grim3212.assorted.lib.client.model.state.SimpleModelState;
import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.core.fluid.IFluidVariantHandler;
import com.grim3212.assorted.lib.platform.ClientServices;
import com.grim3212.assorted.lib.platform.Services;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7775;
import net.minecraft.class_7924;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FluidContainerModel
implements IModelSpecification<FluidContainerModel> {
    public static final class_2960 LOADER_NAME = new class_2960("assortedtools", "fluid_container");
    private static final class_4590 FLUID_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final class_4590 COVER_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final class_3611 fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    private FluidContainerModel(class_3611 fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public FluidContainerModel withFluid(class_3611 newFluid) {
        return new FluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity);
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(class_1921.method_23583(), unlit ? ClientServices.MODELS.getItemUnlitUnsortedTranslucentRenderType() : ClientServices.MODELS.getItemUnsortedTranslucentRenderType());
    }

    public class_1087 bake(IModelBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation) {
        List quads;
        List unbaked;
        SimpleModelState transformedState;
        class_1058 templateSprite;
        class_1058 particleSprite;
        class_4730 particleLocation = context.getMaterial("particle").orElse(null);
        class_4730 baseLocation = context.getMaterial("base").orElse(null);
        class_4730 fluidMaskLocation = context.getMaterial("fluid").orElse(null);
        class_4730 coverLocation = context.getMaterial("cover").orElse(null);
        FluidInformation fluidInformation = new FluidInformation(this.fluid);
        Optional fluidVariant = Services.FLUIDS.getVariantHandlerFor(fluidInformation);
        class_1058 baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        class_1058 fluidSprite = this.fluid != class_3612.field_15906 ? ClientServices.FLUIDS.getSprite(fluidInformation) : null;
        class_1058 coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        class_1058 class_10582 = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != class_3612.field_15906 && fluidVariant.isPresent() && ((IFluidVariantHandler)fluidVariant.get()).getDensity(fluidInformation) < 0) {
            modelState = new SimpleModelState(modelState.method_3509().method_22933(new class_4590(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        SimpleModelBakingContext itemContext = SimpleModelBakingContext.SimpleModelBakingContextBuilder.builder().withIsGui3d(false).withUseBlockLight(false).build();
        CombiningModel.Baked.Builder modelBuilder = CombiningModel.Baked.builder((IModelBakingContext)itemContext, (class_1058)particleSprite, (class_806)new ContainedFluidOverrideHandler(context, baker, this), (class_809)context.getTransforms());
        RenderTypeGroup normalRenderTypes = FluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null && baseSprite != null) {
            List unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (class_7764)baseSprite.method_45851());
            List quads2 = UnbakedGeometryHelper.bakeElements((List)unbaked2, $ -> baseSprite, (class_3665)modelState, (class_2960)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.method_3509().method_22933(FLUID_TRANSFORM), modelState.method_3512());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (class_1058)templateSprite);
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (class_3665)transformedState, (class_2960)modelLocation);
            boolean emissive = this.applyFluidLuminosity && fluidVariant.isPresent() && ((IFluidVariantHandler)fluidVariant.get()).getLuminance(fluidInformation) > 0;
            RenderTypeGroup renderTypes = FluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        if (coverSprite != null) {
            class_1058 sprite;
            Object object = sprite = !this.coverIsMask ? coverSprite : null;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.method_3509().method_22933(COVER_TRANSFORM), modelState.method_3512());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (class_1058)coverSprite);
                quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (class_3665)transformedState, (class_2960)modelLocation);
                modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return ClientServices.MODELS.adaptToPlatform(modelBuilder.build());
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverridesExtension {
        private final Map<String, class_1087> cache = Maps.newHashMap();
        private final class_7775 baker;
        private final FluidContainerModel parent;

        private ContainedFluidOverrideHandler(IModelBakingContext context, class_7775 baker, FluidContainerModel parent) {
            super(context);
            this.baker = baker;
            this.parent = parent;
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            class_1087 overridden = this.context.getItemOverrides(this.baker).method_3495(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            return Services.FLUIDS.get(stack).map(fluidStack -> {
                class_3611 fluid = fluidStack.fluid();
                String name = Services.PLATFORM.getRegistry(class_7924.field_41270).getRegistryName((Object)fluid).toString();
                if (!this.cache.containsKey(name)) {
                    FluidContainerModel unbaked = this.parent.withFluid(fluid);
                    class_1087 bakedModel = unbaked.bake(this.context, this.baker, class_4730::method_24148, (class_3665)class_1086.field_5350, new class_2960("assortedtools", "bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static final class Loader
    implements IModelSpecificationLoader<FluidContainerModel> {
        public static final Loader INSTANCE = new Loader();

        public FluidContainerModel read(JsonDeserializationContext deserializationContext, JsonObject jsonObject) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            class_2960 fluidName = new class_2960(jsonObject.get("fluid").getAsString());
            class_3611 fluid = Services.PLATFORM.getRegistry(class_7924.field_41270).getValue(fluidName).orElse(class_3612.field_15906);
            boolean flip = class_3518.method_15258((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = class_3518.method_15258((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = class_3518.method_15258((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new FluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity);
        }
    }
}

