/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.platform.services.IRegistryFactory;
import com.grim3212.assorted.lib.registry.IRegistryObject;
import com.grim3212.assorted.lib.registry.RegistryProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FabricRegistryProvider
implements IRegistryFactory {
    @Override
    public <T> RegistryProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        return new Provider(modId, resourceKey);
    }

    @Override
    public <T> RegistryProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<T>(modId, registry);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final class_2378<T> registry;
        private final Set<IRegistryObject<T>> entries = new HashSet<IRegistryObject<T>>();
        private final Set<IRegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, class_5321<? extends class_2378<T>> key) {
            this.modId = modId;
            class_2378 reg = (class_2378)class_7923.field_41167.method_10223(key.method_29177());
            if (reg == null) {
                throw new RuntimeException("Registry with name " + key.method_29177() + " was not found!");
            }
            this.registry = reg;
        }

        private Provider(String modId, class_2378<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> IRegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final class_2960 rl = new class_2960(this.modId, name);
            final Object obj = class_2378.method_10230(this.registry, (class_2960)rl, supplier.get());
            IRegistryObject ro = new IRegistryObject<I>(){
                final class_5321<I> key;
                {
                    this.key = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)rl);
                }

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    return registry.method_40290(this.key);
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<IRegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public Stream<T> getValues() {
            return this.registry.method_10220();
        }

        @Override
        public Optional<T> getValue(class_2960 resourceLocation) {
            return this.entriesView.stream().filter(x -> x.getResourceKey().equals(resourceLocation)).map(x -> x.get()).findFirst();
        }

        @Override
        public boolean contains(T entry) {
            return this.getValues().anyMatch(x -> entry.equals(x));
        }

        @Override
        public boolean containsKey(class_2960 resourceLocation) {
            return this.getValue(resourceLocation).isPresent();
        }

        @Override
        public class_2960 getRegistryName(T entry) {
            return this.registry.method_10221(entry);
        }
    }
}

