/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.dist.Dist;
import com.grim3212.assorted.lib.platform.FabricRegistryWrapper;
import com.grim3212.assorted.lib.platform.services.IPlatformHelper;
import com.grim3212.assorted.lib.registry.ILoaderRegistry;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5321;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public String getCommonTagPrefix() {
        return "c";
    }

    @Override
    public void openMenu(class_3222 player, class_3908 provider, Consumer<class_2540> extraDataWriter) {
        player.method_17355((class_3908)new ExtendedScreenHandlerImpl(provider, extraDataWriter));
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isFakePlayer(class_1657 player) {
        return false;
    }

    @Override
    public double getPlayerReachDistance(class_1657 player) {
        return player.method_7337() ? 5.0 : 4.5;
    }

    @Override
    public Dist getCurrentDistribution() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnvType.CLIENT -> Dist.CLIENT;
            case EnvType.SERVER -> Dist.DEDICATED_SERVER;
        };
    }

    @Override
    public boolean isPhysicalClient() {
        return this.getCurrentDistribution() == Dist.CLIENT;
    }

    @Override
    public boolean isProduction() {
        return !FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public <T> ILoaderRegistry<T> getRegistry(class_5321<? extends class_2378<T>> key) {
        return FabricRegistryWrapper.getRegistry(key);
    }

    @Override
    public void modifyCreativeTab(class_5321<class_1761> key, Supplier<List<class_1799>> displayStacks) {
        ItemGroupEvents.modifyEntriesEvent(key).register(populator -> populator.method_45423((Collection)displayStacks.get()));
    }

    @Override
    public void addReloadListener(final class_2960 identifier, final class_3302 reloadListener) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return identifier;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
                return reloadListener.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
            }
        });
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> builder, class_2248 ... blocks) {
        return FabricBlockEntityTypeBuilder.create(builder::apply, (class_2248[])blocks).build(null);
    }

    @Override
    public <T extends class_1703> class_3917<T> createMenuType(IPlatformHelper.MenuFactory<T> factory) {
        return new ExtendedScreenHandlerType(factory::create);
    }

    @Override
    public int getFuelTime(class_1799 stack) {
        Integer fuelTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return fuelTime != null ? fuelTime : 0;
    }

    public static class ExtendedScreenHandlerImpl
    implements ExtendedScreenHandlerFactory {
        private final class_3908 provider;
        private final Consumer<class_2540> extraDataWriter;

        public ExtendedScreenHandlerImpl(class_3908 provider, Consumer<class_2540> extraDataWriter) {
            this.provider = provider;
            this.extraDataWriter = extraDataWriter;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            this.extraDataWriter.accept(buf);
        }

        public class_2561 method_5476() {
            return this.provider.method_5476();
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return this.provider.createMenu(windowId, inventory, player);
        }
    }
}

