/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.platform.services.INetworkHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FabricNetworkHelper
implements INetworkHelper {
    private static final Map<Class<?>, INetworkHelper.MessageHandler<?>> messageHandlers = new ConcurrentHashMap();
    private static final List<INetworkHelper.MessageHandler<?>> clientMessageHandlers = new ArrayList();
    private static class_1657 replyPlayer;

    @Override
    public <MSG> void register(INetworkHelper.MessageHandler<MSG> handler) {
        messageHandlers.put(handler.messageType(), handler);
        if (handler.side() == INetworkHelper.MessageBoundSide.CLIENT) {
            clientMessageHandlers.add(handler);
            return;
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)handler.id(), (server, player, listener, buf, responseSender) -> {
            Object message = handler.decoder().apply(buf);
            server.execute(() -> {
                replyPlayer = player;
                handler.messageConsumer().accept(message, (class_1657)player);
                replyPlayer = null;
            });
        });
    }

    public static void initializeClientHandlers() {
        for (INetworkHelper.MessageHandler<?> handler : clientMessageHandlers) {
            FabricNetworkHelper.registerClientReceiver(handler);
        }
    }

    private static <MSG> void registerClientReceiver(INetworkHelper.MessageHandler<MSG> handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)handler.id(), (client, listener, buf, responseSender) -> {
            Object message = handler.decoder().apply(buf);
            client.execute(() -> handler.messageConsumer().accept(message, (class_1657)class_310.method_1551().field_1724));
        });
    }

    @Override
    public <MSG> void sendToNearby(class_1937 world, class_2338 pos, MSG toSend) {
        if (world instanceof class_3218) {
            INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
            class_3218 ws = (class_3218)world;
            class_2540 buf = PacketByteBufs.create();
            handler.encoder().accept(toSend, buf);
            ws.method_14178().field_17254.method_17210(new class_1923(pos), false).stream().filter(p -> p.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < 4096.0).forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_2960)handler.id(), (class_2540)buf));
        }
    }

    @Override
    public <MSG> void sendToNearby(class_1937 world, class_1297 entity, MSG toSend) {
        this.sendToNearby(world, entity.method_24515(), toSend);
    }

    @Override
    public <MSG> void sendTo(class_1657 player, MSG toSend) {
        INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
        class_2540 buf = PacketByteBufs.create();
        handler.encoder().accept(toSend, buf);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)handler.id(), (class_2540)buf);
    }

    @Override
    public <MSG> void sendToServer(MSG toSend) {
        INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
        class_2540 buf = PacketByteBufs.create();
        handler.encoder().accept(toSend, buf);
        ClientPlayNetworking.send((class_2960)handler.id(), (class_2540)buf);
    }
}

