/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.core.inventory.IInventoryBlockEntity;
import com.grim3212.assorted.lib.core.inventory.IInventoryItem;
import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.core.inventory.IPlatformInventoryStorageHandler;
import com.grim3212.assorted.lib.inventory.FabricPlatformInventoryStorageHandlerSided;
import com.grim3212.assorted.lib.inventory.FabricPlatformInventoryStorageHandlerUnsided;
import com.grim3212.assorted.lib.inventory.FabricWrappedItemHandler;
import com.grim3212.assorted.lib.inventory.FabricWrappedStorageHandler;
import com.grim3212.assorted.lib.platform.services.IInventoryHelper;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricInventoryHelper
implements IInventoryHelper {
    @Override
    public boolean canItemStacksStack(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a.method_7960() || !class_1799.method_7984((class_1799)a, (class_1799)b) || a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    @Override
    public class_1799 copyStackWithSize(@NotNull class_1799 itemStack, int size) {
        if (size == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }

    @Override
    public Optional<IItemStorageHandler> getItemStorageHandler(class_1799 stack) {
        IInventoryItem itemStackStorage;
        IPlatformInventoryStorageHandler storageHandler;
        if (stack.method_7960()) {
            return Optional.empty();
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IInventoryItem && (storageHandler = (itemStackStorage = (IInventoryItem)class_17922).getStorageHandler(stack)) != null) {
            return Optional.of(storageHandler.getItemStorageHandler(null));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IItemStorageHandler> getItemStorageHandler(class_2586 blockEntity, @Nullable class_2350 direction) {
        IInventoryBlockEntity inventoryBlockEntity;
        IPlatformInventoryStorageHandler storageHandler;
        if (blockEntity == null || blockEntity.method_11015()) {
            return Optional.empty();
        }
        if (blockEntity instanceof IInventoryBlockEntity && (storageHandler = (inventoryBlockEntity = (IInventoryBlockEntity)blockEntity).getStorageHandler()) != null) {
            return Optional.of(storageHandler.getItemStorageHandler(direction));
        }
        Storage inventory = (Storage)ItemStorage.SIDED.find(blockEntity.method_10997(), blockEntity.method_11016(), (Object)direction);
        if (inventory != null && inventory instanceof InventoryStorage) {
            InventoryStorage inventoryStorage = (InventoryStorage)inventory;
            return Optional.of(new FabricWrappedItemHandler(blockEntity, inventoryStorage));
        }
        if (blockEntity instanceof class_1263) {
            class_1263 container = (class_1263)blockEntity;
            return Optional.of(new FabricWrappedItemHandler(blockEntity, InventoryStorage.of((class_1263)container, (class_2350)direction)));
        }
        return Optional.empty();
    }

    @Override
    public IPlatformInventoryStorageHandler createStorageInventoryHandler(IItemStorageHandler handler) {
        return new FabricPlatformInventoryStorageHandlerUnsided(handler);
    }

    @Override
    public IPlatformInventoryStorageHandler createSidedStorageInventoryHandler(Function<class_2350, IItemStorageHandler> handler) {
        return new FabricPlatformInventoryStorageHandlerSided(handler);
    }

    @Override
    public class_1263 wrapStorageHandler(IItemStorageHandler handler) {
        return new FabricWrappedStorageHandler(handler);
    }
}

