/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.core.fluid.IFluidVariantHandler;
import com.grim3212.assorted.lib.fluid.FabricFluidVariantHandlerDelegate;
import com.grim3212.assorted.lib.platform.services.IFluidManager;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FabricFluidManager
implements IFluidManager {
    @Override
    public Optional<FluidInformation> get(class_1799 stack) {
        Storage target = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (target == null) {
            return Optional.empty();
        }
        if (!target.iterator().hasNext()) {
            return Optional.empty();
        }
        StorageView view = (StorageView)target.iterator().next();
        return Optional.of(new FluidInformation(((FluidVariant)view.getResource()).getFluid(), view.getAmount(), ((FluidVariant)view.getResource()).copyNbt()));
    }

    @Override
    public class_1799 extractFrom(class_1799 stack, long amount) {
        try (Transaction context = Transaction.openOuter();){
            Optional<FluidInformation> contained = this.get(stack);
            class_1799 class_17992 = contained.map(fluid -> {
                FluidVariant variant = FabricFluidManager.makeVariant(fluid);
                ContainerItemContext containerContext = ContainerItemContext.withConstant((class_1799)stack);
                ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).extract((Object)variant, amount, (TransactionContext)context);
                StorageView itemVariant = (StorageView)containerContext.getMainSlot().iterator().next();
                return ((ItemVariant)itemVariant.getResource()).toStack((int)itemVariant.getAmount());
            }).orElse(class_1799.field_8037);
            return class_17992;
        }
    }

    @Override
    public class_1799 insertInto(class_1799 stack, FluidInformation fluidInformation) {
        try (Transaction context = Transaction.openOuter();){
            Optional<FluidInformation> contained = this.get(stack);
            class_1799 class_17992 = contained.map(fluid -> {
                FluidVariant variant = FabricFluidManager.makeVariant(fluid);
                ContainerItemContext containerContext = ContainerItemContext.withConstant((class_1799)stack);
                ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).insert((Object)variant, fluidInformation.amount(), (TransactionContext)context);
                StorageView itemVariant = (StorageView)containerContext.getMainSlot().iterator().next();
                return ((ItemVariant)itemVariant.getResource()).toStack((int)itemVariant.getAmount());
            }).orElse(class_1799.field_8037);
            return class_17992;
        }
    }

    @Override
    public long simulateInsert(class_1799 stack, FluidInformation fluidInformation) {
        FluidVariant variant = FabricFluidManager.makeVariant(fluidInformation);
        ContainerItemContext containerContext = ContainerItemContext.withInitial((class_1799)stack);
        return ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).simulateInsert((Object)variant, fluidInformation.amount(), null);
    }

    @Override
    public long simulateExtract(class_1799 stack, long amount) {
        Optional<FluidInformation> contained = this.get(stack);
        return contained.map(fluid -> {
            FluidVariant variant = FabricFluidManager.makeVariant(fluid);
            ContainerItemContext containerContext = ContainerItemContext.withInitial((class_1799)stack);
            return ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).simulateExtract((Object)variant, amount, null);
        }).orElse(0L);
    }

    @Override
    public class_2561 getDisplayName(class_3611 fluid) {
        return fluid.method_15785().method_15759().method_26204().method_9518();
    }

    @Override
    public String fluidStackTag() {
        return "Fluid";
    }

    @Override
    public Optional<IFluidVariantHandler> getVariantHandlerFor(class_3611 fluid) {
        return Optional.of(new FabricFluidVariantHandlerDelegate(FluidVariantAttributes.getHandlerOrDefault((class_3611)fluid)));
    }

    public static FluidVariant makeVariant(FluidInformation fluid) {
        if (!fluid.fluid().method_15793(fluid.fluid().method_15785()) && fluid.fluid() != class_3612.field_15906) {
            return FabricFluidManager.makeVariant(fluid.withSource());
        }
        if (fluid.data() == null) {
            return FluidVariant.of((class_3611)fluid.fluid());
        }
        return FluidVariant.of((class_3611)fluid.fluid(), (class_2487)fluid.data());
    }

    public static FluidInformation makeInformation(FluidVariant fluid, long count) {
        class_3611 class_36112;
        if (!fluid.getFluid().method_15793(fluid.getFluid().method_15785()) && fluid.getFluid() != class_3612.field_15906 && (class_36112 = fluid.getFluid()) instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)class_36112;
            return FabricFluidManager.makeInformation(FluidVariant.of((class_3611)flowingFluid.method_15751(), (class_2487)fluid.copyNbt()), count);
        }
        if (fluid.copyNbt() == null) {
            return new FluidInformation(fluid.getFluid(), count);
        }
        return new FluidInformation(fluid.getFluid(), count, fluid.copyNbt());
    }

    public static FluidInformation makeInformation(FluidVariant fluid) {
        return FabricFluidManager.makeInformation(fluid, 1L);
    }

    @Override
    public long getBucketAmount() {
        return 81000L;
    }
}

