/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.events.FabricLootTableModificationContext;
import com.grim3212.assorted.lib.events.GenericEvent;
import com.grim3212.assorted.lib.events.LootTableModifyEvent;
import com.grim3212.assorted.lib.events.UseBlockEvent;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.platform.services.IEventHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1269;

public class FabricEventHelper
implements IEventHelper {
    private final Map<Class<?>, Runnable> eventInits = new HashMap();
    private final Multimap<Class<?>, Consumer<?>> eventHandlers = ArrayListMultimap.create();
    private boolean initialized = false;

    @Override
    public void registerEventType(Class<? extends GenericEvent> eventType, Runnable runnable) {
        this.eventInits.put(eventType, runnable);
    }

    @Override
    public <T extends GenericEvent> void handleEvents(T event) {
        for (Consumer h : this.eventHandlers.get(event.getClass())) {
            h.accept(event);
        }
    }

    @Override
    public void registerEvent(Class<? extends GenericEvent> eventType, Consumer<?> handler) {
        Runnable initializer;
        if (!this.initialized) {
            this.init();
        }
        if ((initializer = this.eventInits.remove(eventType)) != null) {
            initializer.run();
        } else {
            LibConstants.LOG.error("Could not find event initializer for " + eventType.getName());
        }
        this.eventHandlers.put(eventType, handler);
    }

    private void init() {
        this.initialized = true;
        Services.EVENTS.registerEventType(UseBlockEvent.class, () -> UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {
            UseBlockEvent event = new UseBlockEvent(player, level, hand, hitResult);
            Services.EVENTS.handleEvents(event);
            if (event.isCanceled()) {
                return class_1269.field_5814;
            }
            return event.getInteractionResult();
        }));
        Services.EVENTS.registerEventType(LootTableModifyEvent.class, () -> LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            LootTableModifyEvent event = new LootTableModifyEvent(lootManager.getLootTable(id), id, new FabricLootTableModificationContext(tableBuilder), source.isBuiltin());
            Services.EVENTS.handleEvents(event);
        }));
    }
}

