/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.config.ConfigurationType;
import com.grim3212.assorted.lib.config.FabricConfigurationBuilder;
import com.grim3212.assorted.lib.config.FabricConfigurationNetworkingUtils;
import com.grim3212.assorted.lib.config.FabricConfigurationSource;
import com.grim3212.assorted.lib.config.FabricConfigurationSpec;
import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import com.grim3212.assorted.lib.dist.Dist;
import com.grim3212.assorted.lib.dist.DistExecutor;
import com.grim3212.assorted.lib.platform.services.IConfigHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricConfigHelper
implements IConfigHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final class_2960 CONFIG_SYNC_CHANNEL_ID = new class_2960("assortedlib", "config_sync");
    private static final Map<String, FabricConfigurationSpec> syncedSources = Maps.newHashMap();
    private static final List<FabricConfigurationSpec> noneSyncedSources = Lists.newArrayList();

    public static void init() {
        DistExecutor.runWhenOn(Dist.CLIENT, () -> () -> FabricConfigurationNetworkingUtils.registerNetworkingChannel(CONFIG_SYNC_CHANNEL_ID, GSON, () -> syncedSources));
        ServerPlayConnectionEvents.JOIN.register((listener, packetSender, minecraftServer) -> FabricConfigHelper.syncTo(listener.method_32311()));
    }

    public static void syncTo(class_3222 serverPlayer) {
        JsonObject targetObject = new JsonObject();
        syncedSources.forEach((key, spec) -> {
            JsonObject specObject = spec.getSource().getConfig();
            targetObject.add(key, (JsonElement)specObject);
        });
        String payload = GSON.toJson((JsonElement)targetObject);
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10814(payload);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)CONFIG_SYNC_CHANNEL_ID, (class_2540)buffer);
    }

    @Override
    public IConfigurationBuilder createBuilder(ConfigurationType type, String name) {
        JsonObject localConfig = this.doesLocalConfigExist(name) ? this.loadLocalConfig(name) : new JsonObject();
        FabricConfigurationSource source = new FabricConfigurationSource(name, localConfig);
        return new FabricConfigurationBuilder(source, fabricConfigurationSpec -> {
            if (type == ConfigurationType.SYNCED) {
                syncedSources.put(name, (FabricConfigurationSpec)fabricConfigurationSpec);
            } else {
                noneSyncedSources.add((FabricConfigurationSpec)fabricConfigurationSpec);
            }
            fabricConfigurationSpec.forceGetAll();
            fabricConfigurationSpec.writeAll();
            this.saveLocalConfig(name, source.getConfig());
        });
    }

    private JsonObject loadLocalConfig(String name) {
        try {
            File configurationDirectory = FabricLoader.getInstance().getConfigDirectory();
            Path configPath = Path.of(configurationDirectory.getAbsolutePath(), name + ".json");
            FileReader fileReader = new FileReader(configPath.toAbsolutePath().toFile().getAbsolutePath());
            JsonElement containedElement = (JsonElement)GSON.fromJson((Reader)fileReader, JsonElement.class);
            if (!containedElement.isJsonObject()) {
                throw new IllegalStateException("Config file: " + name + " is not a json object!");
            }
            fileReader.close();
            return containedElement.getAsJsonObject();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open and read configuration file: " + name, e);
        }
    }

    private boolean doesLocalConfigExist(String name) {
        File configurationDirectory = FabricLoader.getInstance().getConfigDirectory();
        Path configPath = Path.of(configurationDirectory.getAbsolutePath(), name + ".json");
        return Files.exists(configPath, new LinkOption[0]);
    }

    private void saveLocalConfig(String name, JsonObject config) {
        try {
            File configurationDirectory = FabricLoader.getInstance().getConfigDirectory();
            Path configPath = Path.of(configurationDirectory.getAbsolutePath(), name + ".json");
            if (Files.exists(configPath, new LinkOption[0])) {
                Files.delete(configPath);
            }
            configPath.toFile().getParentFile().mkdirs();
            Files.createFile(configPath, new FileAttribute[0]);
            FileWriter fileWriter = new FileWriter(configPath.toAbsolutePath().toFile().getAbsolutePath());
            GSON.toJson((JsonElement)config, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open and read configuration file: " + name, e);
        }
    }
}

