/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.core.conditions.LibCondition;
import com.grim3212.assorted.lib.core.conditions.LibConditionProvider;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.platform.services.IConditionHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class FabricConditionHelper
implements IConditionHelper {
    public static final class_2960 ITEM_EXISTS = new class_2960("assortedlib", "item_exists");
    public static final class_2960 BLOCK_EXISTS = new class_2960("assortedlib", "block_exists");
    public static final class_2960 PART_ENABLED = new class_2960("assortedlib", "part_enabled");
    private static final Map<String, Supplier<Boolean>> REGISTERED_PARTS = new HashMap<String, Supplier<Boolean>>();

    @Override
    public void init() {
        ResourceConditions.register((class_2960)ITEM_EXISTS, object -> FabricConditionHelper.registryKeyExists(object, "item", class_7924.field_41197));
        ResourceConditions.register((class_2960)BLOCK_EXISTS, object -> FabricConditionHelper.registryKeyExists(object, "block", class_7924.field_41254));
        ResourceConditions.register((class_2960)PART_ENABLED, jsonObject -> {
            String foundPart = class_3518.method_15265((JsonObject)jsonObject, (String)"part");
            if (!REGISTERED_PARTS.containsKey(foundPart)) {
                throw new IllegalArgumentException("Can't check part that doesn't exist!");
            }
            return REGISTERED_PARTS.get(foundPart).get();
        });
    }

    @Override
    public void write(JsonObject conditionalObject, LibConditionProvider ... conditions) {
        ConditionJsonProvider.write((JsonObject)conditionalObject, conditions.length == 0 ? null : (ConditionJsonProvider[])Arrays.stream(conditions).map(FabricConditionHelper::wrap).toArray(ConditionJsonProvider[]::new));
    }

    @Override
    public void register(class_2960 name, LibCondition condition) {
        ResourceConditions.register((class_2960)name, condition::test);
    }

    @Override
    public boolean test(JsonObject json) {
        return ResourceConditions.objectMatchesConditions((JsonObject)json);
    }

    @Override
    public String getConditionsKey() {
        return "fabric:load_conditions";
    }

    @Override
    public LibConditionProvider and(LibConditionProvider ... values) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.and((ConditionJsonProvider[])((ConditionJsonProvider[])Arrays.stream(values).map(FabricConditionHelper::wrap).toArray(ConditionJsonProvider[]::new))));
    }

    @Override
    public LibConditionProvider not(LibConditionProvider value) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.not((ConditionJsonProvider)FabricConditionHelper.wrap(value)));
    }

    @Override
    public LibConditionProvider or(LibConditionProvider ... values) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.or((ConditionJsonProvider[])((ConditionJsonProvider[])Arrays.stream(values).map(FabricConditionHelper::wrap).toArray(ConditionJsonProvider[]::new))));
    }

    @Override
    public LibConditionProvider blockExists(class_2960 block) {
        return FabricConditionHelper.wrap(FabricConditionHelper.registryKeyExistsProvider(BLOCK_EXISTS, "block", block));
    }

    @Override
    public LibConditionProvider itemExists(class_2960 item) {
        return FabricConditionHelper.wrap(FabricConditionHelper.registryKeyExistsProvider(ITEM_EXISTS, "item", item));
    }

    @Override
    public LibConditionProvider blockTagExists(class_6862<class_2248> tag) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.tagsPopulated((class_6862[])new class_6862[]{tag}));
    }

    @Override
    public LibConditionProvider itemTagExists(class_6862<class_1792> tag) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.tagsPopulated((class_6862[])new class_6862[]{tag}));
    }

    @Override
    public LibConditionProvider modLoaded(String modId) {
        return FabricConditionHelper.wrap(DefaultResourceConditions.allModsLoaded((String[])new String[]{modId}));
    }

    @Override
    public LibConditionProvider partEnabled(String partId) {
        return FabricConditionHelper.wrap(FabricConditionHelper.partEnabledCondition(partId));
    }

    @Override
    public void registerPartCondition(String part, Supplier<Boolean> check) {
        if (REGISTERED_PARTS.containsKey(part)) {
            throw new IllegalArgumentException("Can't have registered part with the same name as another");
        }
        REGISTERED_PARTS.put(part, check);
    }

    public static LibConditionProvider wrap(ConditionJsonProvider condition) {
        return new LibConditionWrapper(condition);
    }

    public static ConditionJsonProvider wrap(LibConditionProvider condition) {
        return new ConditionJsonWrapper(condition);
    }

    private static ConditionJsonProvider registryKeyExistsProvider(final class_2960 id, final String jsonKey, final class_2960 key) {
        return new ConditionJsonProvider(){

            public class_2960 getConditionId() {
                return id;
            }

            public void writeParameters(JsonObject json) {
                json.addProperty(jsonKey, key.toString());
            }
        };
    }

    private static ConditionJsonProvider partEnabledCondition(final String part) {
        return new ConditionJsonProvider(){

            public class_2960 getConditionId() {
                return PART_ENABLED;
            }

            public void writeParameters(JsonObject json) {
                json.addProperty("part", part);
            }
        };
    }

    private static <T> boolean registryKeyExists(JsonObject object, String jsonKey, class_5321<? extends class_2378<T>> key) {
        return Services.PLATFORM.getRegistry(key).containsKey(new class_2960(class_3518.method_15265((JsonObject)object, (String)jsonKey)));
    }

    private static class LibConditionWrapper
    implements LibConditionProvider {
        private final ConditionJsonProvider condition;

        public LibConditionWrapper(ConditionJsonProvider condition) {
            this.condition = condition;
        }

        @Override
        public void write(JsonObject json) {
            this.condition.writeParameters(json);
        }

        @Override
        public class_2960 getName() {
            return this.condition.getConditionId();
        }
    }

    private static class ConditionJsonWrapper
    implements ConditionJsonProvider {
        private final LibConditionProvider provider;

        private ConditionJsonWrapper(LibConditionProvider provider) {
            this.provider = provider;
        }

        public class_2960 getConditionId() {
            return this.provider.getName();
        }

        public void writeParameters(JsonObject object) {
            this.provider.write(object);
        }
    }
}

