/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.mixin.world.item.enchantment;

import com.grim3212.assorted.lib.core.enchantment.LibEnchantment;
import com.grim3212.assorted.lib.core.item.IItemEnchantmentCondition;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public class EnchantmentHelperMixin {
    @Unique
    private static ThreadLocal<class_1887> capturedEnchantment = new ThreadLocal();
    @Unique
    private static ThreadLocal<class_1799> capturedItemStack = new ThreadLocal();

    @Redirect(method={"getAvailableEnchantmentResults"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;"))
    private static <E> E assortedlib_captureEnchantment(Iterator<class_1887> iterator) {
        class_1887 next = iterator.next();
        capturedEnchantment.set(next);
        return (E)next;
    }

    @Inject(method={"getAvailableEnchantmentResults"}, at={@At(value="HEAD")})
    private static void assortedlib_captureItemStack(int level, class_1799 stack, boolean allowTreasure, CallbackInfoReturnable<List<class_1889>> cir) {
        capturedItemStack.set(stack);
    }

    @Redirect(method={"getAvailableEnchantmentResults"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentCategory;canEnchant(Lnet/minecraft/world/item/Item;)Z"))
    private static boolean assortedlib_canEnchant(class_1886 instance, class_1792 item) {
        IItemEnchantmentCondition extension;
        LibEnchantment libEnchantment;
        Optional<Boolean> result;
        class_1887 class_18872 = capturedEnchantment.get();
        if (class_18872 instanceof LibEnchantment && (result = (libEnchantment = (LibEnchantment)class_18872).assortedlib_canApplyAtEnchantingTable(capturedItemStack.get())).isPresent()) {
            return result.get();
        }
        if (item instanceof IItemEnchantmentCondition && (result = (extension = (IItemEnchantmentCondition)item).assortedlib_canApplyAtEnchantingTable(capturedItemStack.get(), capturedEnchantment.get())).isPresent()) {
            return result.get();
        }
        return instance.method_8177(item);
    }

    @Inject(method={"getAvailableEnchantmentResults"}, at={@At(value="RETURN")})
    private static void assortedlib_clearCaptured(int level, class_1799 stack, boolean allowTreasure, CallbackInfoReturnable<List<class_1889>> cir) {
        capturedEnchantment.set(null);
        capturedItemStack.set(null);
    }
}

