/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.inventory;

import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

public class FabricWrappedItemHandler
implements IItemStorageHandler {
    private final InventoryStorage storage;
    private final class_2586 entity;

    public FabricWrappedItemHandler(class_2586 entity, @NotNull InventoryStorage storage) {
        this.storage = storage;
        this.entity = entity;
    }

    @Override
    public int getSlots() {
        return this.storage.getSlots().size();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        return ((ItemVariant)slotStorage.getResource()).toStack((int)slotStorage.getAmount());
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        if (!slotStorage.supportsInsertion() || stack.method_7960()) {
            return stack;
        }
        if (!slotStorage.isResourceBlank() && !Services.INVENTORY.canItemStacksStack(stack, ((ItemVariant)slotStorage.getResource()).toStack((int)slotStorage.getAmount()))) {
            return stack;
        }
        ItemVariant toInsert = ItemVariant.of((class_1799)stack);
        if (simulate) {
            int inserted = (int)slotStorage.simulateInsert((Object)toInsert, (long)stack.method_7947(), null);
            if (inserted <= 0) {
                return stack;
            }
            int remainder = stack.method_7947() - inserted;
            if (remainder > 0) {
                return stack.method_46651(remainder);
            }
            return class_1799.field_8037;
        }
        try (Transaction context = Transaction.openOuter();){
            int inserted = (int)slotStorage.insert((Object)toInsert, (long)stack.method_7947(), (TransactionContext)context);
            context.commit();
            if (inserted <= 0) {
                class_1799 class_17992 = stack;
                return class_17992;
            }
            int remainder = stack.method_7947() - inserted;
            if (remainder > 0) {
                class_1799 class_17993 = stack.method_46651(remainder);
                return class_17993;
            }
            class_1799 class_17994 = class_1799.field_8037;
            return class_17994;
        }
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        if (!slotStorage.supportsExtraction() || amount < 0) {
            return class_1799.field_8037;
        }
        ItemVariant variant = (ItemVariant)slotStorage.getResource();
        if (variant.isBlank()) {
            return class_1799.field_8037;
        }
        if (simulate) {
            int extracted = (int)slotStorage.simulateExtract((Object)variant, (long)amount, null);
            if (extracted <= 0) {
                return class_1799.field_8037;
            }
            return ((ItemVariant)slotStorage.getResource()).toStack(extracted);
        }
        try (Transaction context = Transaction.openOuter();){
            class_1799 extractingType = ((ItemVariant)slotStorage.getResource()).toStack();
            int extracted = (int)slotStorage.extract((Object)variant, (long)amount, (TransactionContext)context);
            context.commit();
            if (extracted <= 0) {
                class_1799 class_17992 = class_1799.field_8037;
                return class_17992;
            }
            class_1799 class_17993 = extractingType.method_46651(extracted);
            return class_17993;
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return (int)this.storage.getSlot(slot).getCapacity();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        return slotStorage.supportsInsertion() && slotStorage.simulateInsert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), null) > 0L;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        try (Transaction context = Transaction.openOuter();){
            slotStorage.extract((Object)((ItemVariant)slotStorage.getResource()), slotStorage.getCapacity(), (TransactionContext)context);
            slotStorage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)context);
            context.commit();
        }
    }

    @Override
    public void onContentsChanged(int slot) {
        if (this.entity != null) {
            this.entity.method_5431();
        }
    }
}

