/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.inventory;

import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class FabricItemSlot
extends SnapshotParticipant<class_1799>
implements SingleSlotStorage<ItemVariant> {
    private final IItemStorageHandler storageHandler;
    private final int slot;

    public FabricItemSlot(IItemStorageHandler storage, int slot) {
        this.storageHandler = storage;
        this.slot = slot;
    }

    public class_1799 getStack() {
        return this.storageHandler.getStackInSlot(this.slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        class_1799 stackToInsert = resource.toStack((int)maxAmount);
        class_1799 inserted = this.storageHandler.insertItem(this.slot, stackToInsert, true);
        if (inserted.method_7960() || inserted.method_7947() < stackToInsert.method_7947()) {
            this.updateSnapshots(transaction);
            this.storageHandler.insertItem(this.slot, stackToInsert, false);
            return inserted.method_7960() ? maxAmount : maxAmount - (long)inserted.method_7947();
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!Services.INVENTORY.canItemStacksStack(this.getStack(), resource.toStack())) {
            return 0L;
        }
        class_1799 extracted = this.storageHandler.extractItem(this.slot, (int)maxAmount, true);
        if (!extracted.method_7960()) {
            this.updateSnapshots(transaction);
            this.storageHandler.extractItem(this.slot, (int)maxAmount, false);
            return extracted.method_7947();
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getStack().method_7960();
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.getStack());
    }

    public long getAmount() {
        return this.getStack().method_7947();
    }

    public long getCapacity() {
        return this.storageHandler.getSlotLimit(this.slot);
    }

    protected class_1799 createSnapshot() {
        return this.getStack().method_7972();
    }

    protected void readSnapshot(class_1799 snapshot) {
        this.storageHandler.setStackInSlot(this.slot, snapshot);
    }
}

