/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.fluid;

import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.core.fluid.IFluidVariantHandler;
import com.grim3212.assorted.lib.dist.DistExecutor;
import com.grim3212.assorted.lib.fluid.FabricFluidVariantRenderHandlerDelegate;
import com.grim3212.assorted.lib.platform.FabricFluidManager;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_7764;

public class FabricFluidVariantHandlerDelegate
implements IFluidVariantHandler {
    private final FluidVariantAttributeHandler delegate;

    public FabricFluidVariantHandlerDelegate(FluidVariantAttributeHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public class_2561 getName(FluidInformation fluidInformation) {
        return this.delegate.getName(FabricFluidManager.makeVariant(fluidInformation));
    }

    @Override
    public Optional<class_3414> getFillSound(FluidInformation variant) {
        return this.delegate.getFillSound(FabricFluidManager.makeVariant(variant));
    }

    @Override
    public Optional<class_3414> getEmptySound(FluidInformation variant) {
        return this.delegate.getEmptySound(FabricFluidManager.makeVariant(variant));
    }

    @Override
    public int getLuminance(FluidInformation variant) {
        return this.delegate.getLuminance(FabricFluidManager.makeVariant(variant));
    }

    @Override
    public int getTemperature(FluidInformation variant) {
        return this.delegate.getTemperature(FabricFluidManager.makeVariant(variant));
    }

    @Override
    public int getViscosity(FluidInformation variant) {
        return this.delegate.getViscosity(FabricFluidManager.makeVariant(variant), null);
    }

    @Override
    public int getDensity(FluidInformation variant) {
        if (this.delegate.isLighterThanAir(FabricFluidManager.makeVariant(variant))) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getTintColor(FluidInformation variant) {
        return (Integer)DistExecutor.unsafeRunForDist(() -> () -> FluidVariantRendering.getColor((FluidVariant)FabricFluidManager.makeVariant(variant)), () -> () -> 0xFFFFFF);
    }

    @Override
    public Optional<class_2960> getStillTexture(FluidInformation variant) {
        return (Optional)DistExecutor.unsafeRunForDist(() -> () -> {
            FluidVariantRenderHandler handler = FluidVariantRendering.getHandlerOrDefault((class_3611)variant.fluid());
            if (handler instanceof FabricFluidVariantRenderHandlerDelegate) {
                FabricFluidVariantRenderHandlerDelegate renderDelegate = (FabricFluidVariantRenderHandlerDelegate)handler;
                return renderDelegate.getDelegate().getStillTexture(variant);
            }
            return Optional.ofNullable(FluidVariantRendering.getSprites((FluidVariant)FabricFluidManager.makeVariant(variant))).map(sprites -> sprites[0]).map(class_1058::method_45851).map(class_7764::method_45816);
        }, () -> Optional::empty);
    }

    @Override
    public Optional<class_2960> getFlowingTexture(FluidInformation variant) {
        return (Optional)DistExecutor.unsafeRunForDist(() -> () -> {
            FluidVariantRenderHandler handler = FluidVariantRendering.getHandlerOrDefault((class_3611)variant.fluid());
            if (handler instanceof FabricFluidVariantRenderHandlerDelegate) {
                FabricFluidVariantRenderHandlerDelegate renderDelegate = (FabricFluidVariantRenderHandlerDelegate)handler;
                return renderDelegate.getDelegate().getFlowingTexture(variant);
            }
            return Optional.ofNullable(FluidVariantRendering.getSprites((FluidVariant)FabricFluidManager.makeVariant(variant))).map(sprites -> sprites[1]).map(class_1058::method_45851).map(class_7764::method_45816);
        }, () -> Optional::empty);
    }
}

