/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.data;

import com.grim3212.assorted.lib.data.LibBiomeTagProvider;
import com.grim3212.assorted.lib.data.LibBlockTagProvider;
import com.grim3212.assorted.lib.data.LibItemTagProvider;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.DyeHelper;
import com.grim3212.assorted.lib.util.LibCommonTags;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7889;
import net.minecraft.class_7924;

public class LibCommonTagProvider {

    public static class BiomeTagProvider
    extends LibBiomeTagProvider {
        public BiomeTagProvider(class_7784 output, CompletableFuture<class_7225.class_7874> lookupProvider) {
            super(output, lookupProvider);
        }

        @Override
        public void addCommonTags(Function<class_6862<class_1959>, class_2474.class_5124<class_1959>> tagger) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9451, LibCommonTags.Biomes.IS_PLAINS);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9424, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DESERT);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9420, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9471, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_SWAMP);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9461, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9411, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9435, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9463, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35117, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_WASTELAND, LibCommonTags.Biomes.IS_PLAINS);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9462, LibCommonTags.Biomes.IS_MUSHROOM, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9417, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_DENSE_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35118, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9434, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_SANDY);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9478, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9475, LibCommonTags.Biomes.IS_SPOOKY, LibCommonTags.Biomes.IS_DENSE_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9454, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35119, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35120, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9449, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9430, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE, LibCommonTags.Biomes.IS_SLOPE, LibCommonTags.Biomes.IS_PLATEAU);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9415, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DRY_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35110, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SLOPE, LibCommonTags.Biomes.IS_PLATEAU);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_34470, LibCommonTags.Biomes.IS_PLAINS, LibCommonTags.Biomes.IS_PLATEAU, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_34471, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_34472, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_34474, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35115, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_34475, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9457, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9447, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9442, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9465, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9408, LibCommonTags.Biomes.IS_HOT_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9467, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9470, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9418, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9473, LibCommonTags.Biomes.IS_VOID);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9455, LibCommonTags.Biomes.IS_PLAINS, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35111, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9414, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9453, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35112, LibCommonTags.Biomes.IS_DENSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35113, LibCommonTags.Biomes.IS_DENSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_35114, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9443, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_9440, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_29218, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_LUSH, LibCommonTags.Biomes.IS_WET_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_28107, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_22076, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_22077, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_22075, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_23859, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_38748, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SWAMP);
                this.tagAll(tagger, (class_5321<class_1959>)class_1972.field_37543, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_RARE, LibCommonTags.Biomes.IS_SPOOKY);
                tagger.apply(LibCommonTags.Biomes.IS_HOT).method_26792(LibCommonTags.Biomes.IS_HOT_OVERWORLD).method_26792(LibCommonTags.Biomes.IS_HOT_NETHER).method_35923(LibCommonTags.Biomes.IS_HOT_END.comp_327());
                tagger.apply(LibCommonTags.Biomes.IS_COLD).method_26792(LibCommonTags.Biomes.IS_COLD_OVERWORLD).method_35923(LibCommonTags.Biomes.IS_COLD_NETHER.comp_327()).method_26792(LibCommonTags.Biomes.IS_COLD_END);
                tagger.apply(LibCommonTags.Biomes.IS_SPARSE).method_26792(LibCommonTags.Biomes.IS_SPARSE_OVERWORLD).method_35923(LibCommonTags.Biomes.IS_SPARSE_NETHER.comp_327()).method_35923(LibCommonTags.Biomes.IS_SPARSE_END.comp_327());
                tagger.apply(LibCommonTags.Biomes.IS_DENSE).method_26792(LibCommonTags.Biomes.IS_DENSE_OVERWORLD).method_35923(LibCommonTags.Biomes.IS_DENSE_NETHER.comp_327()).method_35923(LibCommonTags.Biomes.IS_DENSE_END.comp_327());
                tagger.apply(LibCommonTags.Biomes.IS_WET).method_26792(LibCommonTags.Biomes.IS_WET_OVERWORLD).method_35923(LibCommonTags.Biomes.IS_WET_NETHER.comp_327()).method_35923(LibCommonTags.Biomes.IS_WET_END.comp_327());
                tagger.apply(LibCommonTags.Biomes.IS_DRY).method_26792(LibCommonTags.Biomes.IS_DRY_OVERWORLD).method_26792(LibCommonTags.Biomes.IS_DRY_NETHER).method_26792(LibCommonTags.Biomes.IS_DRY_END);
                tagger.apply(LibCommonTags.Biomes.IS_WATER).method_35923(class_6908.field_36509.comp_327()).method_35923(class_6908.field_36511.comp_327());
                tagger.apply(LibCommonTags.Biomes.IS_MOUNTAIN).method_26792(LibCommonTags.Biomes.IS_PEAK).method_26792(LibCommonTags.Biomes.IS_SLOPE);
                tagger.apply(LibCommonTags.Biomes.IS_UNDERGROUND).method_26792(LibCommonTags.Biomes.IS_CAVE);
            }
        }
    }

    public static class ItemTagProvider
    extends LibItemTagProvider {
        public ItemTagProvider(class_7784 output, CompletableFuture<class_7225.class_7874> lookup, CompletableFuture<class_2474.class_8211<class_2248>> blockTags) {
            super(output, lookup, blockTags);
        }

        @Override
        public void addCommonTags(Function<class_6862<class_1792>, class_7889.class_7890<class_1792>> tagger, BiConsumer<class_6862<class_2248>, class_6862<class_1792>> copier) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                copier.accept(LibCommonTags.Blocks.STONE, LibCommonTags.Items.STONE);
                for (class_1767 class_17672 : class_1767.values()) {
                    class_6862<class_1792> dyeTag = DyeHelper.getDyeTag(class_17672);
                    tagger.apply(LibCommonTags.Items.DYES).method_46828(dyeTag);
                    tagger.apply(dyeTag).method_46829((Object)class_1769.method_7803((class_1767)class_17672));
                }
                copier.accept(LibCommonTags.Blocks.BARRELS, LibCommonTags.Items.BARRELS);
                copier.accept(LibCommonTags.Blocks.BARRELS_WOODEN, LibCommonTags.Items.BARRELS_WOODEN);
                tagger.apply(LibCommonTags.Items.BONES).method_46829((Object)class_1802.field_8606);
                copier.accept(LibCommonTags.Blocks.BOOKSHELVES, LibCommonTags.Items.BOOKSHELVES);
                copier.accept(LibCommonTags.Blocks.CHESTS, LibCommonTags.Items.CHESTS);
                copier.accept(LibCommonTags.Blocks.CHESTS_ENDER, LibCommonTags.Items.CHESTS_ENDER);
                copier.accept(LibCommonTags.Blocks.CHESTS_TRAPPED, LibCommonTags.Items.CHESTS_TRAPPED);
                copier.accept(LibCommonTags.Blocks.CHESTS_WOODEN, LibCommonTags.Items.CHESTS_WOODEN);
                copier.accept(LibCommonTags.Blocks.COBBLESTONE, LibCommonTags.Items.COBBLESTONE);
                tagger.apply(LibCommonTags.Items.DUSTS).method_46828(LibCommonTags.Items.DUSTS_GLOWSTONE);
                tagger.apply(LibCommonTags.Items.DUSTS).method_46828(LibCommonTags.Items.DUSTS_PRISMARINE);
                tagger.apply(LibCommonTags.Items.DUSTS).method_46828(LibCommonTags.Items.DUSTS_REDSTONE);
                tagger.apply(LibCommonTags.Items.DUSTS_GLOWSTONE).method_46829((Object)class_1802.field_8601);
                tagger.apply(LibCommonTags.Items.DUSTS_PRISMARINE).method_46829((Object)class_1802.field_8662);
                tagger.apply(LibCommonTags.Items.DUSTS_REDSTONE).method_46829((Object)class_1802.field_8725);
                tagger.apply(LibCommonTags.Items.EGGS).method_46829((Object)class_1802.field_8803);
                copier.accept(LibCommonTags.Blocks.END_STONES, LibCommonTags.Items.END_STONES);
                tagger.apply(LibCommonTags.Items.ENDER_PEARLS).method_46829((Object)class_1802.field_8634);
                tagger.apply(LibCommonTags.Items.FEATHERS).method_46829((Object)class_1802.field_8153);
                copier.accept(LibCommonTags.Blocks.FENCE_GATES, LibCommonTags.Items.FENCE_GATES);
                copier.accept(LibCommonTags.Blocks.FENCE_GATES_WOODEN, LibCommonTags.Items.FENCE_GATES_WOODEN);
                copier.accept(LibCommonTags.Blocks.FENCES, LibCommonTags.Items.FENCES);
                copier.accept(LibCommonTags.Blocks.FENCES_NETHER_BRICK, LibCommonTags.Items.FENCES_NETHER_BRICK);
                copier.accept(LibCommonTags.Blocks.FENCES_WOODEN, LibCommonTags.Items.FENCES_WOODEN);
                List<class_6862> gemTags = Arrays.asList(LibCommonTags.Items.GEMS_AMETHYST, LibCommonTags.Items.GEMS_DIAMOND, LibCommonTags.Items.GEMS_EMERALD, LibCommonTags.Items.GEMS_LAPIS, LibCommonTags.Items.GEMS_PRISMARINE, LibCommonTags.Items.GEMS_QUARTZ);
                for (class_6862 gemTag : gemTags) {
                    tagger.apply(LibCommonTags.Items.GEMS).method_46828(gemTag);
                }
                tagger.apply(LibCommonTags.Items.GEMS_AMETHYST).method_46829((Object)class_1802.field_27063);
                tagger.apply(LibCommonTags.Items.GEMS_DIAMOND).method_46829((Object)class_1802.field_8477);
                tagger.apply(LibCommonTags.Items.GEMS_EMERALD).method_46829((Object)class_1802.field_8687);
                tagger.apply(LibCommonTags.Items.GEMS_LAPIS).method_46829((Object)class_1802.field_8759);
                tagger.apply(LibCommonTags.Items.GEMS_PRISMARINE).method_46829((Object)class_1802.field_8434);
                tagger.apply(LibCommonTags.Items.GEMS_QUARTZ).method_46829((Object)class_1802.field_8155);
                copier.accept(LibCommonTags.Blocks.GRAVEL, LibCommonTags.Items.GRAVEL);
                tagger.apply(LibCommonTags.Items.GUNPOWDER).method_46829((Object)class_1802.field_8054);
                List<class_6862> ingotTags = Arrays.asList(LibCommonTags.Items.INGOTS_BRICK, LibCommonTags.Items.INGOTS_COPPER, LibCommonTags.Items.INGOTS_GOLD, LibCommonTags.Items.INGOTS_IRON, LibCommonTags.Items.INGOTS_NETHERITE, LibCommonTags.Items.INGOTS_NETHER_BRICK);
                for (class_6862 class_68622 : ingotTags) {
                    tagger.apply(LibCommonTags.Items.INGOTS).method_46828(class_68622);
                }
                tagger.apply(LibCommonTags.Items.INGOTS_BRICK).method_46829((Object)class_1802.field_8621);
                tagger.apply(LibCommonTags.Items.INGOTS_COPPER).method_46829((Object)class_1802.field_27022);
                tagger.apply(LibCommonTags.Items.INGOTS_GOLD).method_46829((Object)class_1802.field_8695);
                tagger.apply(LibCommonTags.Items.INGOTS_IRON).method_46829((Object)class_1802.field_8620);
                tagger.apply(LibCommonTags.Items.INGOTS_NETHERITE).method_46829((Object)class_1802.field_22020);
                tagger.apply(LibCommonTags.Items.INGOTS_NETHER_BRICK).method_46829((Object)class_1802.field_8729);
                tagger.apply(LibCommonTags.Items.LEATHER).method_46829((Object)class_1802.field_8745);
                tagger.apply(LibCommonTags.Items.NETHER_STARS).method_46829((Object)class_1802.field_8137);
                copier.accept(LibCommonTags.Blocks.NETHERRACK, LibCommonTags.Items.NETHERRACK);
                tagger.apply(LibCommonTags.Items.NUGGETS).method_46828(LibCommonTags.Items.NUGGETS_GOLD);
                tagger.apply(LibCommonTags.Items.NUGGETS).method_46828(LibCommonTags.Items.NUGGETS_IRON);
                tagger.apply(LibCommonTags.Items.NUGGETS_IRON).method_46829((Object)class_1802.field_8675);
                tagger.apply(LibCommonTags.Items.NUGGETS_GOLD).method_46829((Object)class_1802.field_8397);
                copier.accept(LibCommonTags.Blocks.OBSIDIAN, LibCommonTags.Items.OBSIDIAN);
                copier.accept(LibCommonTags.Blocks.ORES, LibCommonTags.Items.ORES);
                copier.accept(LibCommonTags.Blocks.ORES_COAL, LibCommonTags.Items.ORES_COAL);
                copier.accept(LibCommonTags.Blocks.ORES_COPPER, LibCommonTags.Items.ORES_COPPER);
                copier.accept(LibCommonTags.Blocks.ORES_DIAMOND, LibCommonTags.Items.ORES_DIAMOND);
                copier.accept(LibCommonTags.Blocks.ORES_EMERALD, LibCommonTags.Items.ORES_EMERALD);
                copier.accept(LibCommonTags.Blocks.ORES_GOLD, LibCommonTags.Items.ORES_GOLD);
                copier.accept(LibCommonTags.Blocks.ORES_IRON, LibCommonTags.Items.ORES_IRON);
                copier.accept(LibCommonTags.Blocks.ORES_LAPIS, LibCommonTags.Items.ORES_LAPIS);
                copier.accept(LibCommonTags.Blocks.ORES_QUARTZ, LibCommonTags.Items.ORES_QUARTZ);
                copier.accept(LibCommonTags.Blocks.ORES_REDSTONE, LibCommonTags.Items.ORES_REDSTONE);
                copier.accept(LibCommonTags.Blocks.ORES_NETHERITE_SCRAP, LibCommonTags.Items.ORES_NETHERITE_SCRAP);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).method_46828(LibCommonTags.Items.RAW_MATERIALS_COPPER);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).method_46828(LibCommonTags.Items.RAW_MATERIALS_GOLD);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).method_46828(LibCommonTags.Items.RAW_MATERIALS_IRON);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_COPPER).method_46829((Object)class_1802.field_33401);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_GOLD).method_46829((Object)class_1802.field_33402);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_IRON).method_46829((Object)class_1802.field_33400);
                tagger.apply(LibCommonTags.Items.RODS).method_46828(LibCommonTags.Items.RODS_WOODEN);
                tagger.apply(LibCommonTags.Items.RODS).method_46828(LibCommonTags.Items.RODS_BLAZE);
                tagger.apply(LibCommonTags.Items.RODS_BLAZE).method_46829((Object)class_1802.field_8894);
                tagger.apply(LibCommonTags.Items.RODS_WOODEN).method_46829((Object)class_1802.field_8600);
                tagger.apply(LibCommonTags.Items.SHEARS).method_46829((Object)class_1802.field_8868);
                tagger.apply(LibCommonTags.Items.SLIMEBALLS).method_46829((Object)class_1802.field_8777);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS, LibCommonTags.Items.STORAGE_BLOCKS);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST, LibCommonTags.Items.STORAGE_BLOCKS_AMETHYST);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_COAL, LibCommonTags.Items.STORAGE_BLOCKS_COAL);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER, LibCommonTags.Items.STORAGE_BLOCKS_COPPER);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND, LibCommonTags.Items.STORAGE_BLOCKS_DIAMOND);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD, LibCommonTags.Items.STORAGE_BLOCKS_EMERALD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD, LibCommonTags.Items.STORAGE_BLOCKS_GOLD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_IRON, LibCommonTags.Items.STORAGE_BLOCKS_IRON);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS, LibCommonTags.Items.STORAGE_BLOCKS_LAPIS);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ, LibCommonTags.Items.STORAGE_BLOCKS_QUARTZ);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE, LibCommonTags.Items.STORAGE_BLOCKS_REDSTONE);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER, LibCommonTags.Items.STORAGE_BLOCKS_RAW_COPPER);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD, LibCommonTags.Items.STORAGE_BLOCKS_RAW_GOLD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON, LibCommonTags.Items.STORAGE_BLOCKS_RAW_IRON);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE, LibCommonTags.Items.STORAGE_BLOCKS_NETHERITE);
                tagger.apply(LibCommonTags.Items.STRING).method_46829((Object)class_1802.field_8276);
                tagger.apply(LibCommonTags.Items.TOOLS_SWORDS).method_46830((Object[])new class_1792[]{class_1802.field_8091, class_1802.field_8528, class_1802.field_8371, class_1802.field_8845, class_1802.field_8802, class_1802.field_22022});
                tagger.apply(LibCommonTags.Items.TOOLS_AXES).method_46830((Object[])new class_1792[]{class_1802.field_8406, class_1802.field_8062, class_1802.field_8475, class_1802.field_8825, class_1802.field_8556, class_1802.field_22025});
                tagger.apply(LibCommonTags.Items.TOOLS_PICKAXES).method_46830((Object[])new class_1792[]{class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8335, class_1802.field_8377, class_1802.field_22024});
                tagger.apply(LibCommonTags.Items.TOOLS_SHOVELS).method_46830((Object[])new class_1792[]{class_1802.field_8876, class_1802.field_8776, class_1802.field_8699, class_1802.field_8322, class_1802.field_8250, class_1802.field_22023});
                tagger.apply(LibCommonTags.Items.TOOLS_HOES).method_46830((Object[])new class_1792[]{class_1802.field_8167, class_1802.field_8431, class_1802.field_8609, class_1802.field_8303, class_1802.field_8527, class_1802.field_22026});
                tagger.apply(LibCommonTags.Items.TOOLS_SHIELDS).method_46829((Object)class_1802.field_8255);
                tagger.apply(LibCommonTags.Items.TOOLS_BOWS).method_46829((Object)class_1802.field_8102);
                tagger.apply(LibCommonTags.Items.TOOLS_CROSSBOWS).method_46829((Object)class_1802.field_8399);
                tagger.apply(LibCommonTags.Items.TOOLS_FISHING_RODS).method_46829((Object)class_1802.field_8378);
                tagger.apply(LibCommonTags.Items.TOOLS_TRIDENTS).method_46829((Object)class_1802.field_8547);
                List<class_6862> toolTags = Arrays.asList(LibCommonTags.Items.TOOLS_SWORDS, LibCommonTags.Items.TOOLS_AXES, LibCommonTags.Items.TOOLS_PICKAXES, LibCommonTags.Items.TOOLS_SHOVELS, LibCommonTags.Items.TOOLS_HOES, LibCommonTags.Items.TOOLS_SHIELDS, LibCommonTags.Items.TOOLS_BOWS, LibCommonTags.Items.TOOLS_CROSSBOWS, LibCommonTags.Items.TOOLS_FISHING_RODS, LibCommonTags.Items.TOOLS_TRIDENTS);
                for (class_6862 toolTag : toolTags) {
                    tagger.apply(LibCommonTags.Items.TOOLS).method_46828(toolTag);
                }
                tagger.apply(LibCommonTags.Items.ARMORS_HELMETS).method_46830((Object[])new class_1792[]{class_1802.field_8267, class_1802.field_8090, class_1802.field_8283, class_1802.field_8743, class_1802.field_8862, class_1802.field_8805, class_1802.field_22027});
                tagger.apply(LibCommonTags.Items.ARMORS_CHESTPLATES).method_46830((Object[])new class_1792[]{class_1802.field_8577, class_1802.field_8873, class_1802.field_8523, class_1802.field_8678, class_1802.field_8058, class_1802.field_22028});
                tagger.apply(LibCommonTags.Items.ARMORS_LEGGINGS).method_46830((Object[])new class_1792[]{class_1802.field_8570, class_1802.field_8218, class_1802.field_8396, class_1802.field_8416, class_1802.field_8348, class_1802.field_22029});
                tagger.apply(LibCommonTags.Items.ARMORS_BOOTS).method_46830((Object[])new class_1792[]{class_1802.field_8370, class_1802.field_8313, class_1802.field_8660, class_1802.field_8753, class_1802.field_8285, class_1802.field_22030});
                List<class_6862> list = Arrays.asList(LibCommonTags.Items.ARMORS_HELMETS, LibCommonTags.Items.ARMORS_CHESTPLATES, LibCommonTags.Items.ARMORS_LEGGINGS, LibCommonTags.Items.ARMORS_BOOTS);
                for (class_6862 armorTag : list) {
                    tagger.apply(LibCommonTags.Items.ARMORS).method_46828(armorTag);
                }
                copier.accept(LibCommonTags.Blocks.GLASS, LibCommonTags.Items.GLASS);
                copier.accept(LibCommonTags.Blocks.GLASS_TINTED, LibCommonTags.Items.GLASS_TINTED);
                copier.accept(LibCommonTags.Blocks.GLASS_PANES, LibCommonTags.Items.GLASS_PANES);
                this.copyColored(LibCommonTags.Blocks.GLASS, LibCommonTags.Items.GLASS, copier);
                this.copyColored(LibCommonTags.Blocks.GLASS_PANES, LibCommonTags.Items.GLASS_PANES, copier);
                tagger.apply(LibCommonTags.Items.CROPS).method_46828(LibCommonTags.Items.CROPS_BEETROOT).method_46828(LibCommonTags.Items.CROPS_CARROT).method_46828(LibCommonTags.Items.CROPS_NETHER_WART).method_46828(LibCommonTags.Items.CROPS_POTATO).method_46828(LibCommonTags.Items.CROPS_WHEAT);
                tagger.apply(LibCommonTags.Items.CROPS_BEETROOT).method_46829((Object)class_1802.field_8186);
                tagger.apply(LibCommonTags.Items.CROPS_CARROT).method_46829((Object)class_1802.field_8179);
                tagger.apply(LibCommonTags.Items.CROPS_NETHER_WART).method_46829((Object)class_1802.field_8790);
                tagger.apply(LibCommonTags.Items.CROPS_POTATO).method_46829((Object)class_1802.field_8567);
                tagger.apply(LibCommonTags.Items.CROPS_WHEAT).method_46829((Object)class_1802.field_8861);
            }
            copier.accept(LibCommonTags.Blocks.CONCRETE, LibCommonTags.Items.CONCRETE);
            copier.accept(LibCommonTags.Blocks.CONCRETE_POWDER, LibCommonTags.Items.CONCRETE_POWDER);
            copier.accept(LibCommonTags.Blocks.CARPET, LibCommonTags.Items.CARPET);
            tagger.apply(LibCommonTags.Items.FLUID_CONTAINERS).method_46830((Object[])new class_1792[]{class_1802.field_8550, class_1802.field_8705, class_1802.field_8187});
            tagger.apply(LibCommonTags.Items.BUCKETS_MILK).method_46829((Object)class_1802.field_8103);
        }

        private void copyColored(class_6862<class_2248> blockGroup, class_6862<class_1792> itemGroup, BiConsumer<class_6862<class_2248>, class_6862<class_1792>> copier) {
            String blockPre = blockGroup.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + "_";
            String itemPre = itemGroup.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + "_";
            for (class_1767 color : class_1767.values()) {
                class_6862<class_2248> from = this.getCommonBlockTag(blockPre + color.method_7792());
                class_6862<class_1792> to = this.getCommonItemTag(itemPre + color.method_7792());
                copier.accept(from, to);
            }
            copier.accept(this.getCommonBlockTag(blockPre + "colorless"), this.getCommonItemTag(itemPre + "colorless"));
        }

        private class_6862<class_2248> getCommonBlockTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862)LibCommonTags.Blocks.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }

        private class_6862<class_1792> getCommonItemTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862)LibCommonTags.Items.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Items.class.getName() + " is missing tag name: " + name);
            }
        }
    }

    public static class BlockTagProvider
    extends LibBlockTagProvider {
        public BlockTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup) {
            super(packOutput, lookup);
        }

        @Override
        public void addCommonTags(Function<class_6862<class_2248>, class_7889.class_7890<class_2248>> tagger) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                tagger.apply(LibCommonTags.Blocks.BARRELS).method_46828(LibCommonTags.Blocks.BARRELS_WOODEN);
                tagger.apply(LibCommonTags.Blocks.BARRELS_WOODEN).method_46829((Object)class_2246.field_16328);
                tagger.apply(LibCommonTags.Blocks.BOOKSHELVES).method_46829((Object)class_2246.field_10504);
                tagger.apply(LibCommonTags.Blocks.CHESTS).method_46828(LibCommonTags.Blocks.CHESTS_ENDER);
                tagger.apply(LibCommonTags.Blocks.CHESTS).method_46828(LibCommonTags.Blocks.CHESTS_TRAPPED);
                tagger.apply(LibCommonTags.Blocks.CHESTS).method_46828(LibCommonTags.Blocks.CHESTS_WOODEN);
                tagger.apply(LibCommonTags.Blocks.CHESTS_ENDER).method_46829((Object)class_2246.field_10443);
                tagger.apply(LibCommonTags.Blocks.CHESTS_TRAPPED).method_46829((Object)class_2246.field_10380);
                tagger.apply(LibCommonTags.Blocks.CHESTS_WOODEN).method_46830((Object[])new class_2248[]{class_2246.field_10034, class_2246.field_10380});
                tagger.apply(LibCommonTags.Blocks.COBBLESTONE).method_46830((Object[])new class_2248[]{class_2246.field_10445, class_2246.field_10492, class_2246.field_9989, class_2246.field_29031});
                tagger.apply(LibCommonTags.Blocks.END_STONES).method_46829((Object)class_2246.field_10471);
                tagger.apply(LibCommonTags.Blocks.FENCE_GATES).method_46828(LibCommonTags.Blocks.FENCE_GATES_WOODEN);
                tagger.apply(LibCommonTags.Blocks.FENCE_GATES_WOODEN).method_46830((Object[])new class_2248[]{class_2246.field_10188, class_2246.field_10291, class_2246.field_10513, class_2246.field_10041, class_2246.field_10457, class_2246.field_10196, class_2246.field_22096, class_2246.field_22097, class_2246.field_37563});
                tagger.apply(LibCommonTags.Blocks.FENCES).method_46828(LibCommonTags.Blocks.FENCES_WOODEN);
                tagger.apply(LibCommonTags.Blocks.FENCES).method_46828(LibCommonTags.Blocks.FENCES_NETHER_BRICK);
                tagger.apply(LibCommonTags.Blocks.FENCES_NETHER_BRICK).method_46829((Object)class_2246.field_10364);
                tagger.apply(LibCommonTags.Blocks.FENCES_WOODEN).method_35923(class_3481.field_17619.comp_327());
                tagger.apply(LibCommonTags.Blocks.GRAVEL).method_46829((Object)class_2246.field_10255);
                tagger.apply(LibCommonTags.Blocks.NETHERRACK).method_46829((Object)class_2246.field_10515);
                tagger.apply(LibCommonTags.Blocks.OBSIDIAN).method_46829((Object)class_2246.field_10540);
                List<class_6862> oreTags = Arrays.asList(LibCommonTags.Blocks.ORES_COAL, LibCommonTags.Blocks.ORES_COPPER, LibCommonTags.Blocks.ORES_DIAMOND, LibCommonTags.Blocks.ORES_EMERALD, LibCommonTags.Blocks.ORES_GOLD, LibCommonTags.Blocks.ORES_IRON, LibCommonTags.Blocks.ORES_LAPIS, LibCommonTags.Blocks.ORES_REDSTONE, LibCommonTags.Blocks.ORES_QUARTZ, LibCommonTags.Blocks.ORES_NETHERITE_SCRAP);
                for (class_6862 oreTag : oreTags) {
                    tagger.apply(LibCommonTags.Blocks.ORES).method_46828(oreTag);
                }
                tagger.apply(LibCommonTags.Blocks.ORES_COAL).method_35923(class_3481.field_29193.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_COPPER).method_35923(class_3481.field_29195.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_DIAMOND).method_35923(class_3481.field_28989.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_EMERALD).method_35923(class_3481.field_29194.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_GOLD).method_35923(class_3481.field_23062.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_IRON).method_35923(class_3481.field_28988.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_LAPIS).method_35923(class_3481.field_28991.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_QUARTZ).method_46829((Object)class_2246.field_10213);
                tagger.apply(LibCommonTags.Blocks.ORES_REDSTONE).method_35923(class_3481.field_28990.comp_327());
                tagger.apply(LibCommonTags.Blocks.ORES_NETHERITE_SCRAP).method_46829((Object)class_2246.field_22109);
                tagger.apply(LibCommonTags.Blocks.STONE).method_46830((Object[])new class_2248[]{class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10277, class_2246.field_10340, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289, class_2246.field_28888, class_2246.field_28892, class_2246.field_29224, class_2246.field_27165});
                List<class_6862> storageTags = Arrays.asList(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST, LibCommonTags.Blocks.STORAGE_BLOCKS_COAL, LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER, LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND, LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD, LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD, LibCommonTags.Blocks.STORAGE_BLOCKS_IRON, LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS, LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON, LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE, LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE);
                for (class_6862 storageTag : storageTags) {
                    tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS).method_46828(storageTag);
                }
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST).method_46829((Object)class_2246.field_27159);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_COAL).method_46829((Object)class_2246.field_10381);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER).method_46829((Object)class_2246.field_27119);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND).method_46829((Object)class_2246.field_10201);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD).method_46829((Object)class_2246.field_10234);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD).method_46829((Object)class_2246.field_10205);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_IRON).method_46829((Object)class_2246.field_10085);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS).method_46829((Object)class_2246.field_10441);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ).method_46829((Object)class_2246.field_10153);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER).method_46829((Object)class_2246.field_33509);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD).method_46829((Object)class_2246.field_33510);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON).method_46829((Object)class_2246.field_33508);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE).method_46829((Object)class_2246.field_10002);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE).method_46829((Object)class_2246.field_22108);
                this.addColored(arg_0 -> tagger.apply(LibCommonTags.Blocks.STAINED_GLASS).method_46829(arg_0), LibCommonTags.Blocks.GLASS, "{color}_stained_glass", tagger);
                this.addColored(arg_0 -> tagger.apply(LibCommonTags.Blocks.STAINED_GLASS_PANES).method_46829(arg_0), LibCommonTags.Blocks.GLASS_PANES, "{color}_stained_glass_pane", tagger);
                tagger.apply(LibCommonTags.Blocks.GLASS).method_46828(LibCommonTags.Blocks.GLASS_COLORLESS).method_35923(LibCommonTags.Blocks.STAINED_GLASS.comp_327()).method_26792(LibCommonTags.Blocks.GLASS_TINTED);
                tagger.apply(LibCommonTags.Blocks.GLASS_COLORLESS).method_46829((Object)class_2246.field_10033);
                tagger.apply(LibCommonTags.Blocks.GLASS_TINTED).method_46829((Object)class_2246.field_27115);
                tagger.apply(LibCommonTags.Blocks.GLASS_PANES).method_46828(LibCommonTags.Blocks.GLASS_PANES_COLORLESS).method_35923(LibCommonTags.Blocks.STAINED_GLASS_PANES.comp_327());
                tagger.apply(LibCommonTags.Blocks.GLASS_PANES_COLORLESS).method_46829((Object)class_2246.field_10285);
            }
            DyeHelper.CONCRETE_BY_DYE.entrySet().stream().forEach(x -> ((class_7889.class_7890)tagger.apply(LibCommonTags.Blocks.CONCRETE)).method_46829((Object)((class_2248)x.getValue())));
            DyeHelper.CONCRETE_POWDER_BY_DYE.entrySet().stream().forEach(x -> ((class_7889.class_7890)tagger.apply(LibCommonTags.Blocks.CONCRETE_POWDER)).method_46829((Object)((class_2248)x.getValue())));
            DyeHelper.CARPET_BY_DYE.entrySet().stream().forEach(x -> ((class_7889.class_7890)tagger.apply(LibCommonTags.Blocks.CARPET)).method_46829((Object)((class_2248)x.getValue())));
        }

        private void addColored(Consumer<class_2248> consumer, class_6862<class_2248> group, String pattern, Function<class_6862<class_2248>, class_7889.class_7890<class_2248>> tagger) {
            String prefix = group.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + "_";
            for (class_1767 color : class_1767.values()) {
                class_2960 key = new class_2960("minecraft", pattern.replace("{color}", color.method_7792()));
                class_6862<class_2248> tag = this.getCommonTag(prefix + color.method_7792());
                class_2248 block = (class_2248)Services.PLATFORM.getRegistry(class_7924.field_41254).getValue(key).get();
                if (block == null || block == class_2246.field_10124) {
                    throw new IllegalStateException("Unknown block: " + key.toString());
                }
                tagger.apply(tag).method_46829((Object)block);
                consumer.accept(block);
            }
        }

        private class_6862<class_2248> getCommonTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862)LibCommonTags.Blocks.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }
    }
}

