/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.impl;

import com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler;
import com.grim3212.assorted.lib.core.inventory.locking.ILockable;
import com.grim3212.assorted.lib.core.inventory.locking.LockedStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public class LockedItemStackStorageHandler
extends ItemStackStorageHandler
implements LockedStorageHandler {
    private final ILockable lockable;

    public LockedItemStackStorageHandler(ILockable lockable, int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.lockable = lockable;
    }

    public LockedItemStackStorageHandler(ILockable lockable, class_2371<class_1799> stacks) {
        this.stacks = stacks;
        this.lockable = lockable;
    }

    private boolean codeMatches(String s) {
        return !this.lockable.isLocked() || this.lockable.getLockCode().equals(s);
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate, "", false);
    }

    @Override
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, String inLockCode, boolean ignoreLock) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack) || !this.codeMatches(inLockCode) && !ignoreLock) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!Services.INVENTORY.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.stacks.set(slot, (Object)(reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, "", false);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate, String inLockCode, boolean ignoreLock) {
        if (amount == 0 || !this.codeMatches(inLockCode) && !ignoreLock) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)class_1799.field_8037);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)Services.INVENTORY.copyStackWithSize(existing, existing.method_7947() - toExtract));
            this.onContentsChanged(slot);
        }
        return Services.INVENTORY.copyStackWithSize(existing, toExtract);
    }
}

