/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.impl;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.ITagSerializable;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class ItemStackStorageHandler
implements IItemStorageHandler,
ITagSerializable<class_2487> {
    protected class_2371<class_1799> stacks;

    public ItemStackStorageHandler() {
        this(1);
    }

    public ItemStackStorageHandler(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public ItemStackStorageHandler(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    @Override
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.stacks.get(slot);
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!Services.INVENTORY.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.setStackInSlot(slot, reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
                this.onContentsChanged(slot);
            }
        }
        return reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, class_1799.field_8037);
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            this.setStackInSlot(slot, Services.INVENTORY.copyStackWithSize(existing, existing.method_7947() - toExtract));
        }
        return Services.INVENTORY.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.stacks.get(i)).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.size());
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    @Override
    public void onContentsChanged(int slot) {
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty() || this.stacks.stream().allMatch(x -> x.method_7960());
    }

    public void setStacks(class_2371<class_1799> stacks) {
        if (stacks.size() < this.stacks.size()) {
            class_2371 newStacks = class_2371.method_10213((int)this.stacks.size(), (Object)class_1799.field_8037);
            for (int i = 0; i < stacks.size(); ++i) {
                if (i < stacks.size()) {
                    newStacks.set(i, (Object)((class_1799)stacks.get(i)));
                    continue;
                }
                newStacks.set(i, (Object)class_1799.field_8037);
            }
            this.stacks = newStacks;
        } else if (stacks.size() > this.stacks.size()) {
            LibConstants.LOG.warn("Can't try to set more stacks than slots");
        } else {
            this.stacks = stacks;
        }
    }

    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }
}

