/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.crafting.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.LibCommonTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class LibFluidIngredient {
    protected final class_6862<class_1792> itemTag;
    protected final class_6862<class_3611> fluidTag;
    protected final long amount;
    private List<class_1799> itemStacks;

    protected LibFluidIngredient(@Nullable class_6862<class_1792> itemTag, class_6862<class_3611> fluidTag) {
        this(itemTag, fluidTag, Services.FLUIDS.getBucketAmount());
    }

    public LibFluidIngredient(@Nullable class_6862<class_1792> itemTag, class_6862<class_3611> fluidTag, long amount) {
        this.itemTag = itemTag;
        this.fluidTag = fluidTag;
        this.amount = amount;
    }

    public class_6862<class_1792> getItemTag() {
        return this.itemTag;
    }

    public class_6862<class_3611> getFluidTag() {
        return this.fluidTag;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean test(class_1799 stack) {
        if (stack == null) {
            return false;
        }
        return (this.itemTag != null && stack.method_31573(this.itemTag) || this.itemTag == null) && this.doesInputMatchFluid(stack);
    }

    private boolean doesInputMatchFluid(class_1799 stack) {
        Optional<FluidInformation> fluidInformation = Services.FLUIDS.get(stack);
        if (fluidInformation.isPresent()) {
            long extracted = Services.FLUIDS.simulateExtract(stack, this.amount);
            return extracted == this.amount && fluidInformation.get().fluid().method_15791(this.fluidTag);
        }
        return false;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.itemStacks == null) {
            this.itemStacks = new ArrayList<class_1799>();
            ArrayList fluids = Lists.newArrayList();
            class_7923.field_41173.method_40286(this.fluidTag).forEach(f -> fluids.add((class_3611)f.comp_349()));
            ArrayList items = Lists.newArrayList();
            class_7923.field_41178.method_40286(LibCommonTags.Items.FLUID_CONTAINERS).forEach(i -> items.add((class_1792)i.comp_349()));
            for (class_3611 fluid : fluids) {
                for (class_1792 itm : items) {
                    class_1799 stack = new class_1799((class_1935)itm);
                    Services.FLUIDS.get(stack).ifPresent(itemFluid -> {
                        if (itemFluid.fluid().method_15780(fluid) && itemFluid.amount() >= Services.FLUIDS.getBucketAmount() && this.itemStacks.stream().noneMatch(i -> class_1799.method_7973((class_1799)i, (class_1799)stack))) {
                            this.itemStacks.add(stack);
                        }
                    });
                }
            }
        }
        return this.itemStacks;
    }

    public void invalidate() {
        this.itemStacks = null;
    }

    public static abstract class Serializer<T extends LibFluidIngredient> {
        public class_2960 getIdentifier() {
            return new class_2960("assortedlib", "stored_fluid_ingredient");
        }

        public T read(JsonObject json) {
            class_6862 itemTag = null;
            if (json.has("item")) {
                class_2960 itemLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"item"));
                itemTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)itemLocation);
            }
            class_2960 fluidLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid"));
            class_6862 fluidTag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)fluidLocation);
            long amount = Services.FLUIDS.getBucketAmount();
            if (json.has("amount")) {
                amount = class_3518.method_15260((JsonObject)json, (String)"amount");
            }
            if (fluidTag == null) {
                throw new JsonSyntaxException("Must set 'fluid'");
            }
            return this.create((class_6862<class_1792>)itemTag, (class_6862<class_3611>)fluidTag, amount);
        }

        public void write(JsonObject output, T ingredient) {
            if (((LibFluidIngredient)ingredient).itemTag != null) {
                output.addProperty("item", ((LibFluidIngredient)ingredient).itemTag.comp_327().toString());
            }
            output.addProperty("fluid", ((LibFluidIngredient)ingredient).fluidTag.comp_327().toString());
            if (((LibFluidIngredient)ingredient).amount > 0L) {
                output.addProperty("amount", (Number)((LibFluidIngredient)ingredient).amount);
            }
        }

        public T read(class_2540 buf) {
            boolean hasItemTag = buf.readBoolean();
            class_6862 itemTag = null;
            if (hasItemTag) {
                itemTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810());
            }
            class_6862 fluidTag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)buf.method_10810());
            long amount = buf.readLong();
            return this.create((class_6862<class_1792>)itemTag, (class_6862<class_3611>)fluidTag, amount);
        }

        public void write(class_2540 buf, T ingredient) {
            if (((LibFluidIngredient)ingredient).itemTag != null) {
                buf.writeBoolean(true);
                buf.method_10812(((LibFluidIngredient)ingredient).itemTag.comp_327());
            } else {
                buf.writeBoolean(false);
            }
            buf.method_10812(((LibFluidIngredient)ingredient).fluidTag.comp_327());
            buf.writeLong(((LibFluidIngredient)ingredient).amount);
        }

        protected abstract T create(@Nullable class_6862<class_1792> var1, class_6862<class_3611> var2, long var3);
    }
}

