/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.conditions;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.core.conditions.LibConditionProvider;
import com.grim3212.assorted.lib.platform.Services;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class ConditionalRecipeProvider
extends class_2446 {
    protected final Map<class_2960, List<LibConditionProvider>> conditions;
    protected final class_7784.class_7489 recipePathProvider;
    protected final class_7784.class_7489 advancementPathProvider;
    private final String modId;

    public ConditionalRecipeProvider(class_7784 output, String modId) {
        super(output);
        this.modId = modId;
        this.conditions = new HashMap<class_2960, List<LibConditionProvider>>();
        this.recipePathProvider = output.method_45973(class_7784.class_7490.field_39367, "recipes");
        this.advancementPathProvider = output.method_45973(class_7784.class_7490.field_39367, "advancements");
    }

    public LibConditionProvider and(LibConditionProvider ... providers) {
        return Services.CONDITIONS.and(providers);
    }

    public LibConditionProvider or(LibConditionProvider ... providers) {
        return Services.CONDITIONS.or(providers);
    }

    public LibConditionProvider not(LibConditionProvider provider) {
        return Services.CONDITIONS.not(provider);
    }

    public LibConditionProvider itemTagExists(class_6862<class_1792> itemTag) {
        return Services.CONDITIONS.itemTagExists(itemTag);
    }

    public LibConditionProvider modLoaded(String modId) {
        return Services.CONDITIONS.modLoaded(modId);
    }

    public LibConditionProvider partEnabled(String part) {
        return Services.CONDITIONS.partEnabled(part);
    }

    public class_1856 and(class_1856 ... ingredients) {
        return Services.INGREDIENTS.and(ingredients);
    }

    public class_1856 or(class_1856 ... ingredients) {
        return Services.INGREDIENTS.or(ingredients);
    }

    public class_1856 difference(class_1856 base, class_1856 subtracted) {
        return Services.INGREDIENTS.difference(base, subtracted);
    }

    public class_1856 nbt(class_1799 item) {
        return Services.INGREDIENTS.nbt(item);
    }

    public class_1856 fluid(@Nullable class_6862<class_1792> itemTagKey, class_6862<class_3611> fluidTagKey, long amount) {
        return Services.INGREDIENTS.fluid(itemTagKey, fluidTagKey, amount);
    }

    public class_1856 fluid(class_6862<class_3611> fluidTagKey) {
        return Services.INGREDIENTS.fluid(null, fluidTagKey, Services.FLUIDS.getBucketAmount());
    }

    protected String name(class_1792 i) {
        return this.id(i).method_12832();
    }

    protected String name(class_2248 b) {
        return this.id(b).method_12832();
    }

    protected class_2960 id(class_1792 i) {
        return Services.PLATFORM.getRegistry(class_7924.field_41197).getRegistryName(i);
    }

    protected class_2960 id(class_2248 b) {
        return Services.PLATFORM.getRegistry(class_7924.field_41254).getRegistryName(b);
    }

    protected class_2960 prefix(String name) {
        return new class_2960(this.modId, name);
    }

    public void addConditions(LibConditionProvider condition, class_2960 ... recipes) {
        if (recipes.length == 0) {
            return;
        }
        for (class_2960 recipe : recipes) {
            this.conditions.computeIfAbsent(recipe, r -> new ArrayList()).add(condition);
        }
    }

    public void writeConditions(class_2960 id, JsonObject json) {
        if (this.conditions.containsKey(id)) {
            Services.CONDITIONS.write(json, this.conditions.get(id).toArray(new LibConditionProvider[0]));
        }
    }

    public abstract void registerConditions();

    public void method_10419(Consumer<class_2444> recipeConsumer) {
        this.registerConditions();
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashSet recipes = Sets.newHashSet();
        ArrayList finishedRecipes = new ArrayList();
        this.method_10419(curRecipe -> {
            if (!recipes.add(curRecipe.method_10417())) {
                throw new IllegalStateException("Duplicate recipe " + curRecipe.method_10417());
            }
            JsonObject recipeJson = curRecipe.method_17799();
            this.writeConditions(curRecipe.method_10417(), recipeJson);
            finishedRecipes.add(class_2405.method_10320((class_7403)output, (JsonElement)recipeJson, (Path)this.recipePathProvider.method_44107(curRecipe.method_10417())));
            JsonObject advancementJson = curRecipe.method_10415();
            if (advancementJson != null) {
                this.writeConditions(curRecipe.method_10417(), advancementJson);
                finishedRecipes.add(class_2405.method_10320((class_7403)output, (JsonElement)advancementJson, (Path)this.advancementPathProvider.method_44107(curRecipe.method_10418())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])finishedRecipes.toArray(CompletableFuture[]::new));
    }
}

