/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.grim3212.assorted.lib.config.FabricConfigurationSource;
import com.grim3212.assorted.lib.config.FabricConfigurationSpec;
import com.grim3212.assorted.lib.config.FabricConfigurationValue;
import com.grim3212.assorted.lib.config.FabricVerifyableConfigurationValue;
import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class FabricConfigurationBuilder
implements IConfigurationBuilder {
    private static final Gson GSON = new GsonBuilder().create();
    private final FabricConfigurationSource source;
    private final Consumer<FabricConfigurationSpec> specConsumer;
    private final List<FabricConfigurationValue<?>> configuredValues = new ArrayList();

    public FabricConfigurationBuilder(FabricConfigurationSource source, Consumer<FabricConfigurationSpec> specConsumer) {
        this.source = source;
        this.specConsumer = specConsumer;
    }

    @Override
    public Supplier<Boolean> defineBoolean(String key, boolean defaultValue, String comment) {
        FabricConfigurationValue<Boolean> value = new FabricConfigurationValue<Boolean>(this.source, key, JsonElement::getAsBoolean, JsonPrimitive::new, defaultValue);
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String key, List<T> defaultValue, Class<T> containedType, String comment) {
        FabricConfigurationValue<List<? extends T>> value = new FabricConfigurationValue<List<? extends T>>(this.source, key, jsonElement -> {
            if (!jsonElement.isJsonArray()) {
                throw new JsonParseException("List: " + key + " is not an array");
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement element : jsonArray) {
                list.add(GSON.fromJson(element, containedType));
            }
            return list;
        }, arg_0 -> ((Gson)GSON).toJsonTree(arg_0), defaultValue);
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public Supplier<String> defineString(String key, String defaultValue, String comment) {
        FabricConfigurationValue<String> value = new FabricConfigurationValue<String>(this.source, key, JsonElement::getAsString, JsonPrimitive::new, defaultValue);
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public Supplier<Long> defineLong(String key, long defaultValue, long minValue, long maxValue, String comment) {
        FabricVerifyableConfigurationValue<Long> value = new FabricVerifyableConfigurationValue<Long>(this.source, key, JsonElement::getAsLong, JsonPrimitive::new, defaultValue, val -> Math.max(minValue, Math.min(maxValue, val)));
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public Supplier<Integer> defineInteger(String key, int defaultValue, int minValue, int maxValue, String comment) {
        FabricVerifyableConfigurationValue<Integer> value = new FabricVerifyableConfigurationValue<Integer>(this.source, key, JsonElement::getAsInt, JsonPrimitive::new, defaultValue, val -> Math.max(minValue, Math.min(maxValue, val)));
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public Supplier<Double> defineDouble(String key, double defaultValue, double minValue, double maxValue, String comment) {
        FabricVerifyableConfigurationValue<Double> value = new FabricVerifyableConfigurationValue<Double>(this.source, key, JsonElement::getAsDouble, JsonPrimitive::new, defaultValue, val -> Math.max(minValue, Math.min(maxValue, val)));
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public <T extends Enum<T>> Supplier<T> defineEnum(String key, T defaultValue, String comment) {
        FabricConfigurationValue<Enum> value = new FabricConfigurationValue<Enum>(this.source, key, jsonElement -> {
            if (!jsonElement.isJsonPrimitive()) {
                throw new JsonParseException("Enum: " + key + " is not a primitive");
            }
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (!primitive.isString() && !primitive.isNumber()) {
                throw new JsonParseException("Enum: " + key + " is not a string or number");
            }
            Enum[] values = (Enum[])defaultValue.getDeclaringClass().getEnumConstants();
            if (primitive.isString()) {
                String val = primitive.getAsString();
                if (Arrays.stream(values).noneMatch(v -> v.name().equals(val))) {
                    throw new JsonParseException("Enum: " + key + " is not a valid value");
                }
                return Enum.valueOf(defaultValue.getDeclaringClass(), val);
            }
            if (primitive.isNumber()) {
                int val = primitive.getAsInt();
                if (val < 0 || val >= values.length) {
                    throw new JsonParseException("Enum: " + key + " is not a valid value");
                }
                return values[val];
            }
            throw new IllegalStateException("Reached unreachable code");
        }, enumValue -> new JsonPrimitive(enumValue.name()), defaultValue);
        this.configuredValues.add(value);
        return value;
    }

    @Override
    public void setup() {
        FabricConfigurationSpec spec = new FabricConfigurationSpec(this.source, this.configuredValues);
        this.specConsumer.accept(spec);
    }
}

