/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.renderable;

import com.google.common.collect.ImmutableMap;
import com.grim3212.assorted.lib.client.model.renderable.IModelRenderable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CompositeModelRenderable
implements IModelRenderable<Transforms> {
    private final List<Component> components = new ArrayList<Component>();

    private CompositeModelRenderable() {
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferSource, IModelRenderable.ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick, Transforms context) {
        for (Component component : this.components) {
            component.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, context);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class Component {
        private final String name;
        private final List<Component> children = new ArrayList<Component>();
        private final List<Mesh> meshes = new ArrayList<Mesh>();

        public Component(String name) {
            this.name = name;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, IModelRenderable.ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, Transforms context) {
            Matrix4f matrix = context.getTransform(this.name);
            if (matrix != null) {
                poseStack.method_22903();
                poseStack.method_34425(matrix);
            }
            for (Component part : this.children) {
                part.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, context);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay);
            }
            if (matrix != null) {
                poseStack.method_22909();
            }
        }
    }

    public static class Transforms {
        public static final Transforms EMPTY = new Transforms((ImmutableMap<String, Matrix4f>)ImmutableMap.of());
        private final ImmutableMap<String, Matrix4f> parts;

        public static Transforms of(ImmutableMap<String, Matrix4f> parts) {
            return new Transforms(parts);
        }

        private Transforms(ImmutableMap<String, Matrix4f> parts) {
            this.parts = parts;
        }

        @Nullable
        public Matrix4f getTransform(String part) {
            return (Matrix4f)this.parts.get((Object)part);
        }
    }

    public static class Builder {
        private final CompositeModelRenderable renderable = new CompositeModelRenderable();

        private Builder() {
        }

        public PartBuilder<Builder> child(String name) {
            Component child = new Component(name);
            this.renderable.components.add(child);
            return new PartBuilder<Builder>(this, child);
        }

        public CompositeModelRenderable get() {
            return this.renderable;
        }
    }

    public static class PartBuilder<T> {
        private final T parent;
        private final Component component;

        private PartBuilder(T parent, Component component) {
            this.parent = parent;
            this.component = component;
        }

        public PartBuilder<PartBuilder<T>> child(String name) {
            Component child = new Component(this.component.name + "/" + name);
            this.component.children.add(child);
            return new PartBuilder<PartBuilder<T>>(this, child);
        }

        public PartBuilder<T> addMesh(class_2960 texture, List<class_777> quads) {
            Mesh mesh = new Mesh(texture);
            mesh.quads.addAll(quads);
            this.component.meshes.add(mesh);
            return this;
        }

        public T end() {
            return this.parent;
        }
    }

    private static class Mesh {
        private final class_2960 texture;
        private final List<class_777> quads = new ArrayList<class_777>();

        public Mesh(class_2960 texture) {
            this.texture = texture;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, IModelRenderable.ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay) {
            class_4588 consumer = bufferSource.getBuffer(textureRenderTypeLookup.get(this.texture));
            for (class_777 quad : this.quads) {
                consumer.method_22920(poseStack.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, new int[]{lightmap, lightmap, lightmap, lightmap}, overlay, true);
            }
        }
    }
}

