/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.loaders.context;

import com.google.common.collect.Maps;
import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import com.grim3212.assorted.lib.platform.ClientServices;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class SimpleModelBakingContext
implements IModelBakingContext {
    private final Map<String, class_4730> materials;
    private final boolean isGui3d;
    private final boolean useBlockLight;
    private final boolean useAmbientOcclusion;
    private final class_809 itemTransforms;
    private final class_806 itemOverrides;

    public SimpleModelBakingContext(Map<String, class_4730> materials, boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, class_809 itemTransforms, class_806 itemOverrides) {
        this.materials = materials;
        this.isGui3d = isGui3d;
        this.useBlockLight = useBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.itemTransforms = itemTransforms;
        this.itemOverrides = itemOverrides;
    }

    @Override
    public class_1100 getUnbakedModel(class_2960 unbakedModel) {
        return ClientServices.MODELS.getUnbakedModel(unbakedModel);
    }

    @Override
    public Optional<class_4730> getMaterial(String name) {
        return Optional.ofNullable(this.materials.get(name));
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.useBlockLight;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    @Override
    public class_809 getTransforms() {
        return this.itemTransforms;
    }

    @Override
    public class_806 getItemOverrides(class_7775 baker) {
        return this.itemOverrides;
    }

    public static final class SimpleModelBakingContextBuilder {
        private final Map<String, class_4730> materials = Maps.newHashMap();
        private boolean isGui3d = false;
        private boolean useBlockLight = false;
        private boolean useAmbientOcclusion = false;
        private class_809 itemTransforms = class_809.field_4301;
        private class_806 itemOverrides = class_806.field_4292;

        private SimpleModelBakingContextBuilder() {
        }

        public static SimpleModelBakingContextBuilder builder() {
            return new SimpleModelBakingContextBuilder();
        }

        public SimpleModelBakingContextBuilder withMaterial(String name, class_4730 material) {
            this.materials.put(name, material);
            return this;
        }

        public SimpleModelBakingContextBuilder withMaterials(Map<String, class_4730> materials) {
            this.materials.putAll(materials);
            return this;
        }

        public SimpleModelBakingContextBuilder withIsGui3d(boolean isGui3d) {
            this.isGui3d = isGui3d;
            return this;
        }

        public SimpleModelBakingContextBuilder withUseBlockLight(boolean useBlockLight) {
            this.useBlockLight = useBlockLight;
            return this;
        }

        public SimpleModelBakingContextBuilder withUseAmbientOcclusion(boolean useAmbientOcclusion) {
            this.useAmbientOcclusion = useAmbientOcclusion;
            return this;
        }

        public SimpleModelBakingContextBuilder withItemTransforms(class_809 itemTransforms) {
            this.itemTransforms = itemTransforms;
            return this;
        }

        public SimpleModelBakingContextBuilder withItemOverrides(class_806 itemOverrides) {
            this.itemOverrides = itemOverrides;
            return this;
        }

        public SimpleModelBakingContextBuilder but() {
            return SimpleModelBakingContextBuilder.builder().withMaterials(this.materials).withIsGui3d(this.isGui3d).withUseBlockLight(this.useBlockLight).withUseAmbientOcclusion(this.useAmbientOcclusion).withItemTransforms(this.itemTransforms).withItemOverrides(this.itemOverrides);
        }

        public SimpleModelBakingContext build() {
            return new SimpleModelBakingContext(this.materials, this.isGui3d, this.useBlockLight, this.useAmbientOcclusion, this.itemTransforms, this.itemOverrides);
        }
    }
}

