/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.client.model.loader.FabricExtendedBlockModelDeserializer;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecification;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecificationLoader;
import com.grim3212.assorted.lib.util.TransformationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.fabricmc.fabric.api.client.model.ModelResourceProvider;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public final class FabricPlatformModelLoaderPlatformDelegate<L extends IModelSpecificationLoader<S>, S extends IModelSpecification<S>>
implements ModelResourceProvider {
    private final Gson gson;
    private final String name;

    public FabricPlatformModelLoaderPlatformDelegate(class_2960 name, L delegate) {
        this.name = name.toString();
        this.gson = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeHierarchyAdapter(class_1100.class, (Object)new FabricExtendedBlockModelDeserializer(this.name, (IModelSpecificationLoader<?>)delegate)).registerTypeHierarchyAdapter(class_793.class, (Object)new FabricExtendedBlockModelDeserializer(this.name, (IModelSpecificationLoader<?>)delegate)).registerTypeAdapter(class_785.class, (Object)new class_785.class_786(){}).registerTypeAdapter(class_783.class, (Object)new class_783.class_784(){}).registerTypeAdapter(class_787.class, (Object)new class_787.class_788(){}).registerTypeAdapter(class_804.class, (Object)new class_804.class_805(){}).registerTypeAdapter(class_809.class, (Object)new class_809.class_810(){}).registerTypeAdapter(class_799.class, (Object)new class_799.class_800(){}).registerTypeAdapter(class_4590.class, (Object)new TransformationUtils.Deserializer()).create();
    }

    @Nullable
    public class_1100 loadModelResource(class_2960 resourceLocation, ModelProviderContext modelProviderContext) throws ModelProviderException {
        try {
            class_2960 target = new class_2960(resourceLocation.method_12836(), "models/" + resourceLocation.method_12832() + ".json");
            Optional resource = class_310.method_1551().method_1478().method_14486(target);
            if (resource.isEmpty()) {
                return null;
            }
            InputStream inputStream = ((class_3298)resource.get()).method_14482();
            InputStreamReader streamReader = new InputStreamReader(inputStream);
            JsonElement specificationData = (JsonElement)this.gson.fromJson((Reader)streamReader, JsonElement.class);
            streamReader.close();
            inputStream.close();
            if (!specificationData.isJsonObject()) {
                return null;
            }
            JsonObject modelSpecification = specificationData.getAsJsonObject();
            if (!modelSpecification.has("loader")) {
                if (modelSpecification.has("parent")) {
                    return this.getParentModel(new class_2960(class_3518.method_15253((JsonObject)modelSpecification, (String)"parent", (String)"")));
                }
                return null;
            }
            if (!modelSpecification.get("loader").getAsString().equals(this.name)) {
                return null;
            }
            return (class_1100)this.gson.fromJson((JsonElement)modelSpecification, class_1100.class);
        }
        catch (IOException e) {
            throw new ModelProviderException("Failed to find and read resource", (Throwable)e);
        }
    }

    @Nullable
    private class_1100 getParentModel(class_2960 parentLocation) throws IOException {
        class_2960 target = new class_2960(parentLocation.method_12836(), "models/" + parentLocation.method_12832() + ".json");
        Optional resource = class_310.method_1551().method_1478().method_14486(target);
        if (resource.isEmpty()) {
            return null;
        }
        InputStream inputStream = ((class_3298)resource.get()).method_14482();
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        JsonElement specificationData = (JsonElement)this.gson.fromJson((Reader)streamReader, JsonElement.class);
        streamReader.close();
        inputStream.close();
        if (!specificationData.isJsonObject()) {
            return null;
        }
        JsonObject modelSpecification = specificationData.getAsJsonObject();
        if (!modelSpecification.has("loader")) {
            return null;
        }
        if (!modelSpecification.get("loader").getAsString().equals(this.name)) {
            return null;
        }
        return (class_1100)this.gson.fromJson((JsonElement)modelSpecification, class_1100.class);
    }
}

