/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model;

import com.grim3212.assorted.lib.client.model.EmptyModel;
import com.grim3212.assorted.lib.client.model.RenderTypeGroup;
import com.grim3212.assorted.lib.client.model.baked.simple.WrappedSimpleBakedModel;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

public interface IModelBuilder<T extends IModelBuilder<T>> {
    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides, particle, renderTypes);
    }

    public static IModelBuilder<?> collecting(List<class_777> quads) {
        return new Collecting(quads);
    }

    public T addCulledFace(class_2350 var1, class_777 var2);

    public T addUnculledFace(class_777 var1);

    public class_1087 build();

    public static class Simple
    implements IModelBuilder<Simple> {
        private final WrappedSimpleBakedModel.Builder builder;
        private final RenderTypeGroup renderTypes;

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes) {
            this.builder = new WrappedSimpleBakedModel.Builder(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides).particle(particle);
            this.renderTypes = renderTypes;
        }

        @Override
        public Simple addCulledFace(class_2350 facing, class_777 quad) {
            this.builder.addCulledFace(facing, quad);
            return this;
        }

        @Override
        public Simple addUnculledFace(class_777 quad) {
            this.builder.addUnculledFace(quad);
            return this;
        }

        @Override
        @Deprecated
        public class_1087 build() {
            return this.builder.build(this.renderTypes);
        }
    }

    public static class Collecting
    implements IModelBuilder<Collecting> {
        private final List<class_777> quads;

        private Collecting(List<class_777> quads) {
            this.quads = quads;
        }

        @Override
        public Collecting addCulledFace(class_2350 facing, class_777 quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public Collecting addUnculledFace(class_777 quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public class_1087 build() {
            return EmptyModel.BAKED;
        }
    }
}

