/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.grim3212.assorted.lib.client.model.IModelBuilder;
import com.grim3212.assorted.lib.client.model.RenderTypeGroup;
import com.grim3212.assorted.lib.client.model.baked.IDataAwareBakedModel;
import com.grim3212.assorted.lib.client.model.baked.IDelegatingBakedModel;
import com.grim3212.assorted.lib.client.model.data.IBlockModelData;
import com.grim3212.assorted.lib.client.model.data.IModelDataKey;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecification;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecificationLoader;
import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import com.grim3212.assorted.lib.platform.ClientServices;
import com.grim3212.assorted.lib.util.ConcatenatedListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombiningModel
implements IModelSpecification<CombiningModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<String, class_793> children;
    private final boolean logWarning;

    public CombiningModel(ImmutableMap<String, class_793> children) {
        this(children, false);
    }

    private CombiningModel(ImmutableMap<String, class_793> children, boolean logWarning) {
        this.children = children;
        this.logWarning = logWarning;
    }

    @Override
    public class_1087 bake(IModelBakingContext context, class_7775 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"parts\" field in its composite model instead of \"children\". This field will be removed in 1.20.");
        }
        class_4730 particleLocation = context.getMaterial("particle").orElse(null);
        class_1058 particle = spriteGetter.apply(particleLocation);
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            class_793 model = (class_793)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.method_3446(bakery, model, spriteGetter, modelTransform, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), context.getItemOverrides(bakery), (ImmutableMap<String, class_1087>)bakedParts);
    }

    public static class Baked
    implements IDataAwareBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_809 transforms;
        private final ImmutableMap<String, class_1087> children;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, class_1058 particle, class_809 transforms, class_806 overrides, ImmutableMap<String, class_1087> children) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
        }

        @NotNull
        private static Collection<class_1921> getRenderTypes(class_1087 model, class_2680 state, class_5819 rand, IBlockModelData data) {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getSupportedRenderTypes(state, rand, data);
            }
            if (model instanceof IDelegatingBakedModel) {
                IDelegatingBakedModel delegatingBakedModel = (IDelegatingBakedModel)model;
                return Baked.getRenderTypes(delegatingBakedModel.getDelegate(), state, rand, data);
            }
            return ClientServices.MODELS.getRenderTypesFor(model, state, rand, data);
        }

        @NotNull
        private static Collection<class_1921> getRenderTypes(class_1087 model, class_1799 stack, Boolean fabulous) {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getSupportedRenderTypes(stack, fabulous);
            }
            if (model instanceof IDelegatingBakedModel) {
                IDelegatingBakedModel delegatingBakedModel = (IDelegatingBakedModel)model;
                return Baked.getRenderTypes(delegatingBakedModel.getDelegate(), stack, fabulous);
            }
            return ClientServices.MODELS.getRenderTypesFor(model, stack, fabulous);
        }

        public static Builder builder(IModelBakingContext owner, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return Baked.builder(owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), particle, overrides, cameraTransforms);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, overrides, cameraTransforms);
        }

        @Override
        @NotNull
        public List<class_777> getQuads(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand, @NotNull IBlockModelData extraData, @Nullable class_1921 renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (state == null || !Baked.getRenderTypes((class_1087)entry.getValue(), state, rand, extraData).contains(renderType))) continue;
                Object v = entry.getValue();
                if (v instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                    quadLists.add(dataAwareBakedModel.getQuads(state, side, rand, Data.resolve(extraData, (String)entry.getKey()), renderType));
                    continue;
                }
                quadLists.add(((class_1087)entry.getValue()).method_4707(state, side, rand));
            }
            return ConcatenatedListView.of(quadLists);
        }

        @Override
        @NotNull
        public List<class_777> getQuads(class_1799 stack, boolean fabulous, @NotNull class_5819 rand, @Nullable class_1921 renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (stack == null || !Baked.getRenderTypes((class_1087)entry.getValue(), stack, fabulous).contains(renderType))) continue;
                Object v = entry.getValue();
                if (v instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                    quadLists.add(dataAwareBakedModel.getQuads(stack, fabulous, rand, renderType));
                    continue;
                }
                quadLists.add(((class_1087)entry.getValue()).method_4707(null, null, rand));
            }
            return ConcatenatedListView.of(quadLists);
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return false;
        }

        @NotNull
        public class_1058 method_4711() {
            return this.particle;
        }

        @NotNull
        public class_806 method_4710() {
            return this.overrides;
        }

        @NotNull
        public class_809 method_4709() {
            return this.transforms;
        }

        @Override
        @NotNull
        public Collection<class_1921> getSupportedRenderTypes(class_2680 state, class_5819 rand, IBlockModelData data) {
            ArrayList<Collection<class_1921>> sets = new ArrayList<Collection<class_1921>>();
            for (Map.Entry entry : this.children.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IDataAwareBakedModel)) continue;
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                sets.add(dataAwareBakedModel.getSupportedRenderTypes(state, rand, Data.resolve(data, (String)entry.getKey())));
            }
            return sets.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public Collection<class_1921> getSupportedRenderTypes(class_1799 stack, boolean fabulous) {
            ArrayList<Collection<class_1921>> sets = new ArrayList<Collection<class_1921>>();
            for (Map.Entry entry : this.children.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IDataAwareBakedModel)) continue;
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                sets.add(dataAwareBakedModel.getSupportedRenderTypes(stack, fabulous));
            }
            return sets.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @NotNull
        public List<class_777> method_4707(@Nullable class_2680 pState, @Nullable class_2350 pDirection, @NotNull class_5819 pRandom) {
            return this.getQuads(pState, pDirection, pRandom, IBlockModelData.empty(), null);
        }

        @Nullable
        public class_1087 getPart(String name) {
            return (class_1087)this.children.get((Object)name);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final List<class_1087> children = new ArrayList<class_1087>();
            private final List<class_777> quads = new ArrayList<class_777>();
            private final class_806 overrides;
            private final class_809 transforms;
            private class_1058 particle;
            private RenderTypeGroup lastRenderTypes = RenderTypeGroup.EMPTY;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
            }

            public void addLayer(class_1087 model) {
                this.flushQuads(null);
                this.children.add(model);
            }

            private void addLayer(RenderTypeGroup renderTypes, List<class_777> quads) {
                IModelBuilder<?> modelBuilder = IModelBuilder.of(this.isAmbientOcclusion, this.isSideLit, this.isGui3d, this.transforms, this.overrides, this.particle, renderTypes);
                quads.forEach(modelBuilder::addUnculledFace);
                this.children.add(modelBuilder.build());
            }

            private void flushQuads(RenderTypeGroup renderTypes) {
                if (!Objects.equals(renderTypes, this.lastRenderTypes)) {
                    if (this.quads.size() > 0) {
                        this.addLayer(this.lastRenderTypes, this.quads);
                        this.quads.clear();
                    }
                    this.lastRenderTypes = renderTypes;
                }
            }

            public Builder setParticle(class_1058 particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, class_777 ... quadsToAdd) {
                this.flushQuads(renderTypes);
                Collections.addAll(this.quads, quadsToAdd);
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, Collection<class_777> quadsToAdd) {
                this.flushQuads(renderTypes);
                this.quads.addAll(quadsToAdd);
                return this;
            }

            public class_1087 build() {
                if (this.quads.size() > 0) {
                    this.addLayer(this.lastRenderTypes, this.quads);
                }
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                int i = 0;
                for (class_1087 model : this.children) {
                    childrenBuilder.put((Object)("model_" + i++), (Object)model);
                }
                return new Baked(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, class_1087>)childrenBuilder.build());
            }
        }
    }

    public static final class Loader
    implements IModelSpecificationLoader<CombiningModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public CombiningModel read(JsonDeserializationContext deserializationContext, JsonObject jsonObject) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, class_793>)childrenBuilder, false);
            boolean logWarning = this.readChildren(jsonObject, "parts", deserializationContext, (ImmutableMap.Builder<String, class_793>)childrenBuilder, true);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            return new CombiningModel((ImmutableMap<String, class_793>)children, logWarning);
        }

        private boolean readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, class_793> children, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((class_793)deserializationContext.deserialize((JsonElement)entry.getValue(), class_793.class)));
            }
            return logWarning;
        }
    }

    public static class Data {
        public static final IModelDataKey<Data> PROPERTY = IModelDataKey.create();
        private final Map<String, IBlockModelData> partData;

        private Data(Map<String, IBlockModelData> partData) {
            this.partData = partData;
        }

        public static IBlockModelData resolve(IBlockModelData modelData, String name) {
            Data compositeData = modelData.getData(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            IBlockModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Nullable
        public IBlockModelData get(String name) {
            return this.partData.get(name);
        }

        public static final class Builder {
            private final Map<String, IBlockModelData> partData = new IdentityHashMap<String, IBlockModelData>();

            public Builder with(String name, IBlockModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

