/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.amethyst_core.compat.spell_power;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.amethyst_core.compat.spell_power.SpChecker;
import me.fzzyhmstrs.amethyst_core.compat.spell_power.SpCompat;
import me.fzzyhmstrs.amethyst_core.registry.RegisterAttribute;
import me.fzzyhmstrs.amethyst_core.scepter_util.augments.ScepterAugment;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import net.spell_power.api.SpellPowerMechanics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b \u0010!J5\u0010&\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u001e\u0010%\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020$0#0\"\"\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0004\b&\u0010'J1\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006\u00a2\u0006\u0004\b,\u0010-J1\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006\u00a2\u0006\u0004\b.\u0010-J9\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b/\u00100R\u001b\u00106\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u00068"}, d2={"Lme/fzzyhmstrs/amethyst_core/compat/spell_power/SpChecker;", "", "<init>", "()V", "Lme/fzzyhmstrs/amethyst_core/compat/spell_power/SpChecker$Power;", "power", "", "uuid", "", "amount", "Lnet/minecraft/class_1322$class_1323;", "operation", "Lcom/google/common/collect/Multimap;", "Lnet/minecraft/class_1320;", "Lnet/minecraft/class_1322;", "map", "", "addSpellPowerAttribute", "(Lme/fzzyhmstrs/amethyst_core/compat/spell_power/SpChecker$Power;Ljava/lang/String;DLnet/minecraft/class_1322$class_1323;Lcom/google/common/collect/Multimap;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1309;", "user", "Lnet/minecraft/class_1799;", "stack", "Lme/fzzyhmstrs/amethyst_core/scepter_util/augments/ScepterAugment;", "spell", "fireOnSpellPowerCast", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;Lnet/minecraft/class_1799;Lme/fzzyhmstrs/amethyst_core/scepter_util/augments/ScepterAugment;)V", "getHaste", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1799;)D", "Lkotlin/Pair;", "getModFromSpell", "(Lnet/minecraft/class_1309;Lme/fzzyhmstrs/amethyst_core/scepter_util/augments/ScepterAugment;)Lkotlin/Pair;", "", "Lnet/minecraft/class_6862;", "Lnet/minecraft/class_1887;", "tagKeys", "getModFromTags", "(Lnet/minecraft/class_1309;[Lnet/minecraft/class_6862;)D", "", "percent", "Ljava/util/UUID;", "name", "getSpellCooldownModifier", "(ILjava/util/UUID;Ljava/lang/String;)Lkotlin/Pair;", "getSpellCritChanceModifier", "getSpellCritDamageModifier", "(ILjava/util/UUID;Ljava/lang/String;Lnet/minecraft/class_1322$class_1323;)Lkotlin/Pair;", "", "spellPowerLoaded$delegate", "Lkotlin/Lazy;", "getSpellPowerLoaded", "()Z", "spellPowerLoaded", "Power", "amethyst_core"})
public final class SpChecker {
    @NotNull
    public static final SpChecker INSTANCE = new SpChecker();
    @NotNull
    private static final Lazy spellPowerLoaded$delegate = LazyKt.lazy((Function0)spellPowerLoaded.2.INSTANCE);

    private SpChecker() {
    }

    public final boolean getSpellPowerLoaded() {
        Lazy lazy = spellPowerLoaded$delegate;
        return (Boolean)lazy.getValue();
    }

    public final void fireOnSpellPowerCast(@NotNull class_1937 world, @NotNull class_1309 user, @NotNull class_1799 stack, @NotNull ScepterAugment spell) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)spell), (String)"spell");
        if (this.getSpellPowerLoaded()) {
            SpCompat.INSTANCE.fireOnSpellPowerCast(world, user, stack, spell);
        }
    }

    public final double getHaste(@NotNull class_1309 user, @NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.getSpellPowerLoaded()) {
            return SpCompat.INSTANCE.getHaste(user, stack);
        }
        return 1.0;
    }

    @NotNull
    public final Pair<Double, Double> getModFromSpell(@NotNull class_1309 user, @NotNull ScepterAugment spell) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)spell), (String)"spell");
        if (this.getSpellPowerLoaded()) {
            return SpCompat.INSTANCE.getModFromSpell(user, spell);
        }
        return new Pair((Object)1.0, (Object)0.0);
    }

    public final double getModFromTags(@NotNull class_1309 user, class_6862<class_1887> ... tagKeys) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(tagKeys, (String)"tagKeys");
        if (this.getSpellPowerLoaded()) {
            return SpCompat.INSTANCE.getModFromTags(user, Arrays.copyOf(tagKeys, tagKeys.length));
        }
        return 0.0;
    }

    public final void addSpellPowerAttribute(@NotNull Power power, @NotNull String uuid, double amount, @NotNull class_1322.class_1323 operation, @NotNull Multimap<class_1320, class_1322> map) {
        Intrinsics.checkNotNullParameter((Object)((Object)power), (String)"power");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (this.getSpellPowerLoaded()) {
            class_1320 class_13202 = SpCompat.INSTANCE.getAttributeFromEnum(power);
            if (class_13202 == null) {
                return;
            }
            class_1320 attribute = class_13202;
            UUID uUID = UUID.fromString(uuid);
            map.put((Object)attribute, (Object)new class_1322(uUID, power.getId(), amount, operation));
        }
    }

    @NotNull
    public final Pair<class_1320, class_1322> getSpellCooldownModifier(int percent, @NotNull UUID uuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (percent > 99 || percent < -1000) {
            throw new IllegalStateException("Percentage " + percent + " out of bounds for creating a spell cooldown multiplier");
        }
        if (this.getSpellPowerLoaded()) {
            double multiplier = class_3532.method_16436((double)(percent < 0 ? 0.0 : (double)percent / 99.0), (double)0.0, (double)9.0);
            return new Pair((Object)SpellPowerMechanics.HASTE.attribute, (Object)new class_1322(uuid, name, multiplier, class_1322.class_1323.field_6331));
        }
        return new Pair((Object)RegisterAttribute.INSTANCE.getSPELL_COOLDOWN(), (Object)new class_1322(uuid, name, (double)percent / 100.0, class_1322.class_1323.field_6331));
    }

    @NotNull
    public final Pair<class_1320, class_1322> getSpellCritChanceModifier(int percent, @NotNull UUID uuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (percent > 100 || percent < 0) {
            throw new IllegalStateException("Percentage " + percent + " out of bounds for creating a spell crit chance");
        }
        if (this.getSpellPowerLoaded()) {
            return new Pair((Object)SpellPowerMechanics.CRITICAL_CHANCE.attribute, (Object)new class_1322(uuid, name, (double)percent, class_1322.class_1323.field_6328));
        }
        return new Pair((Object)RegisterAttribute.INSTANCE.getSPELL_CRITICAL_CHANCE(), (Object)new class_1322(uuid, name, (double)percent / 100.0, class_1322.class_1323.field_6328));
    }

    @NotNull
    public final Pair<class_1320, class_1322> getSpellCritDamageModifier(int percent, @NotNull UUID uuid, @NotNull String name, @NotNull class_1322.class_1323 operation) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                if (percent > 1000) break block6;
                boolean bl = operation == class_1322.class_1323.field_6328 ? percent < 0 : percent < 100;
                if (!bl) break block7;
            }
            throw new IllegalStateException("Percentage " + percent + " out of bounds for creating a spell crit damage multiplier");
        }
        if (operation != class_1322.class_1323.field_6328) {
            double multiplier = (double)(percent - 100) / 100.0;
            if (this.getSpellPowerLoaded()) {
                return new Pair((Object)SpellPowerMechanics.CRITICAL_DAMAGE.attribute, (Object)new class_1322(uuid, name, multiplier, operation));
            }
            return new Pair((Object)RegisterAttribute.INSTANCE.getSPELL_CRITICAL_MULTIPLIER(), (Object)new class_1322(uuid, name, multiplier, operation));
        }
        if (this.getSpellPowerLoaded()) {
            return new Pair((Object)SpellPowerMechanics.CRITICAL_DAMAGE.attribute, (Object)new class_1322(uuid, name, (double)percent, class_1322.class_1323.field_6328));
        }
        return new Pair((Object)RegisterAttribute.INSTANCE.getSPELL_CRITICAL_MULTIPLIER(), (Object)new class_1322(uuid, name, (double)percent / 100.0, class_1322.class_1323.field_6328));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lme/fzzyhmstrs/amethyst_core/compat/spell_power/SpChecker$Power;", "", "", "id", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "CRITICAL_CHANCE", "CRITICAL_DAMAGE", "HASTE", "ARCANE", "FIRE", "FROST", "HEALING", "LIGHTNING", "SOUL", "amethyst_core"})
    public static final class Power
    extends Enum<Power> {
        @NotNull
        private final String id;
        public static final /* enum */ Power CRITICAL_CHANCE = new Power("ac_crit_chance");
        public static final /* enum */ Power CRITICAL_DAMAGE = new Power("ac_crit_damage");
        public static final /* enum */ Power HASTE = new Power("ac_haste");
        public static final /* enum */ Power ARCANE = new Power("ac_arcane");
        public static final /* enum */ Power FIRE = new Power("ac_fire");
        public static final /* enum */ Power FROST = new Power("ac_frost");
        public static final /* enum */ Power HEALING = new Power("ac_healing");
        public static final /* enum */ Power LIGHTNING = new Power("ac_lightning");
        public static final /* enum */ Power SOUL = new Power("ac_soul");
        private static final /* synthetic */ Power[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Power(String id2) {
            this.id = id2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public static Power[] values() {
            return (Power[])$VALUES.clone();
        }

        public static Power valueOf(String value) {
            return Enum.valueOf(Power.class, value);
        }

        @NotNull
        public static EnumEntries<Power> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = powerArray = new Power[]{Power.CRITICAL_CHANCE, Power.CRITICAL_DAMAGE, Power.HASTE, Power.ARCANE, Power.FIRE, Power.FROST, Power.HEALING, Power.LIGHTNING, Power.SOUL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

