/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.AetherBookCategory;
import com.aetherteam.aether.recipe.recipes.item.AbstractAetherCookingRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AetherCookingSerializer<T extends AbstractAetherCookingRecipe>
implements class_1865<T> {
    private final int defaultCookingTime;
    private final CookieBaker<T> factory;

    public AetherCookingSerializer(CookieBaker<T> factory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = factory;
    }

    public T fromJson(class_2960 id, JsonObject json) {
        class_1799 result;
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        AetherBookCategory aetherBookCategory = (AetherBookCategory)AetherBookCategory.CODEC.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)AetherBookCategory.UNKNOWN);
        JsonArray ingredientJson = class_3518.method_15264((JsonObject)json, (String)"ingredient") ? class_3518.method_15261((JsonObject)json, (String)"ingredient") : class_3518.method_15296((JsonObject)json, (String)"ingredient");
        class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
        } else {
            String resultString = class_3518.method_15265((JsonObject)json, (String)"result");
            class_2960 resultLocation = new class_2960(resultString);
            result = new class_1799((class_1935)class_7923.field_41178.method_10223(resultLocation));
            if (result.method_7960()) {
                throw new IllegalStateException("Item: " + resultString + " does not exist");
            }
        }
        float experience = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
        int cookingTime = class_3518.method_15282((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(id, group, aetherBookCategory, ingredient, result, experience, cookingTime);
    }

    @Nullable
    public T fromNetwork(class_2960 id, class_2540 buffer) {
        String group = buffer.method_19772();
        AetherBookCategory aetherBookCategory = (AetherBookCategory)buffer.method_10818(AetherBookCategory.class);
        class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
        class_1799 result = buffer.method_10819();
        float experience = buffer.readFloat();
        int cookingTime = buffer.method_10816();
        return this.factory.create(id, group, aetherBookCategory, ingredient, result, experience, cookingTime);
    }

    public void toNetwork(class_2540 buffer, T recipe) {
        buffer.method_10814(recipe.method_8112());
        buffer.method_10817((Enum)Objects.requireNonNullElse(((AbstractAetherCookingRecipe)((Object)recipe)).aetherCategory(), AetherBookCategory.UNKNOWN));
        ((class_1856)recipe.method_8117().get(0)).method_8088(buffer);
        buffer.method_10793(((AbstractAetherCookingRecipe)((Object)recipe)).getResult());
        buffer.writeFloat(recipe.method_8171());
        buffer.method_10804(recipe.method_8167());
    }

    public static interface CookieBaker<T extends AbstractAetherCookingRecipe> {
        public T create(class_2960 var1, String var2, AetherBookCategory var3, class_1856 var4, class_1799 var5, float var6, int var7);
    }
}

