/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.modifiers;

import com.aetherteam.aether.utils.FabricUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5819;

public class GlovesLootModifier
extends LootModifier {
    public static final Codec<GlovesLootModifier> CODEC = RecordCodecBuilder.create(instance -> GlovesLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)class_1799.field_24671.fieldOf("gloves").forGetter(modifier -> modifier.glovesStack)).and((App)class_1740.field_41941.fieldOf("armor_material").forGetter(modifier -> modifier.armorMaterial)).apply((Applicative)instance, GlovesLootModifier::new));
    public final class_1799 glovesStack;
    public final class_1740 armorMaterial;

    public GlovesLootModifier(class_5341[] conditionsIn, class_1799 glovesStack, class_1740 armorMaterial) {
        super(conditionsIn);
        this.glovesStack = glovesStack;
        this.armorMaterial = armorMaterial;
    }

    protected ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> lootStacks, class_47 context) {
        class_5819 randomSource = context.method_294();
        class_243 vec3 = (class_243)context.method_296(class_181.field_24424);
        if (vec3 != null) {
            class_2338 pos = class_2338.method_49638((class_2374)vec3);
            class_2586 blockEntity = context.method_299().method_8321(pos);
            if (blockEntity instanceof class_2624) {
                List<class_1799> armorItems = lootStacks.stream().filter(itemStack -> {
                    class_1738 armorItem;
                    class_1792 patt3176$temp = itemStack.method_7909();
                    return patt3176$temp instanceof class_1738 && (armorItem = (class_1738)patt3176$temp).method_7686().equals(this.armorMaterial);
                }).toList();
                for (class_1799 armorStack : armorItems) {
                    if (randomSource.method_43048(4) >= 1) continue;
                    class_1799 gloves = this.glovesStack.method_7972();
                    int cost = 0;
                    boolean isTreasure = false;
                    for (Map.Entry<class_1887, Integer> enchantmentInfo : FabricUtils.getAllEnchantments(armorStack).entrySet()) {
                        class_1887 enchantment = enchantmentInfo.getKey();
                        int level = enchantmentInfo.getValue();
                        cost = Math.max(cost, enchantment.method_8182(level));
                        if (!isTreasure) {
                            isTreasure = enchantment.method_8193();
                        }
                        if (!FabricUtils.canApplyAtEnchantingTable(gloves, enchantment)) continue;
                        gloves.method_7978(enchantment, enchantmentInfo.getValue().intValue());
                    }
                    if (!FabricUtils.getAllEnchantments(armorStack).isEmpty() && FabricUtils.getAllEnchantments(gloves).isEmpty()) {
                        class_1890.method_8233((class_5819)randomSource, (class_1799)gloves, (int)cost, (boolean)isTreasure);
                    }
                    if (!FabricUtils.getAllEnchantments(armorStack).isEmpty() && FabricUtils.getAllEnchantments(gloves).isEmpty()) continue;
                    lootStacks.replaceAll(stack -> stack.equals(armorStack) ? gloves : stack);
                }
            }
        }
        return lootStacks;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

