/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.nitrogen.data.providers.NitrogenLanguageProvider;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class AetherLanguageProvider
extends NitrogenLanguageProvider {
    private final Map<String, String> PRO_TIPS = new HashMap<String, String>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_7784 output;

    public AetherLanguageProvider(class_7784 output, String id) {
        super(output, id);
        this.output = output;
    }

    public void addAccessoriesIdentifier(String key, String name) {
        this.add("accessories.slot." + key, name);
    }

    public void addMoaSkinsText(String key, String name) {
        this.addGuiText("moa_skins." + key, name);
    }

    public void addCustomizationText(String key, String name) {
        this.addGuiText("customization." + key, name);
    }

    public void addLoreBookText(String key, String name) {
        this.addGuiText("book_of_lore." + key, name);
    }

    public void addLore(Supplier<? extends class_1935> key, String name) {
        this.add("lore." + key.get().method_8389().method_7876(), name);
    }

    public void addLoreUnique(String key, String name) {
        this.add("lore." + key, name);
    }

    public void addProTip(String key, String name) {
        String fullKey = "aether.pro_tips.line." + this.id + "." + key;
        this.add(fullKey, name);
        this.PRO_TIPS.put(fullKey, key);
    }

    public void addMenuTitle(String key, String name) {
        this.add(this.id + ".menu_title." + key, name);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        CompletableFuture languageGen = super.method_10319(cache);
        return languageGen;
    }

    private CompletableFuture<?> generateProTips(CompletableFuture<?> languageGen, class_7403 cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        futuresBuilder.add(languageGen);
        for (Map.Entry<String, String> entry : this.PRO_TIPS.entrySet()) {
            JsonObject object = new JsonObject();
            object.add("title", class_2561.class_2562.method_10868((class_2561)class_2561.method_43471((String)"tipsmod.title.default").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1054})));
            object.add("tip", class_2561.class_2562.method_10868((class_2561)class_2561.method_43471((String)entry.getKey())));
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)GSON.toJsonTree((Object)object), (Path)this.output.method_45971().resolve("packs/tips/assets/aether/tips/" + entry.getValue() + ".json")));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }
}

