/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils.waypoints;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.FileUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;

public class WaypointJsonUtils {
    private static final String path = FabricLoader.getInstance().getConfigDir() + "/AdvancedCompass/";

    public static Collection<Waypoint> getWaypoints(String dir) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        File file = new File(path + "/waypoints/" + dir + "/waypoints.json");
        if (!file.exists()) {
            return waypoints;
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement obj = jsonParser.parse((Reader)reader);
            if (obj.isJsonObject()) {
                JsonObject list = obj.getAsJsonObject();
                for (Map.Entry entry : list.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonObject()) continue;
                        JsonObject object = element.getAsJsonObject();
                        String dimension = (String)entry.getKey();
                        String name = object.get("name").getAsString();
                        class_243 position = new class_243(object.get("x").getAsDouble(), object.get("y").getAsDouble(), object.get("z").getAsDouble());
                        Color color = new Color(object.get("color").getAsInt());
                        WaypointIcon icon = WaypointIcon.valueOf(object.get("icon").getAsString());
                        int minDistance = object.get("min-distance").getAsInt();
                        int maxDistance = object.get("max-distance").getAsInt();
                        boolean enabled = object.get("enabled").getAsBoolean();
                        waypoints.add(new Waypoint(name, position, dimension, icon, color, minDistance, maxDistance, enabled));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return waypoints;
    }

    private static boolean isEmpty(String name) {
        return name.trim().length() == 0;
    }

    private static File getFileSafe(String path) {
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    private static int getMatchInArray(JsonArray array, String name) {
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).isJsonObject() || !array.get(i).getAsJsonObject().get("name").getAsString().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static JsonObject generateJson(Waypoint waypoint) {
        JsonObject jsonWaypoint = new JsonObject();
        jsonWaypoint.addProperty("name", waypoint.name);
        jsonWaypoint.addProperty("x", (Number)((int)waypoint.position.field_1352));
        jsonWaypoint.addProperty("y", (Number)((int)waypoint.position.field_1351));
        jsonWaypoint.addProperty("z", (Number)((int)waypoint.position.field_1350));
        jsonWaypoint.addProperty("color", (Number)waypoint.color.getIntColor());
        jsonWaypoint.addProperty("icon", waypoint.icon.name());
        jsonWaypoint.addProperty("max-distance", (Number)waypoint.maxDistance);
        jsonWaypoint.addProperty("min-distance", (Number)waypoint.minDistance);
        jsonWaypoint.addProperty("enabled", Boolean.valueOf(waypoint.enabled));
        return jsonWaypoint;
    }

    public static void deleteWaypoint(String dir, Waypoint waypoint) {
        File file = WaypointJsonUtils.getFileSafe(path + "/waypoints/" + dir + "/waypoints.json");
        JsonObject list = !file.exists() ? new JsonObject() : WaypointJsonUtils.getJson(file);
        JsonArray array = WaypointJsonUtils.getJsonArray(list, waypoint.dimension);
        int index = WaypointJsonUtils.getMatchInArray(array, waypoint.getName());
        if (index >= 0) {
            array.remove(index);
        }
        list.add(waypoint.dimension, (JsonElement)array);
        FileUtils.saveFile(file, list.toString());
    }

    public static Object[] changeWaypoint(String dir, String oldName, Waypoint waypoint, boolean force) {
        int newIndex;
        Object[] result = new Object[3];
        result[0] = false;
        if (WaypointJsonUtils.isEmpty(waypoint.getName())) {
            result[1] = Translation.WAYPOINT_EMPTY_NAME.getString();
            result[2] = "";
            return result;
        }
        File file = WaypointJsonUtils.getFileSafe(path + "/waypoints/" + dir + "/waypoints.json");
        JsonObject list = !file.exists() ? new JsonObject() : WaypointJsonUtils.getJson(file);
        JsonArray array = WaypointJsonUtils.getJsonArray(list, waypoint.dimension);
        int oldIndex = WaypointJsonUtils.getMatchInArray(array, oldName);
        if (oldIndex != (newIndex = WaypointJsonUtils.getMatchInArray(array, waypoint.getName())) && newIndex >= 0 && !force) {
            result[1] = Translation.WAYPOINT_EXISTS_1.getString();
            result[2] = Translation.WAYPOINT_EXISTS_2.getString();
            return result;
        }
        JsonObject jsonWaypoint = WaypointJsonUtils.generateJson(waypoint);
        if (oldIndex == newIndex) {
            array.set(newIndex, (JsonElement)jsonWaypoint);
        } else if (newIndex <= 0) {
            array.remove(oldIndex);
            array.add((JsonElement)jsonWaypoint);
        } else {
            array.set(newIndex, (JsonElement)jsonWaypoint);
            array.remove(oldIndex);
        }
        list.add(waypoint.dimension, (JsonElement)array);
        FileUtils.saveFile(file, list.toString());
        result[0] = true;
        result[1] = Translation.WAYPOINT_DONE.getString();
        result[2] = "";
        return result;
    }

    public static Object[] addWaypoint(String dir, Waypoint waypoint, boolean force) {
        Object[] result = new Object[3];
        result[0] = false;
        if (WaypointJsonUtils.isEmpty(waypoint.getName())) {
            result[1] = Translation.WAYPOINT_EMPTY_NAME.getString();
            result[2] = "";
            return result;
        }
        File file = WaypointJsonUtils.getFileSafe(path + "/waypoints/" + dir + "/waypoints.json");
        JsonObject list = !file.exists() ? new JsonObject() : WaypointJsonUtils.getJson(file);
        JsonArray array = WaypointJsonUtils.getJsonArray(list, waypoint.dimension);
        int index = WaypointJsonUtils.getMatchInArray(array, waypoint.getName());
        if (index >= 0 && !force) {
            result[1] = Translation.WAYPOINT_EXISTS_1.getString();
            result[2] = Translation.WAYPOINT_EXISTS_2.getString();
            return result;
        }
        JsonObject jsonWaypoint = WaypointJsonUtils.generateJson(waypoint);
        if (index < 0) {
            array.add((JsonElement)jsonWaypoint);
        } else {
            array.set(index, (JsonElement)jsonWaypoint);
        }
        list.add(waypoint.dimension, (JsonElement)array);
        FileUtils.saveFile(file, list.toString());
        result[0] = true;
        result[1] = Translation.WAYPOINT_DONE.getString();
        result[2] = "";
        return result;
    }

    private static JsonObject getJson(File file) {
        JsonObject jsonObject;
        JsonParser jsonParser = new JsonParser();
        FileReader reader = new FileReader(file);
        try {
            JsonElement obj = jsonParser.parse((Reader)reader);
            jsonObject = obj.isJsonObject() ? obj.getAsJsonObject() : new JsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    private static JsonArray getJsonArray(JsonObject object, String key) {
        if (object.get(key) == null) {
            return new JsonArray();
        }
        return object.get(key).isJsonArray() ? object.get(key).getAsJsonArray() : new JsonArray();
    }
}

