/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.ModInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.fabricmc.loader.api.SemanticVersion;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3797;
import net.minecraft.class_5250;

public class VersionChecker {
    public static void startVersionCheck(final ModInfo modInfo) {
        new Thread("Advanced Compass version check"){

            @Override
            public void run() {
                Result result = Result.CHECKING;
                SemanticVersion target = null;
                String display_url = null;
                try {
                    URL url = modInfo.url;
                    InputStream con = this.openUrlStream(url);
                    String data = new String(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    display_url = (String)json.get("homepage");
                    String mcVersion = class_3797.method_16672().method_48019();
                    String rec = (String)promos.get(mcVersion + "-fabric");
                    SemanticVersion current = modInfo.version;
                    if (rec != null) {
                        SemanticVersion recommended = SemanticVersion.parse((String)rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            result = Result.UP_TO_DATE;
                        } else if (diff < 0) {
                            result = Result.UP_TO_DATE;
                        } else {
                            result = Result.OUTDATED;
                            target = recommended;
                        }
                        if (result.equals((Object)Result.OUTDATED)) {
                            class_5250 text = class_2561.method_43470((String)(class_124.field_1080 + "[" + class_124.field_1060 + "Advanced Compass" + class_124.field_1080 + "] " + class_124.field_1068 + Translation.UPDATE.getString()));
                            class_5250 link = class_2561.method_43470((String)("[" + class_124.field_1054 + Translation.UPDATE_CLICK.getString() + class_124.field_1068 + "]"));
                            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11749, display_url);
                            link.method_10862(link.method_10866().method_10958(clickEvent));
                            text.method_10852((class_2561)link);
                            class_310.method_1551().field_1724.method_7353((class_2561)text, false);
                        }
                    } else {
                        AdvancedCompass.Log("Can't find update string");
                    }
                }
                catch (Exception e) {
                    AdvancedCompass.Log("Failed to process update information:\n" + e);
                    result = Result.FAILED;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InputStream openUrlStream(URL url) throws IOException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < 20; ++redirects) {
                    URLConnection c = currentUrl.openConnection();
                    if (c instanceof HttpURLConnection) {
                        HttpURLConnection huc = (HttpURLConnection)c;
                        huc.setInstanceFollowRedirects(false);
                        int responseCode = huc.getResponseCode();
                        if (responseCode >= 300 && responseCode <= 399) {
                            try {
                                String loc = huc.getHeaderField("Location");
                                currentUrl = new URL(currentUrl, loc);
                                continue;
                            }
                            finally {
                                huc.disconnect();
                            }
                        }
                    }
                    return c.getInputStream();
                }
                throw new IOException("Too many redirects while trying to fetch " + url);
            }
        }.start();
    }

    public static enum Result {
        CHECKING,
        FAILED,
        UP_TO_DATE,
        OUTDATED;

    }
}

