/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import dlovin.advancedcompass.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_3882;
import net.minecraft.class_4041;
import net.minecraft.class_4495;
import net.minecraft.class_4791;
import net.minecraft.class_4997;
import net.minecraft.class_549;
import net.minecraft.class_553;
import net.minecraft.class_555;
import net.minecraft.class_558;
import net.minecraft.class_5597;
import net.minecraft.class_562;
import net.minecraft.class_570;
import net.minecraft.class_571;
import net.minecraft.class_572;
import net.minecraft.class_574;
import net.minecraft.class_575;
import net.minecraft.class_5772;
import net.minecraft.class_578;
import net.minecraft.class_582;
import net.minecraft.class_583;
import net.minecraft.class_584;
import net.minecraft.class_596;
import net.minecraft.class_597;
import net.minecraft.class_602;
import net.minecraft.class_608;
import net.minecraft.class_611;
import net.minecraft.class_617;
import net.minecraft.class_620;
import net.minecraft.class_621;
import net.minecraft.class_624;
import net.minecraft.class_630;
import net.minecraft.class_7198;
import net.minecraft.class_7201;
import net.minecraft.class_7280;
import net.minecraft.class_7308;
import net.minecraft.class_7751;
import net.minecraft.class_8185;
import net.minecraft.class_895;

public class ModelPartUtils {
    private static final HashMap<String, Function<class_583<? extends class_1309>, class_630[]>> PART_CONSUMERS = new HashMap();

    public static List<ModelWithParts> getModeledPartsFromHead(ModelWithParts mainModel, List<ModelWithParts> models) {
        ArrayList<ModelWithParts> result = new ArrayList<ModelWithParts>();
        class_630[] mainParts = ModelPartUtils.getHeadModel((class_583<? extends class_1309>)mainModel.model);
        if (mainParts != null && mainParts.length > 0) {
            ModelWithParts mwp = new ModelWithParts(mainModel.model);
            mwp.parts = mainParts;
            result.add(mwp);
        }
        if (result.size() > 0) {
            return result;
        }
        for (ModelWithParts addModel : models) {
            class_630[] subResult = ModelPartUtils.getHeadModel((class_583<? extends class_1309>)addModel.model);
            if (subResult == null || subResult.length <= 0) continue;
            ModelWithParts mwp = new ModelWithParts(addModel.model);
            mwp.parts = subResult;
            result.add(mwp);
        }
        return result;
    }

    public static List<ModelWithParts> getModeledFullParts(ModelWithParts mainModel, List<ModelWithParts> models) {
        ArrayList<ModelWithParts> result = new ArrayList<ModelWithParts>();
        class_630[] mainParts = ModelPartUtils.getAllParts(mainModel.model);
        if (mainParts != null && mainParts.length > 0) {
            ModelWithParts mwp = new ModelWithParts(mainModel.model);
            mwp.parts = mainParts;
            result.add(mwp);
        }
        for (ModelWithParts addModel : models) {
            class_630[] subResult = ModelPartUtils.getAllParts(addModel.model);
            if (subResult == null || subResult.length <= 0) continue;
            ModelWithParts mwp = new ModelWithParts(addModel.model);
            mwp.parts = subResult;
            result.add(mwp);
        }
        return result;
    }

    @Deprecated
    public static class_630[] getPartsFromHead(class_583 model, List<class_583> additionalModels) {
        ArrayList<class_630> result = new ArrayList<class_630>();
        class_630[] mainParts = ModelPartUtils.getHeadModel((class_583<? extends class_1309>)model);
        if (mainParts != null && mainParts.length > 0) {
            result.addAll(List.of(mainParts));
        }
        if (result.size() > 0) {
            return result.toArray(new class_630[0]);
        }
        for (class_583 addModel : additionalModels) {
            class_630[] subResult = ModelPartUtils.getHeadModel((class_583<? extends class_1309>)addModel);
            if (subResult == null || subResult.length <= 0) continue;
            result.addAll(List.of(subResult));
        }
        return result.toArray(new class_630[0]);
    }

    @Deprecated
    public static class_630[] getFullParts(class_583 model, List<class_583> additionalModels) {
        ArrayList<class_630> result = new ArrayList<class_630>();
        class_630[] mainParts = ModelPartUtils.getAllParts(model);
        if (mainParts != null && mainParts.length > 0) {
            result.addAll(List.of(mainParts));
        }
        for (class_583 addModel : additionalModels) {
            class_630[] subResult = ModelPartUtils.getAllParts(addModel);
            if (subResult == null || subResult.length <= 0) continue;
            result.addAll(List.of(subResult));
        }
        return result.toArray(new class_630[0]);
    }

    private static class_630[] getHeadModel(class_583<? extends class_1309> model) {
        if (model instanceof class_4791) {
            return PART_CONSUMERS.get("hoglin").apply(model);
        }
        if (model instanceof class_624) {
            return PART_CONSUMERS.get("wolf").apply(model);
        }
        if (model instanceof class_621) {
            return PART_CONSUMERS.get("wither").apply(model);
        }
        if (model instanceof class_620) {
            return PART_CONSUMERS.get("villager").apply(model);
        }
        if (model instanceof class_596) {
            return PART_CONSUMERS.get("rabbit").apply(model);
        }
        if (model instanceof class_575) {
            return PART_CONSUMERS.get("illager").apply(model);
        }
        if (model instanceof class_617) {
            return PART_CONSUMERS.get("vex").apply(model);
        }
        if (model instanceof class_4997) {
            return PART_CONSUMERS.get("strider").apply(model);
        }
        if (model instanceof class_611) {
            return PART_CONSUMERS.get("spider").apply(model);
        }
        if (model instanceof class_608) {
            return PART_CONSUMERS.get("snow_golem").apply(model);
        }
        if (model instanceof class_4041) {
            return PART_CONSUMERS.get("fox").apply(model);
        }
        if (model instanceof class_602) {
            return PART_CONSUMERS.get("shulker").apply(model);
        }
        if (model instanceof class_571) {
            return PART_CONSUMERS.get("ravager").apply(model);
        }
        if (model instanceof class_584) {
            return PART_CONSUMERS.get("parrot").apply(model);
        }
        if (model instanceof class_582) {
            return PART_CONSUMERS.get("ocelot").apply(model);
        }
        if (model instanceof class_549) {
            return PART_CONSUMERS.get("horse").apply(model);
        }
        if (model instanceof class_574) {
            return PART_CONSUMERS.get("iron_golem").apply(model);
        }
        if (model instanceof class_570) {
            return PART_CONSUMERS.get("guardian").apply(model);
        }
        if (model instanceof class_895.class_625) {
            return PART_CONSUMERS.get("ender_dragon").apply(model);
        }
        if (model instanceof class_562) {
            return PART_CONSUMERS.get("creeper").apply(model);
        }
        if (model instanceof class_578) {
            return PART_CONSUMERS.get("llama").apply(model);
        }
        if (model instanceof class_558) {
            return PART_CONSUMERS.get("chicken").apply(model);
        }
        if (model instanceof class_555) {
            return PART_CONSUMERS.get("blaze").apply(model);
        }
        if (model instanceof class_4495) {
            return PART_CONSUMERS.get("bee").apply(model);
        }
        if (model instanceof class_553) {
            return PART_CONSUMERS.get("bat").apply(model);
        }
        if (model instanceof class_5772) {
            return PART_CONSUMERS.get("axolotl").apply(model);
        }
        if (model instanceof class_7308) {
            return PART_CONSUMERS.get("allay").apply(model);
        }
        if (model instanceof class_7198) {
            return PART_CONSUMERS.get("frog").apply(model);
        }
        if (model instanceof class_7201) {
            return PART_CONSUMERS.get("tadpole").apply(model);
        }
        if (model instanceof class_7280) {
            return PART_CONSUMERS.get("warden").apply(model);
        }
        if (model instanceof class_8185) {
            return PART_CONSUMERS.get("sniffer").apply(model);
        }
        if (model instanceof class_7751) {
            return PART_CONSUMERS.get("camel").apply(model);
        }
        if (model instanceof class_572) {
            return PART_CONSUMERS.get("humanoid").apply(model);
        }
        if (model instanceof class_597) {
            return PART_CONSUMERS.get("quadruped").apply(model);
        }
        if (model instanceof class_5597) {
            return PART_CONSUMERS.get("hierarchical").apply(model);
        }
        if (model instanceof class_3882) {
            class_3882 headedModel = (class_3882)model;
            return new class_630[]{headedModel.method_2838()};
        }
        return ModelPartUtils.getRootedHead(model);
    }

    private static class_630[] getHierarchicalModelParts(class_583<? extends class_1309> model) {
        class_630 root = ((class_5597)model).method_32008();
        class_630 head = null;
        if (root.method_41919("head")) {
            head = root.method_32086("head");
        } else if (root.method_41919("body") && root.method_32086("body").method_41919("head")) {
            head = root.method_32086("body").method_32086("head");
        }
        return new class_630[]{head == null ? root : head};
    }

    private static class_630[] getHumanoidHeadParts(class_583<? extends class_1309> model) {
        return new class_630[]{((class_572)model).method_2838(), ((class_572)model).field_3394};
    }

    private static class_630[] getVillagerHeadParts(class_583<? extends class_1309> model) {
        return new class_630[]{((class_620)model).method_2838(), (class_630)ReflectionUtils.getFieldValueFromExactClass(model, class_620.class, class_630.class, 2)};
    }

    private static class_630[] getIllagerHeadParts(class_583<? extends class_1309> model) {
        return new class_630[]{((class_575)model).method_2838(), ((class_575)model).method_2812()};
    }

    private static class_630[] getFoxHeadPart(class_583<? extends class_1309> model) {
        return new class_630[]{((class_4041)model).field_18015};
    }

    private static class_630[] getSnowGolemHeadPart(class_583<? extends class_1309> model) {
        return new class_630[]{((class_608)model).method_2834()};
    }

    private static class_630[] getShulkerHeadPart(class_583<? extends class_1309> model) {
        return new class_630[]{((class_602)model).method_2830()};
    }

    private static class_630[] getBeeHeadParts(class_583<? extends class_1309> model) {
        return new class_630[]{ModelPartUtils.getFirstModelPart(model, class_4495.class)[0].method_32086("body")};
    }

    private static class_630[] getFirstModelPart(class_583<? extends class_1309> model, Class modelClass) {
        return ModelPartUtils.getModelPartsByIndex(model, modelClass, 0);
    }

    private static class_630[] getModelPartsByIndex(class_583<? extends class_1309> model, Class modelClass, int ... indexes) {
        class_630[] result = new class_630[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = (class_630)ReflectionUtils.getFieldValueFromExactClass(model, modelClass, class_630.class, i);
        }
        return result;
    }

    private static class_630[] getRootedHead(class_583 model) {
        try {
            ArrayList<class_630> modelParts = new ArrayList<class_630>();
            Field[] fields = ReflectionUtils.getAllPrivateFields(model, class_583.class).toArray(new Field[0]);
            for (Field field : fields) {
                field.setAccessible(true);
                Object object = field.get(model);
                if (!(object instanceof class_630)) continue;
                class_630 part = (class_630)object;
                modelParts.add(part);
            }
            if (modelParts.size() == 0) {
                return null;
            }
            for (class_630 part : modelParts) {
                if (part.method_41919("head")) {
                    return new class_630[]{part.method_32086("head")};
                }
                if (part.method_41919("body")) {
                    if (part.method_32086("body").method_41919("head")) {
                        return new class_630[]{part.method_32086("body").method_32086("head")};
                    }
                    if (part.method_32086("body").method_41919("neck") && part.method_32086("body").method_32086("neck").method_41919("head")) {
                        return new class_630[]{part.method_32086("body").method_32086("neck").method_32086("head")};
                    }
                }
                if (!part.method_41919("neck") || !part.method_32086("neck").method_41919("head")) continue;
                return new class_630[]{part.method_32086("neck").method_32086("head")};
            }
            return modelParts.toArray(new class_630[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class_630[] getAllParts(class_583 model) {
        try {
            Field[] fields;
            ArrayList<class_630> modelParts = new ArrayList<class_630>();
            for (Field field : fields = ReflectionUtils.getAllPrivateFields(model, class_583.class).toArray(new Field[0])) {
                field.setAccessible(true);
                Object object = field.get(model);
                if (!(object instanceof class_630)) continue;
                class_630 part = (class_630)object;
                modelParts.add(part);
            }
            if (modelParts.size() == 0) {
                return null;
            }
            return modelParts.toArray(new class_630[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        PART_CONSUMERS.put("hoglin", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_4791.class));
        PART_CONSUMERS.put("wolf", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_624.class));
        PART_CONSUMERS.put("wither", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_621.class, 1));
        PART_CONSUMERS.put("villager", ModelPartUtils::getVillagerHeadParts);
        PART_CONSUMERS.put("rabbit", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_596.class, 7, 8, 9));
        PART_CONSUMERS.put("illager", ModelPartUtils::getIllagerHeadParts);
        PART_CONSUMERS.put("vex", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_617.class, 6));
        PART_CONSUMERS.put("strider", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_4997.class, 3));
        PART_CONSUMERS.put("spider", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_611.class, 1));
        PART_CONSUMERS.put("snow_golem", ModelPartUtils::getSnowGolemHeadPart);
        PART_CONSUMERS.put("fox", ModelPartUtils::getFoxHeadPart);
        PART_CONSUMERS.put("shulker", ModelPartUtils::getShulkerHeadPart);
        PART_CONSUMERS.put("ravager", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_571.class, 1));
        PART_CONSUMERS.put("parrot", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_584.class, 5));
        PART_CONSUMERS.put("ocelot", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_582.class, 6));
        PART_CONSUMERS.put("horse", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_549.class, 1));
        PART_CONSUMERS.put("iron_golem", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_574.class, 1));
        PART_CONSUMERS.put("guardian", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_570.class, 1));
        PART_CONSUMERS.put("ender_dragon", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_895.class_625.class));
        PART_CONSUMERS.put("creeper", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_562.class, 1));
        PART_CONSUMERS.put("llama", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_578.class));
        PART_CONSUMERS.put("chicken", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_558.class));
        PART_CONSUMERS.put("blaze", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_555.class, 1));
        PART_CONSUMERS.put("bee", ModelPartUtils::getBeeHeadParts);
        PART_CONSUMERS.put("bat", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_553.class, 1));
        PART_CONSUMERS.put("axolotl", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_5772.class, 6));
        PART_CONSUMERS.put("allay", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_7308.class, 1));
        PART_CONSUMERS.put("frog", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_7198.class, 2));
        PART_CONSUMERS.put("tadpole", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_7201.class));
        PART_CONSUMERS.put("warden", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_7280.class, 3));
        PART_CONSUMERS.put("sniffer", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_8185.class, 0));
        PART_CONSUMERS.put("camel", model -> ModelPartUtils.getModelPartsByIndex((class_583<? extends class_1309>)model, class_7751.class, 1));
        PART_CONSUMERS.put("humanoid", ModelPartUtils::getHumanoidHeadParts);
        PART_CONSUMERS.put("quadruped", model -> ModelPartUtils.getFirstModelPart((class_583<? extends class_1309>)model, class_597.class));
        PART_CONSUMERS.put("hierarchical", ModelPartUtils::getHierarchicalModelParts);
    }

    public static class ModelWithParts {
        public class_583 model;
        public class_630[] parts;

        public ModelWithParts(class_583 model) {
            this.model = model;
        }
    }
}

