/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.FileUtils;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_7923;

public class JsonUtils {
    private static final String path = FabricLoader.getInstance().getConfigDir() + "/AdvancedCompass/";

    public static void initVanilla() {
        File file = new File(path + "mobs/mobs.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            FileUtils.saveFile("mobs/mobs.json", JsonUtils.getDefault());
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement obj = jsonParser.parse((Reader)reader);
            JsonObject list = JsonUtils.checkTypes(obj.getAsJsonObject());
            JsonUtils.setTypes(list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addMob(String fileName, String id, int width, int height) {
        File file = new File(path + "mobs/" + fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        JsonParser jsonParser = new JsonParser();
        if (!file.exists()) {
            FileUtils.createEmpty(file);
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj;
            JsonElement element = jsonParser.parse((Reader)reader);
            if (!element.isJsonObject()) {
                obj = new JsonObject();
                object = new JsonObject();
                object.addProperty("width", (Number)width);
                object.addProperty("height", (Number)height);
                object.addProperty("show", Boolean.valueOf(true));
                obj.add(id, (JsonElement)object);
            } else {
                obj = element.getAsJsonObject();
                if (obj.get(id) == null) {
                    object = new JsonObject();
                    object.addProperty("width", (Number)width);
                    object.addProperty("height", (Number)height);
                    object.addProperty("show", Boolean.valueOf(true));
                    obj.add(id, (JsonElement)object);
                } else {
                    object = obj.get(id).getAsJsonObject();
                    object.addProperty("width", (Number)width);
                    object.addProperty("height", (Number)height);
                }
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(obj.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject getModJson(String mod) {
        File file = new File(path + "mobs/" + mod + "/mobs.json");
        if (!file.exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(file);){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)reader);
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                return jsonObject;
            }
            JsonObject jsonObject = null;
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveMobs() {
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        JsonObject obj = new JsonObject();
        for (Map.Entry<class_1299, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            if (entry.getKey().method_16351().method_12836().equals("minecraft")) {
                obj.addProperty(entry.getKey().method_5882(), Boolean.valueOf(GroupUtils.types.contains(entry.getKey())));
                continue;
            }
            JsonObject tmp = JsonUtils.getModJson(class_7923.field_41177.method_10221((Object)entry.getKey()).method_12836());
            if (tmp == null) continue;
            if (!objects.containsKey(class_7923.field_41177.method_10221((Object)entry.getKey()).method_12836())) {
                objects.put(class_7923.field_41177.method_10221((Object)entry.getKey()).method_12836(), tmp);
            }
            ((JsonObject)objects.get(class_7923.field_41177.method_10221((Object)entry.getKey()).method_12836())).get(class_7923.field_41177.method_10221((Object)entry.getKey()).method_12832()).getAsJsonObject().addProperty("show", Boolean.valueOf(GroupUtils.types.contains(entry.getKey())));
        }
        FileUtils.saveFile("mobs/mobs.json", obj.toString());
        for (Map.Entry<Object, TextureCoords> entry : objects.entrySet()) {
            FileUtils.saveFile("mobs/" + (String)entry.getKey() + "/mobs.json", ((JsonObject)entry.getValue()).toString());
        }
    }

    private static String getDefault() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<class_1299, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            obj.addProperty(entry.getKey().method_5882(), Boolean.valueOf(true));
        }
        return obj.toString();
    }

    private static void setTypes(JsonObject obj) {
        GroupUtils.types = new HashSet<class_1299>();
        for (Map.Entry el : obj.entrySet()) {
            if (!((JsonElement)el.getValue()).getAsBoolean()) continue;
            GroupUtils.types.add(HeadUtils.getType((String)el.getKey()));
        }
    }

    private static JsonObject checkTypes(JsonObject obj) {
        boolean save = false;
        StringBuilder missed = new StringBuilder("Missed entities:");
        for (Map.Entry<class_1299, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            if (obj.get(entry.getKey().method_5882()) != null) continue;
            obj.addProperty(entry.getKey().method_5882(), Boolean.valueOf(true));
            missed.append("\n").append(entry.getKey().method_16351());
            save = true;
        }
        if (save) {
            FileUtils.saveFile("mobs/mobs.json", obj.toString());
            AdvancedCompass.Log(String.format(Locale.ROOT, "%s%s", missed.toString(), "\nAll added as 'true'"));
        }
        return obj;
    }
}

