/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import dlovin.advancedcompass.utils.GLRefs;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageUtils {
    private static int getMinY(BufferedImage src) {
        int yLast = -1;
        int y = 0;
        while (y < src.getHeight()) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y++;
        }
        return yLast;
    }

    private static int getMaxY(BufferedImage src) {
        int yLast = src.getHeight();
        int y = src.getHeight() - 1;
        while (y >= 0) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y--;
        }
        return yLast;
    }

    private static int getMinX(BufferedImage src) {
        int xLast = -1;
        int x = 0;
        while (x < src.getWidth()) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x++;
        }
        return xLast;
    }

    private static int getMaxX(BufferedImage src) {
        int xLast = src.getWidth();
        int x = src.getWidth() - 1;
        while (x >= 0) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x--;
        }
        return xLast;
    }

    public static BufferedImage cropImage(BufferedImage src) throws RasterFormatException {
        int yMin = ImageUtils.getMinY(src);
        int yMax = ImageUtils.getMaxY(src);
        int xMin = ImageUtils.getMinX(src);
        int xMax = ImageUtils.getMaxX(src);
        BufferedImage dest = src.getSubimage(xMin + 1, yMin + 1, xMax - xMin - 1, yMax - yMin - 1);
        return dest;
    }

    public static BufferedImage outlineImage(BufferedImage src) {
        int y;
        int x;
        BufferedImage cropped = ImageUtils.cropImage(src);
        BufferedImage resized = new BufferedImage(cropped.getWidth() + 4, cropped.getHeight() + 4, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage((Image)cropped, 2, 2, null);
        g2d.dispose();
        BufferedImage oimg = new BufferedImage(resized.getWidth(), resized.getHeight(), 2);
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (resized.getRGB(x, y) >> 24 != 0 || resized.getRGB(x - 1, y) >> 24 == 0 && resized.getRGB(x + 1, y) >> 24 == 0 && resized.getRGB(x, y - 1) >> 24 == 0 && resized.getRGB(x, y + 1) >> 24 == 0) continue;
                oimg.setRGB(x, y, -16777216);
            }
        }
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (oimg.getRGB(x, y) != 0) continue;
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x - 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y + 1) == -16777216 && oimg.getRGB(x - 1, y + 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x + 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) != -16777216 || oimg.getRGB(x, y + 1) != -16777216 || oimg.getRGB(x + 1, y + 1) == -16777216) continue;
                oimg.setRGB(x, y, Integer.MIN_VALUE);
            }
        }
        g2d = oimg.createGraphics();
        g2d.drawImage((Image)oimg, 0, 0, null);
        g2d.drawImage((Image)resized, 0, 0, null);
        g2d.dispose();
        return oimg;
    }

    public static BufferedImage rescale(BufferedImage src, int hints) {
        int scaledHeight;
        int scaledWidth;
        if ((float)src.getWidth() / (float)src.getHeight() > 1.4f) {
            float scale = 16.0f / (float)src.getWidth();
            scaledWidth = 16;
            scaledHeight = (int)((float)src.getHeight() * scale);
        } else if ((float)src.getHeight() / (float)src.getWidth() > 1.4f) {
            float scale = 16.0f / (float)src.getHeight();
            scaledHeight = 16;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else if (src.getHeight() < src.getWidth()) {
            float scale = 12.0f / (float)src.getHeight();
            scaledHeight = 12;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else {
            float scale = 12.0f / (float)src.getWidth();
            scaledWidth = 12;
            scaledHeight = (int)((float)src.getHeight() * scale);
        }
        Image tmp = src.getScaledInstance(scaledWidth, scaledHeight, hints);
        BufferedImage dimg = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static BufferedImage createBufferedImageFromGLID(int id) {
        GLRefs.bindTexture(id);
        return ImageUtils.createBufferedImageFromCurrentGLImage();
    }

    public static BufferedImage createBufferedImageFromCurrentGLImage() {
        int imageWidth = GLRefs.getTextureWidth();
        int imageHeight = GLRefs.getTextureHeight();
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 6);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(imageWidth * imageHeight * 4).order(ByteOrder.nativeOrder());
        GLRefs.getTexImage(3553, 0, 6408, 5121, byteBuffer);
        byteBuffer.position(0);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = 0; y < imageHeight; ++y) {
                int index = y * imageWidth * 4 + x * 4;
                int color24 = bytes[index + 2] & 0xFF;
                color24 |= (bytes[index + 1] & 0xFF) << 8;
                color24 |= (bytes[index] & 0xFF) << 16;
                image.setRGB(x, y, color24 |= (bytes[index + 3] & 0xFF) << 24);
            }
        }
        return image;
    }
}

