/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.GLRefs;
import dlovin.advancedcompass.utils.GLTools;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.ImageUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import dlovin.advancedcompass.utils.ModelPartUtils;
import dlovin.advancedcompass.utils.QueuedEntity;
import dlovin.advancedcompass.utils.ReflectionUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.exceptions.NullResourceLocation;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_566;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class IconCreator {
    private ArrayDeque<QueuedEntity> queue = new ArrayDeque();
    private List<class_1299> types;
    class_310 mc = class_310.method_1551();
    private class_1297 currentEntity;
    private int skipFrames = 60;

    public IconCreator() {
        this.types = new ArrayList<class_1299>();
        for (Map.Entry<class_1299, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            this.types.add(entry.getKey());
        }
    }

    public void setSkipFrames() {
        this.skipFrames = 60;
    }

    public void queueEntity(QueuedEntity entity) {
        System.out.println("ADD:" + class_1299.method_5890((class_1299)entity.entity.method_5864()));
        this.types.add(entity.entity.method_5864());
        this.queue.add(entity);
    }

    private class_2960 TryToSaveIcon(BufferedImage mobSkin, class_1297 en, String namespace) throws RasterFormatException {
        if (mobSkin != null) {
            File directory = new File(FabricLoader.getInstance().getConfigDir() + "/AdvancedCompass/mobs/" + namespace);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File outputfile = new File(directory + "/" + class_7923.field_41177.method_10221((Object)en.method_5864()).method_12832() + ".png");
            try {
                BufferedImage editedImage = ImageUtils.outlineImage(ImageUtils.rescale(ImageUtils.cropImage(mobSkin), 1));
                ImageIO.write((RenderedImage)editedImage, "png", outputfile);
                return this.saveJson(en, namespace, editedImage.getWidth(), editedImage.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        AdvancedCompass.Log("Can't create icon for: " + class_7923.field_41177.method_10221((Object)en.method_5864()));
        return null;
    }

    private void saveRaw(String path, BufferedImage rawImage) throws IOException {
        File rawOut = new File(path + ".raw.png");
        File cropOut = new File(path + ".crop.png");
        File rescaleOut = new File(path + ".scale.png");
        File outOut = new File(path + ".out.png");
        ImageIO.write((RenderedImage)rawImage, "png", rawOut);
        BufferedImage crop = ImageUtils.cropImage(rawImage);
        ImageIO.write((RenderedImage)crop, "png", cropOut);
        BufferedImage rescale = ImageUtils.rescale(crop, 1);
        ImageIO.write((RenderedImage)rescale, "png", rescaleOut);
        BufferedImage out = ImageUtils.outlineImage(rescale);
        ImageIO.write((RenderedImage)out, "png", outOut);
    }

    public void renderTick() {
        if (this.queue.peek() != null) {
            if (this.skipFrames > 0) {
                --this.skipFrames;
                return;
            }
            QueuedEntity queuedEntity = this.queue.pop();
            class_1297 en = queuedEntity.entity;
            class_2960 identifier = queuedEntity.resourceLocation;
            String namespace = class_7923.field_41177.method_10221((Object)en.method_5864()).method_12836();
            AdvancedCompass.Log("Trying to create icon for: " + namespace + ":" + class_7923.field_41177.method_10221((Object)en.method_5864()).method_12832());
            switch (AdvancedCompass.getInstance().getCompassGui().settings.getGenerationType()) {
                case HEAD_FIRST: {
                    this.cycle(en, namespace, identifier, true);
                    break;
                }
                case FULL_BODY: {
                    this.cycle(en, namespace, identifier, false);
                    break;
                }
                case OFF: {
                    this.saveDefault(en, namespace);
                }
            }
            AdvancedCompass.Log("Creating process done with some state, no jre or opengl errors!");
        }
    }

    public void addType(class_1299 type) {
        this.types.add(type);
    }

    public boolean isInList(class_1297 entity) {
        return this.types.contains(entity.method_5864());
    }

    private class_2960 saveJson(class_1297 en, String namespace, int width, int height) {
        JsonUtils.addMob(namespace + "/mobs.json", class_7923.field_41177.method_10221((Object)en.method_5864()).method_12832(), width, height);
        class_2960 res = new class_2960("advancedcompass." + namespace, class_7923.field_41177.method_10221((Object)en.method_5864()).method_12832());
        HeadUtils.addHead(en.method_5864(), width, height, res);
        GroupUtils.types.add(en.method_5864());
        return res;
    }

    public class_2960 cycle(class_1297 en, String namespace, class_2960 resourceLocation, boolean head) {
        BufferedImage mobSkin = this.createIcon(en, (class_897<? extends class_1297>)this.mc.method_1561().method_3953(en), resourceLocation, head);
        try {
            class_2960 headCycle = this.TryToSaveIcon(mobSkin, en, namespace);
            if (headCycle == null) {
                throw new NullResourceLocation("Null resource location for some reason");
            }
            return headCycle;
        }
        catch (NullResourceLocation | RasterFormatException ex) {
            AdvancedCompass.Log("Can't create icon for: " + class_7923.field_41177.method_10221((Object)en.method_5864()));
            return this.saveDefault(en, namespace);
        }
    }

    public class_2960 saveDefault(class_1297 en, String namespace) {
        class_2960 res = en.method_5864().method_5891().method_6136() ? new class_2960("advancedcompass", "textures/neutral.png") : new class_2960("advancedcompass", "textures/hostile.png");
        try {
            InputStream is = ((class_3298)this.mc.method_1478().method_14486(res).get()).method_14482();
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            File directory = new File(FabricLoader.getInstance().getConfigDir() + "/AdvancedCompass/mobs/" + namespace);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File outputfile = new File(directory + "/" + class_7923.field_41177.method_10221((Object)en.method_5864()).method_12832() + ".png");
            FileOutputStream outStream = new FileOutputStream(outputfile);
            ((OutputStream)outStream).write(buffer);
            ((OutputStream)outStream).close();
            is.close();
            return this.saveJson(en, namespace, 16, 16);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private BufferedImage createIcon(class_1297 en, class_897<? extends class_1297> render, class_2960 resourceLocation, boolean head) {
        BufferedImage headImage = null;
        ModelPartUtils.ModelWithParts mainModel = null;
        List<ModelPartUtils.ModelWithParts> models = new ArrayList<ModelPartUtils.ModelWithParts>();
        if (render instanceof class_922 || render == null) {
            try {
                mainModel = new ModelPartUtils.ModelWithParts(((class_922)render).method_4038());
                List layers = (List)ReflectionUtils.getFieldValueFromExactClass(render, class_922.class, List.class, 0);
                if (layers.size() > 0) {
                    ArrayList<ModelPartUtils.ModelWithParts> finalModels = models;
                    layers.stream().forEach(layer -> {
                        Field[] fields;
                        for (Field field : fields = ReflectionUtils.getAllPrivateFields(layer, class_3887.class).toArray(new Field[0])) {
                            field.setAccessible(true);
                            try {
                                Object patt8874$temp = field.get(layer);
                                if (!(patt8874$temp instanceof class_583)) continue;
                                class_583 part = (class_583)patt8874$temp;
                                finalModels.add(new ModelPartUtils.ModelWithParts(part));
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    models = finalModels;
                }
                models = head ? ModelPartUtils.getModeledPartsFromHead(mainModel, models) : ModelPartUtils.getModeledFullParts(mainModel, models);
                if (en != null && mainModel != null && models != null && IconCreator.hasParts(models) && resourceLocation != null) {
                    float scale = 1.0f;
                    class_2350 facing = class_2350.field_11043;
                    boolean success = this.drawModel(scale, 1000, (class_1309)en, facing, mainModel.model, models, resourceLocation);
                    if (!success) {
                        return null;
                    }
                } else {
                    return null;
                }
                headImage = ImageUtils.createBufferedImageFromGLID(GLTools.textureID);
            }
            catch (Exception var28) {
                headImage = null;
                var28.printStackTrace();
            }
        } else {
            return null;
        }
        return headImage;
    }

    private static boolean hasParts(List<ModelPartUtils.ModelWithParts> models) {
        int count = 0;
        for (ModelPartUtils.ModelWithParts model : models) {
            if (model.model == null) continue;
            count += model.parts.length;
        }
        return count > 0;
    }

    private void preDraw(float scale, int depth) {
        float size = 64.0f * scale;
        GLTools.setupFrameBuffer();
        GLRefs.bindTexture(GLTools.textureID);
        int width = GLRefs.getTextureWidth();
        int height = GLRefs.getTextureHeight();
        GLRefs.bindTexture(0);
        GLRefs.setViewport(0, 0, width, height);
        RenderSystem.backupProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().ortho(0.0f, (float)width, 0.0f, (float)height, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, null);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34426();
        matrixStack.method_22904(0.0, 0.0, -3000.0 + (double)depth);
        RenderSystem.applyModelViewMatrix();
        GLTools.bindFrameBuffer();
        GLRefs.depthMask(true);
        GLRefs.enableDepth();
        GLRefs.enableTexture();
        GLRefs.enableBlend();
        GLRefs.disableCull();
        GLRefs.clearColor(1.0f, 1.0f, 1.0f, 0.0f);
        GLRefs.clearDepth(1.0);
        GLRefs.clear(16640);
        GLRefs.blendFunc(770, 771);
        matrixStack.method_22903();
        matrixStack.method_22904((double)(width / 2), (double)(height / 2), 0.0);
        matrixStack.method_22905(size, size, size);
        matrixStack.method_22907(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f));
    }

    private void postDraw(class_4587 matrixStack) {
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        GLRefs.enableCull();
        GLRefs.disableDepth();
        GLRefs.depthMask(false);
        GLTools.unbindFrameBuffer();
        RenderSystem.restoreProjectionMatrix();
        GLRefs.setViewport(0, 0, this.mc.method_22683().method_4486(), this.mc.method_22683().method_4502());
    }

    private boolean drawModel(float scale, int captureDepth, class_1309 livingEntity, class_2350 facing, class_583 mainModel, List<ModelPartUtils.ModelWithParts> models, class_2960 resourceLocation) {
        boolean failed = false;
        this.preDraw(scale, captureDepth);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        if (facing == class_2350.field_11034) {
            matrixStack.method_22907(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -90.0f));
        } else if (facing == class_2350.field_11036) {
            matrixStack.method_22907(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f));
        }
        RenderSystem.applyModelViewMatrix();
        Vector3f fullBright = IconCreator.fullBright(matrixStack.method_23760().method_23761());
        RenderSystem.setShaderLights((Vector3f)fullBright, (Vector3f)fullBright);
        try {
            int t;
            class_4587 newMatrixStack = new class_4587();
            class_4597.class_4598 immediate = this.mc.method_22940().method_23000();
            float offsetByY = mainModel instanceof class_566 ? 8.0f : (!(mainModel instanceof class_572) ? 0.0f : 4.0f);
            float maxY = 0.0f;
            float minY = 0.0f;
            for (ModelPartUtils.ModelWithParts model : models) {
                for (t = 0; t < model.parts.length; ++t) {
                    if (model.parts[t].field_3675 < minY) {
                        minY = model.parts[t].field_3675;
                    }
                    if (!(model.parts[t].field_3675 > maxY)) continue;
                    maxY = model.parts[t].field_3675;
                }
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            for (ModelPartUtils.ModelWithParts model : models) {
                for (t = 0; t < model.parts.length; ++t) {
                    class_4588 vertexConsumer = immediate.getBuffer(class_1921.method_23578((class_2960)resourceLocation));
                    mainModel.method_2819((class_1297)livingEntity, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
                    float y = model.parts[t].field_3656;
                    model.parts[t].field_3656 += offsetByY;
                    newMatrixStack.method_22903();
                    model.parts[t].method_22698(newMatrixStack, vertexConsumer, 0xF000F0, class_4608.field_21444);
                    newMatrixStack.method_22909();
                    model.parts[t].field_3656 = y;
                    immediate.method_22993();
                }
            }
        }
        catch (Exception var25) {
            AdvancedCompass.Log("Error attempting to render model part bits for " + livingEntity.getClass().getSimpleName());
            AdvancedCompass.Log(var25.getLocalizedMessage());
            var25.printStackTrace();
            failed = true;
        }
        this.postDraw(matrixStack);
        return !failed;
    }

    private static Vector3f fullBright(Matrix4f matrix4f) {
        Vector4f vector4f = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        vector4f.mulTranspose((Matrix4fc)matrix4f);
        return new Vector3f(vector4f.x, vector4f.y, vector4f.z);
    }

    private class ModelPartWithResourceLocation {
        class_630 modelPart;
        class_2960 resourceLocation;

        public ModelPartWithResourceLocation(class_630 modelPart, class_2960 resourceLocation) {
            this.modelPart = modelPart;
            this.resourceLocation = resourceLocation;
        }
    }
}

