/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.config.CompassConfig;
import dlovin.advancedcompass.gui.CompassGui;
import dlovin.advancedcompass.gui.renderers.ModWaypointCollector;
import dlovin.advancedcompass.gui.renderers.RendererWithDistance;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.enums.ModWPType;
import dlovin.advancedcompass.utils.waypoints.ModdedWaypoint;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class WaypointRenderer
extends RendererWithDistance {
    Collection<Waypoint> waypoints = new ArrayList<Waypoint>();
    CompassGui parent;

    public WaypointRenderer(class_310 mc, class_327 fontRenderer, CompassConfig settings, CompassGui gui) {
        super(mc, fontRenderer, settings);
        this.parent = gui;
    }

    public void render(class_332 context, float angle, float scale) {
        ArrayList<Waypoint> renderList = new ArrayList<Waypoint>();
        this.waypoints.forEach(w -> {
            int distance = (int)this.getFlatDistance(w.getPosition(), this.mc.field_1724.method_19538());
            if (w.isEnabled() && (w.getMaxDistance() == 0 || distance < w.getMaxDistance()) && w.getMinDistance() < distance) {
                renderList.add((Waypoint)w);
            }
        });
        if (!this.settings.getModWPType().equals(ModWPType.HIDE_ALL)) {
            Iterator<ModWaypointCollector> collectors = this.parent.getModCollectors().iterator();
            while (collectors.hasNext()) {
                collectors.next().addWaypointsToList(renderList, collectors);
            }
        }
        Collections.sort(renderList);
        context.method_51448().method_22903();
        for (Waypoint waypoint : renderList) {
            int distance = (int)this.getFlatDistance(waypoint.getPosition(), this.mc.field_1724.method_19538());
            if (waypoint instanceof ModdedWaypoint) {
                if (((ModdedWaypoint)waypoint).iconRL != null) {
                    this.drawWaypoint(context, ((ModdedWaypoint)waypoint).iconRL, (double)this.ToFormat(90.0f + angle + this.getAngle(waypoint.getPosition())), scale, waypoint.getColor(), ((ModdedWaypoint)waypoint).ydif ? this.mc.field_1724.method_23318() - waypoint.getPosition().field_1351 : 0.0, this.settings.isShowDistance() ? distance : 0);
                    continue;
                }
                this.drawWaypoint(context, waypoint.getIcon().ordinal(), (double)this.ToFormat(90.0f + angle + this.getAngle(waypoint.getPosition())), scale, waypoint.getColor(), ((ModdedWaypoint)waypoint).ydif ? this.mc.field_1724.method_23318() - waypoint.getPosition().field_1351 : 0.0, this.settings.isShowDistance() ? distance : 0);
                continue;
            }
            this.drawWaypoint(context, waypoint.getIcon().ordinal(), (double)this.ToFormat(90.0f + angle + this.getAngle(waypoint.getPosition())), scale, waypoint.getColor(), this.mc.field_1724.method_23318() - waypoint.getPosition().field_1351, this.settings.isShowDistance() ? distance : 0);
        }
        context.method_51448().method_22909();
    }

    private void drawWaypoint(class_332 context, int icon, double angle, float scale, Color color, double hDif, int distance) {
        if (Math.abs(angle) > (double)this.settings.getAngleThresholdWP()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), 0.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - class_3532.method_15363((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.setShaderColor((float)color.r, (float)color.g, (float)color.b, (float)alpha);
        int xOffset = 16 * (icon % 4);
        int yOffset = 16 * (icon / 4);
        context.method_25290(this.WAYPOINTS, -8, -8, (float)xOffset, (float)yOffset, 16, 16, 64, 64);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawRest(context, hDif, distance);
    }

    private void drawWaypoint(class_332 context, class_2960 icon, double angle, float scale, Color color, double hDif, int distance) {
        if (Math.abs(angle) > (double)this.settings.getAngleThresholdWP()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), 0.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - class_3532.method_15363((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.setShaderColor((float)color.r, (float)color.g, (float)color.b, (float)alpha);
        context.method_25290(icon, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawRest(context, hDif, distance);
    }

    private void drawRest(class_332 context, double hDif, int distance) {
        if (hDif < -3.0) {
            context.method_25290(this.ARROWS, 3, 0, 0.0f, 0.0f, 7, 7, 16, 16);
        } else if (hDif > 3.0) {
            context.method_25290(this.ARROWS, 3, 0, 7.0f, 0.0f, 7, 7, 16, 16);
        }
        this.drawDistance(context, distance);
        context.method_51448().method_22909();
    }

    public void removeWaypointByName(String name) {
        this.waypoints.removeIf(w -> w.getName().equals(name));
    }

    public void addWaypoint(Waypoint waypoint) {
        if (this.waypoints.stream().anyMatch(w -> w.getName().equals(waypoint.getName()))) {
            Waypoint tmp = this.waypoints.stream().filter(w -> w.getName().equals(waypoint.getName())).findFirst().get();
            this.waypoints.remove(tmp);
        }
        this.waypoints.add(waypoint);
    }

    public void setWaypoints(Collection waypoints) {
        this.waypoints = waypoints;
    }

    public void removeWaypoint(Waypoint wIn) {
        this.waypoints.removeIf(w -> w.getName().equals(wIn.getName()) && w.getDimension().equals(wIn.getDimension()));
    }

    public void changeWaypoint(Waypoint w) {
        for (Waypoint wp : this.waypoints) {
            if (!wp.getName().equals(w.getName()) || !wp.getDimension().equals(w.getDimension())) continue;
            wp.setEnabled(w.isEnabled());
            return;
        }
    }
}

