/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.config.CompassConfig;
import dlovin.advancedcompass.gui.renderers.RendererWithDistance;
import dlovin.advancedcompass.utils.DrawRanges;
import dlovin.advancedcompass.utils.Group;
import dlovin.advancedcompass.utils.GroupEntity;
import dlovin.advancedcompass.utils.GroupPlayers;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.TextureRes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3959;

public class EntitiesRenderer
extends RendererWithDistance {
    public EntitiesRenderer(class_310 mc, class_327 fontRenderer, CompassConfig settingsValues) {
        super(mc, fontRenderer, settingsValues);
    }

    public void render(class_332 context, float angle, float scale) {
        context.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.settings.isGroupEntities()) {
            if (this.settings.isHideOverlapped()) {
                this.renderGroups(context, angle, scale);
            } else {
                this.renderOverlappedGroups(context, angle, scale);
            }
        } else if (this.settings.isHideOverlapped()) {
            this.renderAllEntities(context, angle, scale);
        } else {
            this.renderOverlappedAllEntities(context, angle, scale);
        }
        context.method_51448().method_22909();
    }

    private void renderGroups(class_332 context, float angle, float scale) {
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        for (Group gEn : GroupUtils.getSortedGroups(this.settings.getMaxDistance(), this.settings.getGroupRadius(), this.settings.isShowPlayers(), this.settings.isHideBehind())) {
            class_243 genPoint = gEn.getPoint();
            TextureCoords coords = HeadUtils.heads.get(gEn instanceof GroupEntity ? gEn.getType() : class_1299.field_6097);
            if (coords == null) continue;
            float mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            double x = this.getX(mobAngle, scale);
            double min = x - (double)((float)coords.width / 2.0f);
            double max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.getOverlapThreshold()))) continue;
            if (gEn instanceof GroupEntity) {
                toRender.add(() -> this.drawMobHead(context, mobAngle, scale, coords, this.settings.isShowDistance() ? (int)this.getFlatDistance(genPoint, this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - genPoint.field_1351));
            } else {
                toRender.add(() -> this.drawPlayerHead(context, mobAngle, scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(genPoint, this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - genPoint.field_1351, this.mc.method_1561().method_3953(((GroupPlayers)gEn).getSample()).method_3931(((GroupPlayers)gEn).getSample()), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private void renderOverlappedGroups(class_332 context, float angle, float scale) {
        for (Group gEn : GroupUtils.getSortedReversedGroups(this.settings.getMaxDistance(), this.settings.getGroupRadius(), this.settings.isShowPlayers(), this.settings.isHideBehind())) {
            class_243 genPoint = gEn.getPoint();
            if (gEn instanceof GroupEntity) {
                this.drawMobHead(context, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, HeadUtils.heads.get(gEn.getType()), this.settings.isShowDistance() ? (int)this.getFlatDistance(genPoint, this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - genPoint.field_1351);
                continue;
            }
            this.drawPlayerHead(context, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(genPoint, this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - genPoint.field_1351, this.mc.method_1561().method_3953(((GroupPlayers)gEn).getSample()).method_3931(((GroupPlayers)gEn).getSample()), HeadUtils.heads.get(class_1299.field_6097));
        }
    }

    private boolean hasLineOfSight(class_1297 en, class_243 vec3) {
        class_243 vec31 = new class_243(en.method_23317(), en.method_23320(), en.method_23321());
        if (vec31.method_1022(vec3) > (double)this.settings.getMaxDistance()) {
            return false;
        }
        if (this.settings.isHideBehind()) {
            return this.mc.field_1687.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724)).method_17783() == class_239.class_240.field_1333;
        }
        return true;
    }

    private void addEntities(Collection<class_1297> entities, Collection<class_1297> players) {
        class_243 vec3 = new class_243(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23320(), this.mc.field_1724.method_23321());
        this.mc.field_1687.method_18112().forEach(e -> {
            if (!e.method_5756((class_1657)this.mc.field_1724)) {
                if (e instanceof class_1308) {
                    if (GroupUtils.types.contains(e.method_5864()) && this.hasLineOfSight((class_1297)e, vec3)) {
                        entities.add((class_1297)e);
                    }
                } else if (e instanceof class_1657 && !e.equals((Object)this.mc.field_1724)) {
                    if (this.mc.field_1724.field_3944.method_2871(e.method_5667()) == null) {
                        if (GroupUtils.types.contains(e.method_5864()) && this.hasLineOfSight((class_1297)e, vec3)) {
                            entities.add((class_1297)e);
                        }
                    } else if (this.settings.isShowPlayers() && !e.method_5715() && this.hasLineOfSight((class_1297)e, vec3)) {
                        players.add((class_1297)e);
                    }
                }
            }
        });
    }

    private void renderAllEntities(class_332 context, float angle, float scale) {
        double max;
        double min;
        double x;
        double mobAngle;
        TextureCoords coords;
        class_243 genPoint;
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        ArrayList<class_1297> players = new ArrayList<class_1297>();
        this.addEntities(entities, players);
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        if (this.settings.isShowPlayers()) {
            for (class_1297 en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.method_5739((class_1297)this.mc.field_1724)))).collect(Collectors.toList())) {
                genPoint = en.method_19538();
                coords = HeadUtils.heads.get(en.method_5864());
                if (coords == null) continue;
                mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
                x = this.getX(mobAngle, scale);
                min = x - (double)((float)coords.width / 2.0f);
                max = x + (double)((float)coords.width / 2.0f);
                if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.getOverlapThreshold()))) continue;
                toRender.add(() -> this.drawPlayerHead(context, mobAngle, scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(en.method_19538(), this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - en.method_23318(), this.mc.method_1561().method_3953(en).method_3931(en), coords));
                listOfAddedHeads.add(new DrawRanges(min, max));
            }
        }
        for (class_1297 en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.method_5739((class_1297)this.mc.field_1724)))).collect(Collectors.toList())) {
            genPoint = en.method_19538();
            coords = HeadUtils.heads.get(en.method_5864());
            if (coords == null) continue;
            mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            x = this.getX(mobAngle, scale);
            min = x - (double)((float)coords.width / 2.0f);
            max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.getOverlapThreshold()))) continue;
            if (en instanceof class_1308) {
                toRender.add(() -> this.drawMobHead(context, mobAngle, scale, coords, this.settings.isShowDistance() ? (int)this.getFlatDistance(genPoint, this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - genPoint.field_1351));
            } else {
                toRender.add(() -> this.drawPlayerHead(context, mobAngle, scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(en.method_19538(), this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - en.method_23318(), this.mc.method_1561().method_3953(en).method_3931(en), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private void renderOverlappedAllEntities(class_332 context, float angle, float scale) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        ArrayList<class_1297> players = new ArrayList<class_1297>();
        this.addEntities(entities, players);
        for (class_1297 en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(((class_1297)e).method_5739((class_1297)this.mc.field_1724))).reversed()).collect(Collectors.toList())) {
            if (en instanceof class_1308) {
                this.drawMobHead(context, this.ToFormat(90.0f + angle + this.getAngle(en.method_19538())), scale, HeadUtils.heads.get(en.method_5864()), this.settings.isShowDistance() ? (int)this.getFlatDistance(en.method_19538(), this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - en.method_23318());
                continue;
            }
            this.drawPlayerHead(context, this.ToFormat(90.0f + angle + this.getAngle(en.method_19538())), scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(en.method_19538(), this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - en.method_23318(), this.mc.method_1561().method_3953(en).method_3931(en), HeadUtils.heads.get(en.method_5864()));
        }
        if (this.settings.isShowPlayers()) {
            this.drawPlayers(context, angle, scale, players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((class_1297)e).method_5739((class_1297)this.mc.field_1724))).reversed()).collect(Collectors.toList()));
        }
    }

    private void drawPlayers(class_332 context, float angle, float scale, Collection<class_1297> players) {
        for (class_1297 en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((class_1297)e).method_5739((class_1297)this.mc.field_1724))).reversed()).collect(Collectors.toList())) {
            this.drawPlayerHead(context, this.ToFormat(90.0f + angle + this.getAngle(en.method_19538())), scale, this.settings.isShowDistance() ? (int)this.getFlatDistance(en.method_19538(), this.mc.field_1724.method_19538()) : 0, this.mc.field_1724.method_23318() - en.method_23318(), this.mc.method_1561().method_3953(en).method_3931(en), HeadUtils.heads.get(en.method_5864()));
        }
    }

    private void drawMobHead(class_332 context, double angle, float scale, TextureCoords tex, int distance, double hDif) {
        if (tex == null || Math.abs(angle) > (double)this.settings.getAngleThreshold()) {
            return;
        }
        if (tex instanceof TextureRes) {
            this.drawMod(context, (TextureRes)tex, angle, scale);
        } else {
            this.drawVanilla(context, tex, angle, scale);
        }
        if (hDif < -3.0) {
            context.method_25290(this.ARROWS, tex.width / 2 - 5, 0, 0.0f, 0.0f, 7, 7, 16, 16);
        } else if (hDif > 3.0) {
            context.method_25290(this.ARROWS, tex.width / 2 - 5, 0, 7.0f, 0.0f, 7, 7, 16, 16);
        }
        RenderSystem.disableBlend();
        this.drawDistance(context, distance);
        context.method_51448().method_22909();
    }

    private void drawVanilla(class_332 context, TextureCoords tex, double angle, float scale) {
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), 0.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - class_3532.method_15363((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        context.method_25290(this.MOBHEADS, -tex.width / 2, -tex.height / 2, (float)tex.xOffset, (float)tex.yOffset, tex.width, tex.height, 256, 256);
    }

    private void drawMod(class_332 context, TextureRes tex, double angle, float scale) {
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), 0.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - class_3532.method_15363((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        context.method_25290(tex.res, -tex.width / 2, -tex.height / 2, (float)tex.xOffset, (float)tex.yOffset, tex.width, tex.height, tex.width, tex.height);
    }

    private void drawPlayerHead(class_332 context, double angle, float scale, int distance, double hDif, class_2960 icon, TextureCoords tex) {
        if (Math.abs(angle) > (double)this.settings.getAngleThreshold()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), 0.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - class_3532.method_15363((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        context.method_25290(this.MOBHEADS, -tex.width / 2, -tex.height / 2, (float)tex.xOffset, (float)tex.yOffset, tex.width, tex.height, 256, 256);
        context.method_25293(icon, -6, -6, 12, 12, 12.0f, 12.0f, 12, 12, 96, 96);
        context.method_25293(icon, -6, -6, 12, 12, 60.0f, 12.0f, 12, 12, 96, 96);
        if (hDif < -3.0) {
            context.method_25290(this.ARROWS, tex.width / 2 - 5, 0, 0.0f, 0.0f, 7, 7, 16, 16);
        } else if (hDif > 3.0) {
            context.method_25290(this.ARROWS, tex.width / 2 - 5, 0, 7.0f, 0.0f, 7, 7, 16, 16);
        }
        RenderSystem.disableBlend();
        this.drawDistance(context, distance);
        context.method_51448().method_22909();
    }
}

