/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.config.CompassConfig;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.references.Translation;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class CompassRenderer
extends IRenderer {
    private final Cardinal[] cardinals = new Cardinal[]{new Cardinal(0, 0, 1), new Cardinal(1, 90, 1), new Cardinal(2, -180, 1), new Cardinal(3, -90, 1)};
    private final Cardinal[] subCardinals = new Cardinal[]{new Cardinal(4, 45, 2), new Cardinal(5, 135, 2), new Cardinal(6, -135, 2), new Cardinal(7, -45, 2)};

    public CompassRenderer(class_310 mc, class_327 fontRenderer, CompassConfig settingsValues) {
        super(mc, fontRenderer, settingsValues);
    }

    public void render(class_332 context, float angle, float scale) {
        context.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Cardinal cardinal : this.cardinals) {
            this.drawCardinal(context, cardinal.getLetter(), this.ToFormat(angle + (float)cardinal.angle), scale, cardinal.width);
        }
        for (Cardinal cardinal : this.subCardinals) {
            this.drawCardinal(context, cardinal.getLetter(), this.ToFormat(angle + (float)cardinal.angle), scale, cardinal.width);
        }
        context.method_51448().method_22909();
    }

    private void drawCardinal(class_332 context, String letter, double angle, float scale, int off) {
        if (Math.abs(angle) > (double)this.settings.getViewAngle()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904(this.getX(angle, scale), (double)((float)(this.settings.getCompassHeight() / 2) * scale), -1.0);
        context.method_51448().method_22905(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        context.method_25290(this.CARDINAL_P, -3, -9, 0.0f, 0.0f, 6, 18, 6, 18);
        context.method_25303(this.mc.field_1772, letter, -off, -4, -1);
        context.method_51448().method_22904(-this.getX(angle, scale), (double)(-11.0f * scale), 1.0);
        context.method_51448().method_22909();
    }

    private class Cardinal {
        class_2561 letter;
        int angle;
        int width;

        Cardinal(int index, int angle, int length) {
            this.letter = Translation.CARDINALS[index];
            this.angle = angle;
            this.width = length * 3;
        }

        String getLetter() {
            return this.letter.getString();
        }
    }
}

