/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public class TextField
extends Widget {
    protected final IPressable onChange;
    protected final class_327 fontRenderer;
    protected String text;
    protected int maxStringLength = 32;
    protected final boolean enableBackgroundDrawing = true;
    protected final boolean isEnabled = true;
    protected boolean isFocused;
    protected boolean field_212956_h;
    protected int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    protected String prevText;
    protected final class_2960 BG = new class_2960("advancedcompass", "textures/gui/widgets/tf_bg.png");
    protected Predicate<String> validator = Objects::nonNull;
    protected BiFunction<String, Integer, class_5481> textFormatter = (string, integer) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);

    public TextField(class_327 fontRenderer, int posX, int posY, int width, int height, String text, IPressable onChange) {
        super(posX, posY, width, height, text);
        this.text = this.prevText = text;
        this.fontRenderer = fontRenderer;
        this.onChange = onChange;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = class_155.method_644((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (!(s1 = new StringBuilder(this.text).replace(i, j, s).toString()).matches("[0-9a-zA-Z\\s]+") && s1.length() != 0) {
            s1 = this.prevText;
        }
        if (this.validator.test(s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    void onTextChanged(String newText) {
        if (!newText.equals(this.prevText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    void delete(int p_212950_1_) {
        if (class_437.method_25441()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.func_238516_r_(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.func_238516_r_(num));
    }

    private int func_238516_r_(int p_238516_1_) {
        return class_156.method_27761((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.field_212956_h) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = class_3532.method_15340((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.field_212956_h = class_437.method_25442();
        if (class_437.method_25439((int)p_231046_1_)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (class_437.method_25438((int)p_231046_1_)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)p_231046_1_)) {
            Objects.requireNonNull(this);
            this.writeText(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)p_231046_1_)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            Objects.requireNonNull(this);
            this.writeText("");
            return true;
        }
        switch (p_231046_1_) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(-1);
                this.field_212956_h = class_437.method_25442();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(1);
                this.field_212956_h = class_437.method_25442();
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.getVisible() && this.method_25370() && this.isEnabled();
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        if (class_155.method_643((char)codePoint)) {
            Objects.requireNonNull(this);
            this.writeText(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25402(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (this.getVisible()) {
            boolean flag = p_231044_1_ >= (double)this.x && p_231044_1_ < (double)(this.x + this.width) && p_231044_3_ >= (double)this.y && p_231044_3_ < (double)(this.y + this.height);
            this.setFocused2(flag);
            if (this.method_25370() && flag && p_231044_5_ == 0) {
                int i = class_3532.method_15357((double)p_231044_1_) - this.x;
                Objects.requireNonNull(this);
                String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
                this.setCursorPosition(this.fontRenderer.method_27523(s, i -= 4).length() + this.lineScrollOffset);
            }
        }
        return false;
    }

    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.field_212956_h = false;
            this.setCursorPosition(0);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float pTicks) {
        super.method_25394(context, mouseX, mouseY, pTicks);
        if (this.getVisible()) {
            class_310 mc = class_310.method_1551();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (this.method_25370()) {
                this.renderBtnBg(context, 0, 16);
            } else if (this.hovered) {
                this.renderBtnBg(context, 16, 0);
            } else {
                this.renderBtnBg(context, 0, 0);
            }
            RenderSystem.disableBlend();
            int enabledColor = 0xE0E0E0;
            int disabledColor = 0x707070;
            Objects.requireNonNull(this);
            int i2 = enabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.method_25370() && flag;
            Objects.requireNonNull(this);
            int l = this.x + 4;
            Objects.requireNonNull(this);
            int i1 = this.y + (this.height - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = context.method_35720(this.fontRenderer, this.textFormatter.apply(s1, this.lineScrollOffset), l, i1, i2);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                context.method_35720(this.fontRenderer, this.textFormatter.apply(s.substring(j), this.cursorPosition), j1, i1, i2);
            }
            if (flag1) {
                if (flag2) {
                    context.method_25294(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    context.method_25303(this.fontRenderer, "_", k1, i1, i2);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.method_1727(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferbuilder.method_22912((double)startX, (double)endY, 0.0).method_1344();
        bufferbuilder.method_22912((double)endX, (double)endY, 0.0).method_1344();
        bufferbuilder.method_22912((double)endX, (double)startY, 0.0).method_1344();
        bufferbuilder.method_22912((double)startX, (double)startY, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.disableColorLogicOp();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        Objects.requireNonNull(this);
        return true;
    }

    @Override
    public void method_25365(boolean focused) {
        this.isFocused = focused;
    }

    @Override
    public boolean method_25370() {
        Objects.requireNonNull(this);
        return this.isFocused;
    }

    @Override
    public boolean method_25405(double p_231047_1_, double p_231047_3_) {
        return p_231047_1_ >= (double)this.x && p_231047_1_ < (double)(this.x + this.width) && p_231047_3_ >= (double)this.y && p_231047_3_ < (double)(this.y + this.height);
    }

    private boolean isEnabled() {
        Objects.requireNonNull(this);
        return true;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = class_3532.method_15340((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public boolean getVisible() {
        return true;
    }

    public void setX(int xIn) {
        this.x = xIn;
    }

    private void renderBtnBg(class_332 context, int offsetX, int offsetY) {
        context.method_25293(this.BG, this.x, this.y, 2, 2, (float)offsetX, (float)offsetY, 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y, 2, 2, (float)(14 + offsetX), (float)offsetY, 2, 2, 32, 32);
        context.method_25293(this.BG, this.x, this.y + this.height - 2, 2, 2, (float)offsetX, (float)(14 + offsetY), 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y + this.height - 2, 2, 2, (float)(14 + offsetX), (float)(14 + offsetY), 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y, this.width - 4, 2, (float)(2 + offsetX), (float)offsetY, 12, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y + 2, 2, this.height - 4, (float)(14 + offsetX), (float)(2 + offsetY), 2, 12, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y + this.height - 2, this.width - 4, 2, (float)(2 + offsetX), (float)(14 + offsetY), 12, 2, 32, 32);
        context.method_25293(this.BG, this.x, this.y + 2, 2, this.height - 4, (float)offsetX, (float)(2 + offsetY), 2, 12, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y + 2, this.width - 4, this.height - 4, (float)(2 + offsetX), (float)(2 + offsetY), 12, 12, 32, 32);
    }

    public static interface IPressable<T extends TextField> {
        public void onChanged(T var1);
    }
}

