/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import dlovin.advancedcompass.gui.config.widgets.TextField;
import java.util.Objects;
import net.minecraft.class_155;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;

public class NumericTextField
extends TextField {
    public final int minValue;
    public final int maxValue;
    private final int defValue;

    public NumericTextField(class_327 font, int posX, int posY, int width, int height, int defValue, TextField.IPressable onChange) {
        this(font, posX, posY, width, height, Integer.MIN_VALUE, Integer.MAX_VALUE, defValue, onChange);
    }

    public NumericTextField(class_327 p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, int minValue, int maxValue, int defValue, TextField.IPressable onChange) {
        super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, "" + defValue, onChange);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defValue = defValue;
        this.prevText = "" + defValue;
        this.text = this.prevText;
        this.setMaxStringLength(String.valueOf(maxValue).length() > String.valueOf(minValue).length() ? String.valueOf(maxValue).length() + 1 : String.valueOf(minValue).length() + 1);
    }

    @Override
    public void writeText(String textToWrite) {
        Object s1;
        int l;
        int i;
        block4: {
            String s;
            i = Math.min(this.cursorPosition, this.selectionEnd);
            int j = Math.max(this.cursorPosition, this.selectionEnd);
            int k = this.maxStringLength - this.text.length() - (i - j);
            if (k < (l = (s = class_155.method_644((String)textToWrite)).length())) {
                s = s.substring(0, k);
                l = k;
            }
            s1 = new StringBuilder(this.text).replace(i, j, s).toString();
            try {
                int num = Integer.parseInt((String)s1);
                s1 = "" + num;
            }
            catch (NumberFormatException ex) {
                if (s.equalsIgnoreCase("-")) break block4;
                s1 = this.prevText;
            }
        }
        if (this.validator.test(s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    @Override
    void onTextChanged(String newText) {
        if (!newText.equals(this.prevText) && this.isNumeric(newText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    @Override
    public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.field_212956_h = class_437.method_25442();
        if (class_437.method_25439((int)p_231046_1_)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (class_437.method_25438((int)p_231046_1_)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)p_231046_1_)) {
            Objects.requireNonNull(this);
            if (this.isNumeric(class_310.method_1551().field_1774.method_1460())) {
                this.writeText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)p_231046_1_)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            Objects.requireNonNull(this);
            this.writeText("");
            return true;
        }
        switch (p_231046_1_) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(-1);
                this.field_212956_h = class_437.method_25442();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(1);
                this.field_212956_h = class_437.method_25442();
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public int getValue() {
        if (this.isNumeric(this.text)) {
            return Integer.parseInt(this.text);
        }
        return this.defValue;
    }

    @Override
    public boolean method_25400(char p_231042_1_, int p_231042_2_) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.isNumeric(Character.toString(p_231042_1_))) {
            Objects.requireNonNull(this);
            this.writeText(Character.toString(p_231042_1_));
            return true;
        }
        if (p_231042_1_ == '-') {
            if (!this.getText().contains("-") && this.cursorPosition == 0) {
                Objects.requireNonNull(this);
                this.writeText(Character.toString(p_231042_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.field_212956_h = false;
            this.setCursorPosition(0);
            if (!this.isNumeric(this.text) || this.text.equals("")) {
                this.setText("" + this.defValue);
            } else {
                try {
                    int num = Integer.parseInt(this.text);
                    if (num < this.minValue) {
                        this.setText("" + this.minValue);
                    } else if (num > this.maxValue) {
                        this.setText("" + this.maxValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

