/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.gui.config.widgets.ButtonWidget;
import dlovin.advancedcompass.utils.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;

public class ColorPicker
extends ButtonWidget {
    private final class_2960 PALETTE = new class_2960("advancedcompass", "textures/gui/widgets/palette.png");
    private BufferedImage paletteImage;
    private Color color;
    private boolean isPicking;
    private int pickerX;
    private int pickerY;

    public ColorPicker(int x, int y, int width, int height, Color color) {
        super(x, y, width, height, "");
        this.color = color;
        this.pickerX = x + width;
        this.pickerY = y;
        int windowWidth = class_310.method_1551().method_22683().method_4486();
        int windowHeight = class_310.method_1551().method_22683().method_4502();
        if (this.pickerX + 128 > windowWidth) {
            this.pickerX = windowWidth - 128;
        }
        if (this.pickerY + 128 > windowHeight) {
            this.pickerY = windowHeight - 128;
        }
        try {
            this.paletteImage = ImageIO.read(((class_3298)class_310.method_1551().method_1478().method_14486(this.PALETTE).get()).method_14482());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hovered) {
            this.playDownSound(class_310.method_1551().method_1483());
            if (this.isPicking) {
                int x = (int)mouseX - this.pickerX;
                int y = (int)mouseY - this.pickerY;
                this.color = this.pickColor(x, y, this.color);
                this.isPicking = !this.isPicking;
                for (ButtonWidget.ButtonClickListener hl : this.listeners) {
                    hl.onClick();
                }
                return true;
            }
            this.isPicking = !this.isPicking;
        } else if (this.isPicking) {
            this.isPicking = !this.isPicking;
        }
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float p_230430_4_) {
        this.hovered = !this.isPicking ? mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height : mouseX >= this.pickerX && mouseY >= this.pickerY && mouseX < this.pickerX + 128 && mouseY < this.pickerY + 128;
        class_310 mc = class_310.method_1551();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        if (this.hovered && !this.isPicking) {
            this.renderBtnBg(context, 16, 0);
        } else {
            this.renderBtnBg(context, 0, 0);
        }
        if (this.isPicking) {
            int x = mouseX - this.pickerX;
            int y = mouseY - this.pickerY;
            Color pickingColor = new Color();
            pickingColor = this.pickColor(x, y, pickingColor);
            RenderSystem.setShaderColor((float)pickingColor.r, (float)pickingColor.g, (float)pickingColor.b, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)1.0f);
        }
        context.method_25293(this.PALETTE, this.x + 4, this.y + 4, this.width - 8, this.height - 8, 0.0f, 0.0f, 1, 1, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isPicking) {
            context.method_25293(this.PALETTE, this.pickerX, this.pickerY, 128, 128, 0.0f, 0.0f, 128, 128, 128, 128);
        }
        RenderSystem.disableBlend();
    }

    @Override
    protected void renderBtnBg(class_332 context, int offsetX, int offsetY) {
        context.method_25293(this.BG, this.x, this.y, 2, 2, (float)offsetX, (float)offsetY, 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y, 2, 2, (float)(14 + offsetX), (float)offsetY, 2, 2, 32, 32);
        context.method_25293(this.BG, this.x, this.y + this.height - 2, 2, 2, (float)offsetX, (float)(14 + offsetY), 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y + this.height - 2, 2, 2, (float)(14 + offsetX), (float)(14 + offsetY), 2, 2, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y, this.width - 4, 2, (float)(2 + offsetX), (float)offsetY, 12, 2, 32, 32);
        context.method_25293(this.BG, this.x + this.width - 2, this.y + 2, 2, this.height - 4, (float)(14 + offsetX), (float)(2 + offsetY), 2, 12, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y + this.height - 2, this.width - 4, 2, (float)(2 + offsetX), (float)(14 + offsetY), 12, 2, 32, 32);
        context.method_25293(this.BG, this.x, this.y + 2, 2, this.height - 4, (float)offsetX, (float)(2 + offsetY), 2, 12, 32, 32);
        context.method_25293(this.BG, this.x + 2, this.y + 2, this.width - 4, this.height - 4, (float)(2 + offsetX), (float)(2 + offsetY), 12, 12, 32, 32);
    }

    private Color pickColor(int x, int y, Color color) {
        if (x < 0 || x > 127 || y < 0 || y > 127) {
            return this.color;
        }
        return color.setFromRGB(this.paletteImage.getRGB(x, y));
    }
}

