/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.config.WaypointAddGui;
import dlovin.advancedcompass.gui.config.WaypointEditGui;
import dlovin.advancedcompass.gui.config.widgets.CheckBox;
import dlovin.advancedcompass.gui.config.widgets.ConfirmButton;
import dlovin.advancedcompass.gui.config.widgets.CustomButton;
import dlovin.advancedcompass.gui.config.widgets.CustomOptionList;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import dlovin.advancedcompass.utils.waypoints.WaypointUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5268;

public class WaypointListGui
extends class_437 {
    CustomOptionList optionList;
    List<Widget> widgetList;
    String dir;

    public WaypointListGui() {
        super((class_2561)class_2561.method_43470((String)"Waypoint list"));
    }

    public void method_25426() {
        this.optionList = new CustomOptionList(this.field_22787, 30, 40, 24, this);
        this.dir = this.field_22787.method_1558() != null ? StringUtils.trimPort(this.field_22787.method_1558().field_3761) : StringUtils.removeIllegal(((class_5268)this.field_22787.method_1576().method_30002().method_8401()).method_150());
        Collection<Waypoint> waypoints = WaypointJsonUtils.getWaypoints(this.dir);
        String[] dimensions = WaypointUtils.getAllDimensions(waypoints);
        int index = 0;
        for (int i = 0; i < dimensions.length; ++i) {
            Collection<Waypoint> tmpList = WaypointUtils.getWaypointsInDimension(dimensions[i], waypoints);
            String[] dim = dimensions[i].split(":");
            String dimension = String.format("(%s) %s:", StringUtils.capitalize(dim[0]), StringUtils.capitalize(dim[dim.length - 1]));
            this.optionList.addWidgetToRow(new TextWidget(this.field_22789 / 2, 10, 0xFFFFFF, TextWidget.TextAlign.CENTER, dimension, this.field_22793), index++);
            for (Waypoint w : tmpList) {
                CustomButton tmp = new CustomButton(this.field_22789 / 2 + 10, 2, 16, 16, 16, "", new class_2960("advancedcompass", "textures/gui/widgets/settings_btn.png"), false);
                this.optionList.addWidgetToRow(tmp, index);
                tmp.addListener(() -> this.changeWaypoint(w));
                tmp = new ConfirmButton(this.field_22789 / 2 + 36, 2, 16, 16, 16, "", new class_2960("advancedcompass", "textures/gui/widgets/delete_btn.png"), new Widget.ITooltip[]{(wi, c, x, y) -> c.method_51438(this.field_22793, Translation.DELETE_BTN, x, y), (wi, c, x, y) -> c.method_51438(this.field_22793, Translation.CONFIRM_BTN, x, y)});
                this.optionList.addWidgetToRow(tmp, index);
                int finalIndex = index;
                tmp.addListener(() -> this.deleteWaypoint(finalIndex, w, this.dir));
                this.optionList.addWidgetToRow(new CheckBox(this.field_22789 / 2 + 62, 0, 20, 20, t -> this.changeEnabled(t, w), w.isEnabled()), index);
                this.optionList.addWidgetToRow(new TextWidget(this.field_22789 / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.RIGHT, w.getName(), this.field_22793), index++);
            }
        }
        this.widgetList = new ArrayList<Widget>();
        CustomButton tmp = new CustomButton(this.field_22789 / 2 - 100, this.field_22790 - 30, 60, 20, Translation.HIDEALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.HideAll());
        this.method_25396().add(tmp);
        tmp = new CustomButton(this.field_22789 / 2 - 30, this.field_22790 - 30, 60, 20, Translation.ADDNEW.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.addNew());
        this.method_25396().add(tmp);
        tmp = new CustomButton(this.field_22789 / 2 + 40, this.field_22790 - 30, 60, 20, Translation.SHOWALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.ShowAll());
        this.method_25396().add(tmp);
        this.method_25396().add(this.optionList);
    }

    private void ShowAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || ((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = true;
            ((CheckBox)w).onChanged();
        }
    }

    private void addNew() {
        this.field_22787.method_1507((class_437)new WaypointAddGui(true));
    }

    private void HideAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || !((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = false;
            ((CheckBox)w).onChanged();
        }
    }

    private void deleteWaypoint(int r, Waypoint w, String dir) {
        this.optionList.removeRow(r);
        WaypointJsonUtils.deleteWaypoint(dir, w);
        AdvancedCompass.getInstance().getCompassGui().removeWaypoint(w);
    }

    private void changeWaypoint(Waypoint w) {
        this.field_22787.method_1507((class_437)new WaypointEditGui(w));
    }

    private void changeEnabled(CheckBox t, Waypoint w) {
        w.setEnabled(t.checked);
        WaypointJsonUtils.changeWaypoint(this.dir, w.getName(), w, true);
        AdvancedCompass.getInstance().getCompassGui().changeWaypoint(w);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_25420(context);
        this.optionList.method_25394(context, mouseX, mouseY, partialTick);
        this.widgetList.forEach(w -> w.method_25394(context, mouseX, mouseY, partialTick));
        this.optionList.renderTooltips(context, mouseX, mouseY);
        this.widgetList.forEach(w -> w.renderTooltip(context, mouseX, mouseY));
    }

    public boolean method_25403(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.optionList.method_25403(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }
}

